/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.spectralogic.ds3client.commands.GetObjectsRequest;
import java.util.Objects;
import java.util.UUID;

public class S3Object {
    @JsonProperty(value="BucketId")
    private String bucketId;
    @JsonProperty(value="CreationDate")
    private String creationDate;
    @JsonProperty(value="Id")
    private UUID id;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Type")
    private GetObjectsRequest.ObjectType type;
    @JsonProperty(value="Version")
    private long version;

    public S3Object() {
    }

    public S3Object(String bucketId, String creationDate, UUID id, String name, GetObjectsRequest.ObjectType type, long version) {
        this.bucketId = bucketId;
        this.creationDate = creationDate;
        this.id = id;
        this.name = name;
        this.type = type;
        this.version = version;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(String bucketId) {
        this.bucketId = bucketId;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GetObjectsRequest.ObjectType getType() {
        return this.type;
    }

    public void setType(GetObjectsRequest.ObjectType type) {
        this.type = type;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String toString() {
        return "<S3Object><BucketID>" + this.bucketId + "</BucketID><CreationDate>" + this.creationDate + "</CreationDate><Id>" + this.id.toString() + "</Id><Name>" + this.name + "</Name><Type>" + this.type.toString() + "</Type><Version>" + Long.toString(this.version) + "</Version></S3Object>";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bucketId, this.name, this.id, this.creationDate, this.type, this.version});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof S3Object)) {
            return false;
        }
        S3Object s3obj = (S3Object)obj;
        return this.bucketId.equals(s3obj.getBucketId()) && this.creationDate.equals(s3obj.getCreationDate()) && this.id.equals(s3obj.getId()) && this.name.equals(s3obj.getName()) && this.type == s3obj.getType() && this.version == s3obj.getVersion();
    }
}

