/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.channels;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.spectralogic.ds3client.helpers.TruncateNotAllowedException;
import com.spectralogic.ds3client.helpers.channels.BlobComparator;
import com.spectralogic.ds3client.models.Range;
import com.spectralogic.ds3client.models.bulk.BulkObject;
import com.spectralogic.ds3client.utils.Guard;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Collection;
import java.util.HashMap;

public class RangedSeekableByteChannel
implements SeekableByteChannel {
    private final SeekableByteChannel byteChannel;
    private final ImmutableMultimap<BulkObject, Range> ranges;
    private final ImmutableMap<BulkObject, Long> blobSizes;
    private final ImmutableMap<BulkObject, Long> startingOffsetForBlob;
    private final long size;
    private long position;
    private boolean open;

    public static RangedSeekableByteChannel wrap(SeekableByteChannel byteChannel, ImmutableMultimap<BulkObject, Range> ranges) throws IOException {
        return new RangedSeekableByteChannel(byteChannel, ranges);
    }

    public RangedSeekableByteChannel(SeekableByteChannel byteChannel, ImmutableMultimap<BulkObject, Range> ranges) throws IOException {
        this.byteChannel = byteChannel;
        this.ranges = ranges;
        this.position = 0L;
        this.open = true;
        this.size = RangedSeekableByteChannel.getSize(byteChannel.size(), ranges);
        this.blobSizes = RangedSeekableByteChannel.computesBlobSize(ranges);
        this.startingOffsetForBlob = RangedSeekableByteChannel.computeRealBlobOffset(this.blobSizes);
    }

    private static ImmutableMap<BulkObject, Long> computeRealBlobOffset(ImmutableMap<BulkObject, Long> blobLengths) {
        if (Guard.isMapNullOrEmpty(blobLengths)) {
            return ImmutableMap.of();
        }
        HashMap<Object, Long> realOffsets = new HashMap<Object, Long>();
        ImmutableSortedSet bulkObjects = ImmutableSortedSet.copyOf(BlobComparator.create(), (Collection)blobLengths.keySet());
        ImmutableList sortedList = ImmutableList.copyOf((Collection)bulkObjects);
        int listLength = sortedList.size();
        realOffsets.put(sortedList.get(0), 0L);
        for (int i = 1; i < listLength; ++i) {
            BulkObject previous = (BulkObject)sortedList.get(i - 1);
            long previousOffset = (Long)realOffsets.get(previous);
            long previousSize = (Long)blobLengths.get((Object)previous);
            realOffsets.put(sortedList.get(i), previousOffset + previousSize);
        }
        return ImmutableMap.copyOf(realOffsets);
    }

    private static ImmutableMap<BulkObject, Long> computesBlobSize(ImmutableMultimap<BulkObject, Range> ranges) {
        if (Guard.isMultiMapNullOrEmpty(ranges)) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BulkObject blob : ranges.keySet()) {
            builder.put((Object)blob, (Object)RangedSeekableByteChannel.sizeOfBulkRange((ImmutableCollection<Range>)ranges.get((Object)blob)));
        }
        return builder.build();
    }

    private static long getSize(long channelSize, ImmutableMultimap<BulkObject, Range> ranges) {
        if (Guard.isMultiMapNullOrEmpty(ranges)) {
            return channelSize;
        }
        return RangedSeekableByteChannel.sizeOfBulkRange((ImmutableCollection<Range>)ranges.values());
    }

    private static long sizeOfBulkRange(ImmutableCollection<Range> ranges) {
        long rangeSize = 0L;
        for (Range range : ranges) {
            rangeSize += range.getLength();
        }
        return rangeSize;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.checkClosed();
        int bytesRead = this.byteChannel.read(dst);
        this.position += (long)bytesRead;
        return bytesRead;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checkClosed();
        int bytesWritten = this.byteChannel.write(src);
        this.position += (long)bytesWritten;
        return bytesWritten;
    }

    @Override
    public long position() throws IOException {
        this.checkClosed();
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.checkClosed();
        if (!this.checkRange(newPosition)) {
            throw new IllegalStateException("The requested position is outside the acceptable ranges for this stream");
        }
        this.position = newPosition;
        BulkObject blob = RangedSeekableByteChannel.getBlobFromPosition(this.ranges, newPosition);
        if (blob == null) {
            this.byteChannel.position(newPosition);
        } else {
            long offsetInBlob = newPosition - blob.getOffset();
            long blobOffset = (Long)this.startingOffsetForBlob.get((Object)blob);
            this.byteChannel.position(blobOffset + offsetInBlob);
        }
        return this;
    }

    private boolean checkRange(long position) {
        if (Guard.isMultiMapNullOrEmpty(this.ranges)) {
            return true;
        }
        BulkObject blob = RangedSeekableByteChannel.getBlobFromPosition(this.ranges, position);
        if (blob == null) {
            return false;
        }
        long blobSize = (Long)this.blobSizes.get((Object)blob);
        return blob.getOffset() <= position && position < blob.getOffset() + blobSize;
    }

    private static BulkObject getBlobFromPosition(ImmutableMultimap<BulkObject, Range> blobs, long position) {
        if (Guard.isMultiMapNullOrEmpty(blobs)) {
            return null;
        }
        for (BulkObject bulkObject : blobs.keySet()) {
            if (bulkObject.getOffset() > position || position >= bulkObject.getOffset() + bulkObject.getLength()) continue;
            return bulkObject;
        }
        return null;
    }

    @Override
    public long size() throws IOException {
        this.checkClosed();
        return this.size;
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new TruncateNotAllowedException();
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        try {
            this.byteChannel.close();
        }
        finally {
            this.open = false;
        }
    }

    private void checkClosed() {
        if (!this.open) {
            throw new IllegalStateException("Object already closed");
        }
    }
}

