/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.collect.Sets;
import com.spectralogic.ds3client.helpers.DataTransferredListener;
import com.spectralogic.ds3client.helpers.ObjectCompletedListener;
import com.spectralogic.ds3client.helpers.ObjectPart;
import com.spectralogic.ds3client.helpers.ObjectPartComparator;
import com.spectralogic.ds3client.helpers.ObjectPartTracker;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

class ObjectPartTrackerImpl
implements ObjectPartTracker {
    private final String name;
    private final TreeSet<ObjectPart> parts;
    private final Set<DataTransferredListener> dataTransferredListeners = Sets.newIdentityHashSet();
    private final Set<ObjectCompletedListener> objectCompletedListeners = Sets.newIdentityHashSet();

    public ObjectPartTrackerImpl(String name, Collection<ObjectPart> parts) {
        this.name = name;
        this.parts = new TreeSet<ObjectPart>(ObjectPartComparator.instance());
        this.parts.addAll(parts);
        this.validateParts();
    }

    @Override
    public synchronized ObjectPartTracker attachDataTransferredListener(DataTransferredListener listener) {
        this.dataTransferredListeners.add(listener);
        return this;
    }

    @Override
    public synchronized ObjectPartTracker attachObjectCompletedListener(ObjectCompletedListener listener) {
        this.objectCompletedListeners.add(listener);
        return this;
    }

    @Override
    public void removeDataTransferredListener(DataTransferredListener listener) {
        this.dataTransferredListeners.remove(listener);
    }

    @Override
    public void removeObjectCompletedListener(ObjectCompletedListener listener) {
        this.objectCompletedListeners.remove(listener);
    }

    @Override
    public synchronized void completePart(ObjectPart part) {
        ObjectPart existingPart = this.parts.floor(part);
        if (existingPart == null) {
            throw new IllegalStateException("The object part was not available to be marked completed.");
        }
        if (part.getEnd() > existingPart.getEnd()) {
            throw new IllegalStateException("The object part was not available to be marked completed.");
        }
        this.parts.remove(existingPart);
        if (part.getOffset() > existingPart.getOffset()) {
            this.parts.add(new ObjectPart(existingPart.getOffset(), part.getOffset() - existingPart.getOffset()));
        }
        if (part.getEnd() < existingPart.getEnd()) {
            this.parts.add(new ObjectPart(part.getEnd() + 1L, existingPart.getEnd() - part.getEnd()));
        }
        this.onDataTransferred(part.getLength());
        if (this.parts.size() == 0) {
            this.onObjectCompleted();
        }
    }

    @Override
    public synchronized boolean containsPart(ObjectPart part) {
        ObjectPart existingPart = this.parts.ceiling(part);
        return existingPart != null && existingPart.getLength() == part.getLength();
    }

    private synchronized void validateParts() {
        long lastEnd = -1L;
        for (ObjectPart part : this.parts) {
            if (part.getOffset() <= lastEnd) {
                throw new InvalidParameterException();
            }
            lastEnd = part.getEnd();
        }
    }

    private void onDataTransferred(long size) {
        for (DataTransferredListener listener : this.dataTransferredListeners) {
            listener.dataTransferred(size);
        }
    }

    private void onObjectCompleted() {
        for (ObjectCompletedListener listener : this.objectCompletedListeners) {
            listener.objectCompleted(this.name);
        }
    }
}

