/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.models.bulk.MasterObjectList;
import java.util.UUID;

abstract class JobImpl
implements Ds3ClientHelpers.Job {
    protected final Ds3Client client;
    protected final MasterObjectList masterObjectList;
    protected boolean running = false;
    protected int maxParallelRequests = 10;

    public JobImpl(Ds3Client client, MasterObjectList masterObjectList) {
        this.client = client;
        this.masterObjectList = masterObjectList;
    }

    @Override
    public UUID getJobId() {
        if (this.masterObjectList == null) {
            return null;
        }
        return this.masterObjectList.getJobId();
    }

    @Override
    public String getBucketName() {
        if (this.masterObjectList == null) {
            return null;
        }
        return this.masterObjectList.getBucketName();
    }

    @Override
    public Ds3ClientHelpers.Job withMaxParallelRequests(int maxParallelRequests) {
        this.maxParallelRequests = maxParallelRequests;
        return this;
    }

    protected void checkRunning() {
        if (this.running) {
            throw new IllegalStateException("You cannot modify a job after calling transfer");
        }
    }
}

