/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.BulkGetRequest;
import com.spectralogic.ds3client.commands.BulkGetResponse;
import com.spectralogic.ds3client.commands.BulkPutRequest;
import com.spectralogic.ds3client.commands.BulkPutResponse;
import com.spectralogic.ds3client.commands.GetBucketRequest;
import com.spectralogic.ds3client.commands.GetBucketResponse;
import com.spectralogic.ds3client.commands.HeadBucketRequest;
import com.spectralogic.ds3client.commands.HeadBucketResponse;
import com.spectralogic.ds3client.commands.ModifyJobRequest;
import com.spectralogic.ds3client.commands.ModifyJobResponse;
import com.spectralogic.ds3client.commands.PutBucketRequest;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.helpers.JobRecoveryException;
import com.spectralogic.ds3client.helpers.ReadJobImpl;
import com.spectralogic.ds3client.helpers.WriteJobImpl;
import com.spectralogic.ds3client.helpers.options.ReadJobOptions;
import com.spectralogic.ds3client.helpers.options.WriteJobOptions;
import com.spectralogic.ds3client.helpers.util.PartialObjectHelpers;
import com.spectralogic.ds3client.models.Checksum;
import com.spectralogic.ds3client.models.Contents;
import com.spectralogic.ds3client.models.ListBucketResult;
import com.spectralogic.ds3client.models.Range;
import com.spectralogic.ds3client.models.bulk.ChunkClientProcessingOrderGuarantee;
import com.spectralogic.ds3client.models.bulk.Ds3Object;
import com.spectralogic.ds3client.models.bulk.RequestType;
import com.spectralogic.ds3client.networking.FailedRequestException;
import com.spectralogic.ds3client.serializer.XmlProcessingException;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Ds3ClientHelpersImpl
extends Ds3ClientHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(Ds3ClientHelpersImpl.class);
    private static final int DEFAULT_MAX_KEYS = 1000;
    private final Ds3Client client;
    private final int retryAfter;

    public Ds3ClientHelpersImpl(Ds3Client client) {
        this(client, -1);
    }

    public Ds3ClientHelpersImpl(Ds3Client client, int retryAfter) {
        this.client = client;
        this.retryAfter = retryAfter;
    }

    @Override
    public Ds3ClientHelpers.Job startWriteJob(String bucket, Iterable<Ds3Object> objectsToWrite) throws SignatureException, IOException, XmlProcessingException {
        return this.innerStartWriteJob(bucket, objectsToWrite, WriteJobOptions.create());
    }

    @Override
    public Ds3ClientHelpers.Job startWriteJob(String bucket, Iterable<Ds3Object> objectsToWrite, WriteJobOptions options) throws SignatureException, IOException, XmlProcessingException {
        if (options == null) {
            return this.innerStartWriteJob(bucket, objectsToWrite, WriteJobOptions.create());
        }
        return this.innerStartWriteJob(bucket, objectsToWrite, options);
    }

    private Ds3ClientHelpers.Job innerStartWriteJob(String bucket, Iterable<Ds3Object> objectsToWrite, WriteJobOptions options) throws SignatureException, IOException, XmlProcessingException {
        BulkPutResponse prime = this.client.bulkPut(new BulkPutRequest(bucket, Lists.newArrayList(objectsToWrite)).withPriority(options.getPriority()).withWriteOptimization(options.getWriteOptimization()).withMaxUploadSize(options.getMaxUploadSize()));
        return new WriteJobImpl(this.client, prime.getResult(), this.retryAfter, options.getChecksumType());
    }

    @Override
    public Ds3ClientHelpers.Job startReadJob(String bucket, Iterable<Ds3Object> objectsToRead) throws SignatureException, IOException, XmlProcessingException {
        return this.innerStartReadJob(bucket, objectsToRead, ReadJobOptions.create());
    }

    @Override
    public Ds3ClientHelpers.Job startReadJob(String bucket, Iterable<Ds3Object> objectsToRead, ReadJobOptions options) throws SignatureException, IOException, XmlProcessingException {
        if (options == null) {
            return this.innerStartReadJob(bucket, objectsToRead, ReadJobOptions.create());
        }
        return this.innerStartReadJob(bucket, objectsToRead, options);
    }

    private Ds3ClientHelpers.Job innerStartReadJob(String bucket, Iterable<Ds3Object> objectsToRead, ReadJobOptions options) throws SignatureException, IOException, XmlProcessingException {
        ArrayList objects = Lists.newArrayList(objectsToRead);
        BulkGetResponse prime = this.client.bulkGet(new BulkGetRequest(bucket, objects).withChunkOrdering(ChunkClientProcessingOrderGuarantee.NONE).withPriority(options.getPriority()));
        ImmutableMultimap<String, Range> partialRanges = PartialObjectHelpers.getPartialObjectsRanges(objects);
        return new ReadJobImpl(this.client, prime.getResult(), partialRanges, this.retryAfter);
    }

    @Override
    public Ds3ClientHelpers.Job startReadAllJob(String bucket) throws SignatureException, IOException, XmlProcessingException {
        return this.innerStartReadAllJob(bucket, ReadJobOptions.create());
    }

    @Override
    public Ds3ClientHelpers.Job startReadAllJob(String bucket, ReadJobOptions options) throws SignatureException, IOException, XmlProcessingException {
        if (options == null) {
            return this.innerStartReadAllJob(bucket, ReadJobOptions.create());
        }
        return this.innerStartReadAllJob(bucket, options);
    }

    private Ds3ClientHelpers.Job innerStartReadAllJob(String bucket, ReadJobOptions options) throws SignatureException, IOException, XmlProcessingException {
        Iterable<Contents> contentsList = this.listObjects(bucket);
        ArrayList<Ds3Object> ds3Objects = new ArrayList<Ds3Object>();
        for (Contents contents : contentsList) {
            ds3Objects.add(new Ds3Object(contents.getKey()));
        }
        return this.startReadJob(bucket, ds3Objects, options);
    }

    @Override
    public Ds3ClientHelpers.Job recoverWriteJob(UUID jobId) throws SignatureException, IOException, XmlProcessingException, JobRecoveryException {
        ModifyJobResponse jobResponse = this.client.modifyJob(new ModifyJobRequest(jobId));
        if (RequestType.PUT != jobResponse.getMasterObjectList().getRequestType()) {
            throw new JobRecoveryException(RequestType.PUT.toString(), jobResponse.getMasterObjectList().getRequestType().toString());
        }
        return new WriteJobImpl(this.client, jobResponse.getMasterObjectList(), this.retryAfter, Checksum.Type.NONE);
    }

    @Override
    public Ds3ClientHelpers.Job recoverReadJob(UUID jobId) throws SignatureException, IOException, XmlProcessingException, JobRecoveryException {
        ModifyJobResponse jobResponse = this.client.modifyJob(new ModifyJobRequest(jobId));
        if (RequestType.GET != jobResponse.getMasterObjectList().getRequestType()) {
            throw new JobRecoveryException(RequestType.GET.toString(), jobResponse.getMasterObjectList().getRequestType().toString());
        }
        return new ReadJobImpl(this.client, jobResponse.getMasterObjectList(), (ImmutableMultimap<String, Range>)ImmutableMultimap.of(), this.retryAfter);
    }

    @Override
    public void ensureBucketExists(String bucket) throws IOException, SignatureException {
        HeadBucketResponse response = this.client.headBucket(new HeadBucketRequest(bucket));
        if (response.getStatus() == HeadBucketResponse.Status.DOESNTEXIST) {
            try {
                this.client.putBucket(new PutBucketRequest(bucket));
            }
            catch (FailedRequestException e) {
                if (e.getStatusCode() != 409) {
                    throw e;
                }
                LOG.warn("Creating " + bucket + " failed because it was created by another thread or process");
            }
        }
    }

    @Override
    public Iterable<Contents> listObjects(String bucket) throws SignatureException, IOException {
        return this.listObjects(bucket, null);
    }

    @Override
    public Iterable<Contents> listObjects(String bucket, String keyPrefix) throws SignatureException, IOException {
        return this.listObjects(bucket, keyPrefix, null, Integer.MAX_VALUE);
    }

    @Override
    public Iterable<Contents> listObjects(String bucket, String keyPrefix, String nextMarker) throws SignatureException, IOException {
        return this.listObjects(bucket, keyPrefix, nextMarker, Integer.MAX_VALUE);
    }

    @Override
    public Iterable<Contents> listObjects(String bucket, String keyPrefix, String nextMarker, int maxKeys) throws SignatureException, IOException {
        ArrayList<Contents> contentList = new ArrayList<Contents>();
        int remainingKeys = maxKeys;
        boolean isTruncated = false;
        String marker = nextMarker;
        if (nextMarker != null) {
            isTruncated = true;
        }
        do {
            GetBucketRequest request = new GetBucketRequest(bucket);
            request.withMaxKeys(Math.min(remainingKeys, 1000));
            if (keyPrefix != null) {
                request.withPrefix(keyPrefix);
            }
            if (isTruncated) {
                request.withNextMarker(marker);
            }
            GetBucketResponse response = this.client.getBucket(request);
            ListBucketResult result = response.getResult();
            isTruncated = result.isTruncated();
            marker = result.getNextMarker();
            remainingKeys -= result.getContentsList().size();
            for (Contents contents : result.getContentsList()) {
                contentList.add(contents);
            }
        } while (isTruncated && remainingKeys > 0);
        return contentList;
    }

    @Override
    public Iterable<Ds3Object> listObjectsForDirectory(final Path directory) throws IOException {
        final ArrayList<Ds3Object> objects = new ArrayList<Ds3Object>();
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                objects.add(new Ds3Object(directory.relativize(file).toString().replace("\\", "/"), Files.size(file)));
                return FileVisitResult.CONTINUE;
            }
        });
        return objects;
    }

    @Override
    public Iterable<Ds3Object> addPrefixToDs3ObjectsList(Iterable<Ds3Object> objectsList, String prefix) {
        ArrayList<Ds3Object> newObjectsList = new ArrayList<Ds3Object>();
        for (Ds3Object object : objectsList) {
            Ds3Object tmpObj = new Ds3Object(prefix + object.getName(), object.getSize());
            newObjectsList.add(tmpObj);
        }
        return newObjectsList;
    }

    @Override
    public Iterable<Ds3Object> removePrefixFromDs3ObjectsList(Iterable<Ds3Object> objectsList, String prefix) {
        ArrayList<Ds3Object> newObjectsList = new ArrayList<Ds3Object>();
        for (Ds3Object object : objectsList) {
            newObjectsList.add(new Ds3Object(Ds3ClientHelpersImpl.stripLeadingPath(object.getName(), prefix), object.getSize()));
        }
        return newObjectsList;
    }
}

