/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.helpers.ChecksumFunction;
import com.spectralogic.ds3client.helpers.ChecksumListener;
import com.spectralogic.ds3client.helpers.DataTransferredListener;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpersImpl;
import com.spectralogic.ds3client.helpers.JobRecoveryException;
import com.spectralogic.ds3client.helpers.MetadataReceivedListener;
import com.spectralogic.ds3client.helpers.ObjectCompletedListener;
import com.spectralogic.ds3client.helpers.options.ReadJobOptions;
import com.spectralogic.ds3client.helpers.options.WriteJobOptions;
import com.spectralogic.ds3client.models.Contents;
import com.spectralogic.ds3client.models.bulk.Ds3Object;
import com.spectralogic.ds3client.serializer.XmlProcessingException;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.security.SignatureException;
import java.util.Map;
import java.util.UUID;

public abstract class Ds3ClientHelpers {
    public static Ds3ClientHelpers wrap(Ds3Client client) {
        return new Ds3ClientHelpersImpl(client);
    }

    public static Ds3ClientHelpers wrap(Ds3Client client, int retryAfter) {
        return new Ds3ClientHelpersImpl(client, retryAfter);
    }

    public abstract Job startWriteJob(String var1, Iterable<Ds3Object> var2) throws SignatureException, IOException, XmlProcessingException;

    public abstract Job startWriteJob(String var1, Iterable<Ds3Object> var2, WriteJobOptions var3) throws SignatureException, IOException, XmlProcessingException;

    public abstract Job startReadJob(String var1, Iterable<Ds3Object> var2) throws SignatureException, IOException, XmlProcessingException;

    public abstract Job startReadJob(String var1, Iterable<Ds3Object> var2, ReadJobOptions var3) throws SignatureException, IOException, XmlProcessingException;

    public abstract Job startReadAllJob(String var1) throws SignatureException, IOException, XmlProcessingException;

    public abstract Job startReadAllJob(String var1, ReadJobOptions var2) throws SignatureException, IOException, XmlProcessingException;

    public abstract Job recoverWriteJob(UUID var1) throws SignatureException, IOException, XmlProcessingException, JobRecoveryException;

    public abstract Job recoverReadJob(UUID var1) throws SignatureException, IOException, XmlProcessingException, JobRecoveryException;

    public abstract void ensureBucketExists(String var1) throws IOException, SignatureException;

    public abstract Iterable<Contents> listObjects(String var1) throws SignatureException, IOException;

    public abstract Iterable<Contents> listObjects(String var1, String var2) throws SignatureException, IOException;

    public abstract Iterable<Contents> listObjects(String var1, String var2, String var3) throws SignatureException, IOException;

    public abstract Iterable<Contents> listObjects(String var1, String var2, String var3, int var4) throws SignatureException, IOException;

    public abstract Iterable<Ds3Object> listObjectsForDirectory(Path var1) throws IOException;

    public abstract Iterable<Ds3Object> addPrefixToDs3ObjectsList(Iterable<Ds3Object> var1, String var2);

    public abstract Iterable<Ds3Object> removePrefixFromDs3ObjectsList(Iterable<Ds3Object> var1, String var2);

    public static String stripLeadingPath(String objectName, String prefix) {
        String returnString = objectName;
        if (objectName.startsWith(prefix)) {
            returnString = objectName.substring(prefix.length());
        }
        return returnString;
    }

    public static interface MetadataAccess {
        public Map<String, String> getMetadataValue(String var1);
    }

    public static interface Job {
        public UUID getJobId();

        public String getBucketName();

        public void attachDataTransferredListener(DataTransferredListener var1);

        public void attachObjectCompletedListener(ObjectCompletedListener var1);

        public void removeDataTransferredListener(DataTransferredListener var1);

        public void removeObjectCompletedListener(ObjectCompletedListener var1);

        public void attachMetadataReceivedListener(MetadataReceivedListener var1);

        public void removeMetadataReceivedListener(MetadataReceivedListener var1);

        public void attachChecksumListener(ChecksumListener var1);

        public void removeChecksumListener(ChecksumListener var1);

        public Job withMaxParallelRequests(int var1);

        public Job withMetadata(MetadataAccess var1);

        public Job withChecksum(ChecksumFunction var1);

        public void transfer(ObjectChannelBuilder var1) throws SignatureException, IOException, XmlProcessingException;
    }

    public static interface ObjectChannelBuilder {
        public SeekableByteChannel buildChannel(String var1) throws IOException;
    }
}

