/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.HttpVerb;
import com.spectralogic.ds3client.commands.AbstractRequest;
import com.spectralogic.ds3client.models.Checksum;
import com.spectralogic.ds3client.utils.SeekableByteChannelInputStream;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.UUID;

public class PutObjectRequest
extends AbstractRequest {
    private final String bucketName;
    private final String objectName;
    private final UUID jobId;
    private final SeekableByteChannel channel;
    private final InputStream stream;
    private final long size;
    private final long offset;
    private Checksum checksum = Checksum.none();
    private Checksum.Type checksumType = Checksum.Type.NONE;
    public static final String AMZ_META_HEADER = "x-amz-meta-";
    public String contentType = "application/octet-stream";

    public PutObjectRequest(String bucketName, String objectName, UUID jobId, long size, long offset, SeekableByteChannel channel) {
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.channel = channel;
        this.stream = new SeekableByteChannelInputStream(channel);
        this.size = size;
        this.jobId = jobId;
        this.offset = offset;
        this.getQueryParams().put("job", jobId.toString());
        this.getQueryParams().put("offset", Long.toString(offset));
    }

    public PutObjectRequest withChecksum(Checksum checksum) {
        return this.withChecksum(checksum, Checksum.Type.MD5);
    }

    public PutObjectRequest withChecksum(Checksum checksum, Checksum.Type checksumType) {
        this.checksum = checksum;
        this.checksumType = checksumType;
        return this;
    }

    public PutObjectRequest withMetaData(String key, String value) {
        String modifiedKey = !key.toLowerCase().startsWith(AMZ_META_HEADER) ? AMZ_META_HEADER + key : key;
        this.getHeaders().put((Object)modifiedKey, (Object)value);
        return this;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public PutObjectRequest withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public Checksum getChecksum() {
        return this.checksum;
    }

    @Override
    public Checksum.Type getChecksumType() {
        return this.checksumType;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName + "/" + this.objectName;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public InputStream getStream() {
        return this.stream;
    }

    public SeekableByteChannel getChannel() {
        return this.channel;
    }

    public UUID getJobId() {
        return this.jobId;
    }

    public long getOffset() {
        return this.offset;
    }
}

