/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.google.common.collect.ImmutableMultimap;
import com.spectralogic.ds3client.networking.Headers;
import com.spectralogic.ds3client.networking.Metadata;
import com.spectralogic.ds3client.utils.Guard;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class MetadataImpl
implements Metadata {
    private static final String X_AMZ_META = "x-amz-meta-";
    final ImmutableMultimap<String, String> metadata;

    MetadataImpl(Headers headers) {
        this.metadata = MetadataImpl.genMetadata(headers);
    }

    private static ImmutableMultimap<String, String> genMetadata(Headers headers) {
        if (headers == null || Guard.isNullOrEmpty(headers.keys())) {
            return ImmutableMultimap.of();
        }
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
        for (String key : headers.keys()) {
            if (!key.startsWith(X_AMZ_META)) continue;
            String name = key.substring(X_AMZ_META.length());
            List<String> values = MetadataImpl.getValues(headers, key);
            mapBuilder.putAll((Object)name, values);
        }
        return mapBuilder.build();
    }

    private static List<String> getValues(Headers headers, String key) {
        List<String> valueList = headers.get(key);
        ArrayList<String> returnList = new ArrayList<String>(valueList.size());
        for (String valueEntry : valueList) {
            String[] splitEntries;
            for (String splitEntry : splitEntries = valueEntry.split(",")) {
                returnList.add(splitEntry.trim());
            }
        }
        return returnList;
    }

    @Override
    public List<String> get(String name) {
        return this.metadata.get((Object)name.toLowerCase()).asList();
    }

    @Override
    public Set<String> keys() {
        return this.metadata.keySet();
    }
}

