/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.spectralogic.ds3client.HttpVerb;
import com.spectralogic.ds3client.commands.AbstractRequest;
import com.spectralogic.ds3client.models.Range;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.UUID;
import org.apache.http.entity.ContentType;

public class GetObjectRequest
extends AbstractRequest {
    private final String bucketName;
    private final String objectName;
    private final long offset;
    private final UUID jobId;
    private final WritableByteChannel channel;
    private ImmutableCollection<Range> byteRanges = null;

    public GetObjectRequest(String bucketName, String objectName, long offset, UUID jobId, WritableByteChannel channel) {
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.jobId = jobId;
        this.offset = offset;
        this.channel = channel;
        this.getQueryParams().put("job", jobId.toString());
        this.getQueryParams().put("offset", Long.toString(offset));
    }

    public GetObjectRequest withByteRanges(Range ... byteRanges) {
        if (byteRanges != null) {
            this.setRanges((ImmutableList<Range>)ImmutableList.copyOf((Object[])byteRanges));
        }
        return this;
    }

    public GetObjectRequest withByteRanges(Collection<Range> byteRanges) {
        if (byteRanges != null) {
            this.setRanges((ImmutableList<Range>)ImmutableList.copyOf(byteRanges));
        }
        return this;
    }

    private void setRanges(ImmutableList<Range> byteRanges) {
        this.byteRanges = byteRanges;
        if (this.getHeaders().containsKey((Object)"Range")) {
            this.getHeaders().removeAll((Object)"Range");
        }
        this.getHeaders().put((Object)"Range", (Object)GetObjectRequest.buildRangeHeaderText(byteRanges));
    }

    private static String buildRangeHeaderText(ImmutableList<Range> byteRanges) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Range range : byteRanges) {
            builder.add((Object)String.format("%d-%d", range.getStart(), range.getEnd()));
        }
        Joiner stringJoiner = Joiner.on((String)",");
        return "bytes=" + stringJoiner.join((Iterable)builder.build());
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Collection<Range> getByteRanges() {
        return this.byteRanges;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName + "/" + this.objectName;
    }

    @Override
    public String getContentType() {
        return ContentType.APPLICATION_OCTET_STREAM.getMimeType();
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    public UUID getJobId() {
        return this.jobId;
    }

    public WritableByteChannel getDestinationChannel() {
        return this.channel;
    }
}

