/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.HttpVerb;
import com.spectralogic.ds3client.commands.AbstractRequest;
import java.util.UUID;

public class GetAvailableJobChunksRequest
extends AbstractRequest {
    private final UUID jobId;
    private int preferredNumberOfChunks = 3;

    public UUID getJobId() {
        return this.jobId;
    }

    public GetAvailableJobChunksRequest(UUID jobId) {
        this.jobId = jobId;
        this.getQueryParams().put("job", jobId.toString());
    }

    public GetAvailableJobChunksRequest withPreferredNumberOfChunks(int numberOfChunks) {
        this.preferredNumberOfChunks = numberOfChunks;
        this.getQueryParams().put("preferred_number_of_chunks", Integer.toString(numberOfChunks));
        return this;
    }

    @Override
    public String getPath() {
        return "/_rest_/job_chunk";
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    public int getPreferredNumberOfChunks() {
        return this.preferredNumberOfChunks;
    }
}

