/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.BulkCommand;
import com.spectralogic.ds3client.HttpVerb;
import com.spectralogic.ds3client.commands.AbstractRequest;
import com.spectralogic.ds3client.models.bulk.ChunkClientProcessingOrderGuarantee;
import com.spectralogic.ds3client.models.bulk.Ds3Object;
import com.spectralogic.ds3client.models.bulk.Ds3ObjectList;
import com.spectralogic.ds3client.models.bulk.Priority;
import com.spectralogic.ds3client.models.bulk.WriteOptimization;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;

abstract class BulkRequest
extends AbstractRequest {
    private final String bucket;
    private final List<Ds3Object> ds3Objects;
    private InputStream stream;
    private long size;
    private Priority priority;
    private WriteOptimization writeOptimization;
    protected ChunkClientProcessingOrderGuarantee chunkOrdering;

    public BulkRequest(String bucket, List<Ds3Object> objects) {
        this.bucket = bucket;
        this.ds3Objects = objects;
    }

    public BulkRequest withPriority(Priority priority) {
        this.priority = priority;
        return this;
    }

    public BulkRequest withWriteOptimization(WriteOptimization writeOptimization) {
        this.writeOptimization = writeOptimization;
        return this;
    }

    private InputStream generateStream() {
        Ds3ObjectList objects = new Ds3ObjectList();
        objects.setObjects(this.ds3Objects);
        objects.setPriority(this.priority);
        objects.setWriteOptimization(this.writeOptimization);
        objects.setChunkClientProcessingOrderGuarantee(this.chunkOrdering);
        StringBuilder xmlOutputBuilder = new StringBuilder();
        if (this.getCommand() == BulkCommand.PUT) {
            xmlOutputBuilder.append(XmlOutput.toXml(objects, true));
        } else {
            xmlOutputBuilder.append(XmlOutput.toXml(objects, false));
        }
        byte[] stringBytes = xmlOutputBuilder.toString().getBytes(Charset.forName("UTF-8"));
        this.size = stringBytes.length;
        return new ByteArrayInputStream(stringBytes);
    }

    public String getBucket() {
        return this.bucket;
    }

    public List<Ds3Object> getObjects() {
        return this.ds3Objects;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getPath() {
        return "/_rest_/bucket/" + this.bucket;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    public abstract BulkCommand getCommand();

    @Override
    public InputStream getStream() {
        if (this.stream == null) {
            this.stream = this.generateStream();
        }
        return this.stream;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public WriteOptimization getWriteOptimization() {
        return this.writeOptimization;
    }
}

