/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client;

import com.spectralogic.ds3client.HeadersImpl;
import com.spectralogic.ds3client.networking.Headers;
import com.spectralogic.ds3client.networking.WebResponse;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.http.client.methods.CloseableHttpResponse;

class WebResponseImpl
implements WebResponse {
    private final CloseableHttpResponse response;
    private final Headers headers;

    public WebResponseImpl(@Nonnull CloseableHttpResponse response) {
        this.response = response;
        this.headers = new HeadersImpl(this.response.getAllHeaders());
    }

    @Override
    public InputStream getResponseStream() throws IOException {
        if (this.response.getEntity() == null) {
            return null;
        }
        return this.response.getEntity().getContent();
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }
}

