/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client;

import com.google.common.collect.ImmutableMultimap;
import com.spectralogic.ds3client.networking.Headers;
import java.util.List;
import java.util.Set;
import org.apache.http.Header;

class HeadersImpl
implements Headers {
    private final ImmutableMultimap<String, String> headers;

    HeadersImpl(Header[] allHeaders) {
        this.headers = HeadersImpl.toMultiMap(allHeaders);
    }

    private static ImmutableMultimap<String, String> toMultiMap(Header[] headers) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Header header : headers) {
            builder.put((Object)header.getName().toLowerCase(), (Object)header.getValue());
        }
        return builder.build();
    }

    @Override
    public List<String> get(String key) {
        return this.headers.get((Object)key.toLowerCase()).asList();
    }

    @Override
    public Set<String> keys() {
        return this.headers.keySet();
    }
}

