/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.DisabledChecksumCompute;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.VoidStatusOutputStream;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import ch.cyberduck.core.shared.AppendWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;

public class LocalWriteFeature
extends AppendWriteFeature<Void> {
    private final LocalSession session;

    protected LocalWriteFeature(LocalSession session) {
        super((Session)session);
        this.session = session;
    }

    public StatusOutputStream<Void> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            java.nio.file.Path p = this.session.toPath(file);
            HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
            options.add(StandardOpenOption.WRITE);
            if (status.isAppend()) {
                if (!status.isExists()) {
                    options.add(StandardOpenOption.CREATE);
                }
            } else if (status.isExists()) {
                if (file.isSymbolicLink()) {
                    Files.delete(p);
                    options.add(StandardOpenOption.CREATE);
                } else {
                    options.add(StandardOpenOption.TRUNCATE_EXISTING);
                }
            } else {
                options.add(StandardOpenOption.CREATE_NEW);
            }
            FileChannel channel = FileChannel.open(this.session.toPath(file), (OpenOption[])options.stream().toArray(OpenOption[]::new));
            channel.position(status.getOffset());
            return new VoidStatusOutputStream(Channels.newOutputStream(channel));
        }
        catch (IOException e) {
            throw new LocalExceptionMappingService().map("Upload {0} failed", e, file);
        }
    }

    public boolean temporary() {
        return true;
    }

    public boolean random() {
        return true;
    }

    public ChecksumCompute checksum(Path file) {
        return new DisabledChecksumCompute();
    }
}

