/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.nio.LocalAttributesFinderFeature;
import ch.cyberduck.core.nio.LocalCopyFeature;
import ch.cyberduck.core.nio.LocalDeleteFeature;
import ch.cyberduck.core.nio.LocalDirectoryFeature;
import ch.cyberduck.core.nio.LocalFindFeature;
import ch.cyberduck.core.nio.LocalHomeFinderFeature;
import ch.cyberduck.core.nio.LocalListService;
import ch.cyberduck.core.nio.LocalMoveFeature;
import ch.cyberduck.core.nio.LocalQuotaFeature;
import ch.cyberduck.core.nio.LocalReadFeature;
import ch.cyberduck.core.nio.LocalSymlinkFeature;
import ch.cyberduck.core.nio.LocalTimestampFeature;
import ch.cyberduck.core.nio.LocalTouchFeature;
import ch.cyberduck.core.nio.LocalUnixPermissionFeature;
import ch.cyberduck.core.nio.LocalWriteFeature;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import org.apache.log4j.Logger;

public class LocalSession
extends Session<FileSystem> {
    private static final Logger log = Logger.getLogger(LocalSession.class);
    private Object lock;

    public LocalSession(Host h) {
        super(h);
    }

    public LocalSession(Host h, X509TrustManager trust, X509KeyManager key) {
        super(h);
    }

    public java.nio.file.Path toPath(Path file) throws LocalAccessDeniedException {
        return this.toPath(file.getAbsolute());
    }

    public java.nio.file.Path toPath(String path) throws LocalAccessDeniedException {
        try {
            return ((FileSystem)this.client).getPath(path.replaceFirst("^/(.:(?:/|\\\\)?)", "$1"), new String[0]);
        }
        catch (InvalidPathException e) {
            throw new LocalAccessDeniedException(e.getReason(), (Throwable)e);
        }
    }

    protected FileSystem connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) throws BackgroundException {
        return FileSystems.getDefault();
    }

    public void login(Proxy proxy, HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        Path home = new LocalHomeFinderFeature(this).find();
        try {
            this.lock = LocalFactory.get((String)this.toPath(home).toString()).lock(true);
        }
        catch (LocalAccessDeniedException e) {
            log.debug((Object)String.format("Ignore failure obtaining lock for %s", home));
        }
    }

    protected void logout() throws BackgroundException {
        Path home = new LocalHomeFinderFeature(this).find();
        LocalFactory.get((String)this.toPath(home).toString()).release(this.lock);
    }

    protected boolean isPosixFilesystem() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new LocalListService(this);
        }
        if (type == Touch.class) {
            return (T)new LocalTouchFeature(this);
        }
        if (type == Find.class) {
            return (T)new LocalFindFeature(this);
        }
        if (type == Attributes.class) {
            return (T)new LocalAttributesFinderFeature(this);
        }
        if (type == Read.class) {
            return (T)new LocalReadFeature(this);
        }
        if (type == Write.class) {
            return (T)((Object)new LocalWriteFeature(this));
        }
        if (type == Delete.class) {
            return (T)new LocalDeleteFeature(this);
        }
        if (type == Move.class) {
            return (T)new LocalMoveFeature(this);
        }
        if (type == Copy.class) {
            return (T)new LocalCopyFeature(this);
        }
        if (type == Directory.class) {
            return (T)new LocalDirectoryFeature(this);
        }
        if (type == Symlink.class && this.isPosixFilesystem()) {
            return (T)new LocalSymlinkFeature(this);
        }
        if (type == UnixPermission.class && this.isPosixFilesystem()) {
            return (T)((Object)new LocalUnixPermissionFeature(this));
        }
        if (type == Home.class) {
            return (T)((Object)new LocalHomeFinderFeature(this));
        }
        if (type == Quota.class) {
            return (T)new LocalQuotaFeature(this);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new LocalTimestampFeature(this));
        }
        return (T)super._getFeature(type);
    }
}

