.\" dpkg manual page - dpkg-buildpackage(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2007-2008 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2008-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2012 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-buildpackage 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
dpkg\-buildpackage \- build binary or source packages from sources
.
.SH SYNOPSIS
.B dpkg\-buildpackage
.RI [ option ...]
.
.SH DESCRIPTION
.B dpkg\-buildpackage
is a program that automates the process of building a Debian package. It
consists of the following steps:
.IP \fB1.\fP 3
It prepares the build environment by setting various environment
variables (see \fBENVIRONMENT\fP), runs the \fBinit\fP hook, and calls
\fBdpkg\-source \-\-before\-build\fP (unless \fB\-T\fP or \fB\-\-target\fP
has been used).
.IP \fB2.\fP 3
It checks that the build-dependencies and build-conflicts
are satisfied (unless \fB\-d\fP or \fB\-\-no\-check\-builddeps\fP is specified).
.IP \fB3.\fP 3
If a specific target has been selected with the \fB\-T\fP or \fB\-\-target\fP
option, it calls that target and stops here. Otherwise it runs the
\fBpreclean\fP hook and calls \fBfakeroot debian/rules clean\fP to
clean the build-tree (unless \fB\-nc\fP or \fB\-\-no\-pre\-clean\fP
is specified).
.IP \fB4.\fP 3
It runs the \fBsource\fP hook and calls \fBdpkg\-source \-b\fP to generate
the source package (if a \fBsource\fP build has been requested with
\fB\-\-build\fP or equivalent options).
.IP \fB5.\fP 3
It runs the \fBbuild\fP hook and calls \fBdebian/rules\fP \fIbuild-target\fP,
then runs the \fBbinary\fP hook followed by \fBfakeroot debian/rules\fP
\fIbinary-target\fP (unless a source-only build has been requested with
\fB\-\-build=source\fP or equivalent options).
Note that \fIbuild-target\fR and \fIbinary-target\fP are either \fBbuild\fP
and \fBbinary\fP (default case, or if an \fBany\fP and \fBall\fP build
has been requested with \fB\-\-build\fP or equivalent options), or
\fBbuild\-arch\fP and \fBbinary\-arch\fP (if an \fBany\fP and not \fBall\fP
build has been requested with \fB\-\-build\fP or equivalent options), or
\fBbuild\-indep\fP and \fBbinary\-indep\fP (if an \fBall\fP and not \fBany\fP
build has been requested with \fB\-\-build\fP or equivalent options).
.IP \fB6.\fP 3
Unless a source-only build has been requested, it runs the \fBbuildinfo\fP
hook and calls \fBdpkg\-genbuildinfo\fP to generate a \fB.buildinfo\fP file.
Several \fBdpkg\-buildpackage\fP options are forwarded to
\fBdpkg\-genbuildinfo\fP.
.IP \fB7.\fP 3
It runs the \fBchanges\fP hook and calls \fBdpkg\-genchanges\fP to
generate a \fB.changes\fP file.
The name of the \fB.changes\fP file will depend on the type of build and
will be as specific as necessary but not more;
for a build that includes \fBany\fP the name will be
\fIsource-name\fP\fB_\fP\fIsource-version\fP\fB_\fP\fIarch\fP\fB.changes\fP,
or otherwise for a build that includes \fBall\fP the name will be
\fIsource-name\fP\fB_\fP\fIsource-version\fP\fB_\fP\fBall.changes\fP,
or otherwise for a build that includes \fBsource\fP the name will be
\fIsource-name\fP\fB_\fP\fIsource-version\fP\fB_\fP\fBsource.changes\fP.
Many \fBdpkg\-buildpackage\fP options are forwarded to
\fBdpkg\-genchanges\fP.
.IP \fB8.\fP 3
It runs the \fBpostclean\fP hook and if \fB\-tc\fP or \fB\-\-post\-clean\fP
is specified, it will call \fBfakeroot debian/rules clean\fP again.
.IP \fB9.\fP 3
It calls \fBdpkg\-source \-\-after\-build\fP.
.IP \fB10.\fP 3
It runs the \fBcheck\fP hook and calls a package checker for the
\fB.changes\fP file (if a command is specified in \fBDEB_CHECK_COMMAND\fP or
with \fB\-\-check\-command\fP).
.IP \fB11.\fP 3
It runs the \fBsign\fP hook and calls \fBgpg2\fP or \fBgpg\fP to sign
the \fB.dsc\fP file (if any, unless \fB\-us\fP or \fB\-\-unsigned\-source\fP
is specified or on UNRELEASED builds), and the \fB.changes\fP file
(unless \fB\-uc\fP or \fB\-\-unsigned\-changes\fP is specified or on
UNRELEASED builds).
.IP \fB12.\fP 3
It runs the \fBdone\fP hook.
.
.SH OPTIONS
All long options can be specified both on the command line and in the
\fBdpkg\-buildpackage\fP system and user configuration files.
Each line in the configuration file is either an option (exactly the same
as the command line option but without leading hyphens) or a comment (if
it starts with a ‘\fB#\fP’).

.TP
.BI \-\-build= type
Specifies the build \fItype\fP from a comma-separated list of components
(since dpkg 1.18.5).
Passed to \fBdpkg\-genchanges\fP.

The allowed values are:
.RS
.TP
.B source
Builds the source package.
Note: when using this value standalone and if what you want is simply to
(re-)build the source package, using \fBdpkg\-source\fP is always better
as it does not require any build dependencies to be installed to be able
to call the \fBclean\fP target.
.TP
.B any
Builds the architecture specific binary packages.
.TP
.B all
Builds the architecture independent binary packages.
.TP
.B binary
Builds the architecture specific and independent binary packages.
This is an alias for \fBany,all\fP.
.TP
.B full
Builds everything.
This is an alias for \fBsource,any,all\fP, and the same as the default
case when no build option is specified.
.RE
.TP
.B \-g
Equivalent to \fB\-\-build=source,all\fP (since dpkg 1.17.11).
.TP
.B \-G
Equivalent to \fB\-\-build=source,any\fP (since dpkg 1.17.11).
.TP
.B \-b
Equivalent to \fB\-\-build=binary\fP or \fB\-\-build=any,all\fP.
.TP
.B \-B
Equivalent to \fB\-\-build=any\fP.
.TP
.B \-A
Equivalent to \fB\-\-build=all\fP.
.TP
.B \-S
Equivalent to \fB\-\-build=source\fP.
.TP
.B \-F
Equivalent to \fB\-\-build=full\fP, \fB\-\-build=source,binary\fP or
\fB\-\-build=source,any,all\fP (since dpkg 1.15.8).
.TP
.BI \-\-target= target
.TQ
.BI "\-\-target " target
.TQ
.BR \-T ", " \-\-rules\-target= \fItarget\fP
Calls \fBdebian/rules\fP \fItarget\fP after having setup the build
environment and stops the package build process here (since dpkg 1.15.0,
long option since dpkg 1.18.8).
If \fB\-\-as\-root\fP is also given, then the command is executed
as root (see \fB\-\-root\-command\fP).
Note that known targets that are required to
be run as root do not need this option (i.e. the \fBclean\fP, \fBbinary\fP,
\fBbinary\-arch\fP and \fBbinary\-indep\fP targets).
.TP
.B \-\-as\-root
Only meaningful together with \fB\-\-target\fP (since dpkg 1.15.0).
Requires that the target be run with root rights.
.TP
.B \-si
.TQ
.B \-sa
.TQ
.B \-sd
.TQ
.BI \-v version
.TQ
.BI \-C changes-description
.TQ
.BR \-m ", " \-\-release\-by= \fImaintainer-address\fP
.TQ
.BR \-e ", " \-\-build\-by= \fImaintainer-address\fP
Passed unchanged to \fBdpkg\-genchanges\fP. See its manual page.
.TP
.BR \-a ", " \-\-host\-arch " \fIarchitecture\fP"
Specify the Debian architecture we build for (long option since dpkg 1.17.17).
The architecture of the
machine we build on is determined automatically, and is also the default
for the host machine.
.TP
.BR \-t ", " \-\-host\-type " \fIgnu-system-type\fP"
Specify the GNU system type we build for (long option since dpkg 1.17.17).
It can be used in place
of \fB\-\-host\-arch\fP or as a complement to override the default GNU system type
of the host Debian architecture.
.TP
.BR \-\-target\-arch " \fIarchitecture\fP"
Specify the Debian architecture the binaries built will build for
(since dpkg 1.17.17).
The default value is the host machine.
.TP
.BR \-\-target\-type " \fIgnu-system-type\fP"
Specify the GNU system type the binaries built will build for
(since dpkg 1.17.17).
It can be
used in place of \fB\-\-target\-arch\fP or as a complement to override the
default GNU system type of the target Debian architecture.
.TP
.BR \-P ", " \-\-build\-profiles= \fIprofile\fP[ , ...]
Specify the profile(s) we build, as a comma-separated list (since dpkg 1.17.2,
long option since dpkg 1.18.8).
The default
behavior is to build for no specific profile. Also sets them (as a space
separated list) as the \fBDEB_BUILD_PROFILES\fP environment variable which
allows, for example, \fBdebian/rules\fP files to use this information for
conditional builds.
.TP
.BR \-j ", " \-\-jobs [=\fIjobs\fP|\fBauto\fP]
Number of jobs allowed to be run simultaneously, number of jobs matching
the number of online processors if \fBauto\fP is specified
(since dpkg 1.17.10), or unlimited number if \fIjobs\fP is not specified,
equivalent to the
.BR make (1)
option of the same name (since dpkg 1.14.7, long option since dpkg 1.18.8).
Will add itself to the \fBMAKEFLAGS\fP
environment variable, which should cause all subsequent make
invocations to inherit the option, thus forcing the parallel setting on
the packaging (and possibly the upstream build system if that uses make)
regardless of their support for parallel builds, which might cause build
failures.
Also adds \fBparallel=\fP\fIjobs\fP or
\fBparallel\fP to the \fBDEB_BUILD_OPTIONS\fP environment variable which
allows debian/rules files to use this information for their own purposes.
The \fB\-j\fP value will override the \fBparallel=\fP\fIjobs\fP or
\fBparallel\fP option in the \fBDEB_BUILD_OPTIONS\fP environment variable.
Note that the \fBauto\fP value will get replaced by the actual number of
currently active processors, and as such will not get propagated to any
child process. If the number of online processors cannot be inferred then
the code will fallback to using an unlimited number.
.TP
.BR \-J ", " \-\-jobs\-try [=\fIjobs\fP|\fBauto\fP]
This option (since dpkg 1.18.2, long option since dpkg 1.18.8) is equivalent
to the \fB\-j\fP option except that it does not set the \fBMAKEFLAGS\fP
environment variable, and as such it is safer to use with any package
including those that are not parallel-build safe.

\fBauto\fP is the default behavior (since dpkg 1.18.11). Setting the number
of jobs to 1 will restore a serial behavior.
.TP
.BR \-D ", " \-\-check\-builddeps
Check build dependencies and conflicts; abort if unsatisfied (long option
since dpkg 1.18.8).
This is the default behavior.
.TP
.BR \-d ", " \-\-no\-check\-builddeps
Do not check build dependencies and conflicts (long option since dpkg 1.18.8).
.TP
.B \-\-ignore\-builtin\-builddeps
Do not check built-in build dependencies and conflicts (since dpkg 1.18.2).
These are the distribution specific implicit build dependencies usually
required in a build environment, the so called Build-Essential package set.
.TP
.BR \-nc ", " \-\-no\-pre\-clean
Do not clean the source tree (long option since dpkg 1.18.8).
Implies \fB\-b\fP if nothing else has been selected among \fB\-F\fP,
\fB\-g\fP, \fB\-G\fP, \fB\-B\fP, \fB\-A\fP or \fB\-S\fP.
Implies \fB\-d\fP with \fB\-S\fP (since dpkg 1.18.0).
.TP
.BR \-\-pre\-clean
Clean the source tree before building (since dpkg 1.18.8).
.TP
.BR \-tc ", " \-\-post\-clean
Clean the source tree (using
.I gain-root-command
.BR "debian/rules clean" )
after the package has been built (long option since dpkg 1.18.8).
.TP
.BR \-r ", " \-\-root\-command= \fIgain-root-command\fP
When
.B dpkg\-buildpackage
needs to execute part of the build process as root, it prefixes the
command it executes with
.I gain-root-command
if one has been specified (long option since dpkg 1.18.8).
Otherwise, if none has been specified,
\fBfakeroot\fP will be used by default, if the command is present.
.I gain-root-command
should start with the name of a program on the
.B PATH
and will get as arguments the name of the real command to run and the
arguments it should take.
.I gain-root-command
can include parameters (they must be space-separated) but no shell
metacharacters.
.I gain-root-command
might typically be
.BR fakeroot ", " sudo ", " super " or " really .
.B su
is not suitable, since it can only invoke the user's shell with
.B \-c
instead of passing arguments individually to the command to be run.
.TP
.BR \-R ", " \-\-rules-file= \fIrules-file\fP
Building a Debian package usually involves invoking
.B debian/rules
as a command with several standard parameters (since dpkg 1.14.17,
long option since dpkg 1.18.8).
With this option it's
possible to use another program invocation to build the package (it can
include space separated parameters).
Alternatively it can be used to execute the standard rules file with
another make program (for example by using
.B /usr/local/bin/make \-f debian/rules
as \fIrules-file\fR).
.TP
.BI \-\-check\-command= check-command
Command used to check the \fB.changes\fP file itself and any artifact built
referenced in the file (since dpkg 1.17.6).
The command should take the \fB.changes\fP pathname
as an argument. This command will usually be \fBlintian\fP.
.TP
.BI \-\-check\-option= opt
Pass option \fIopt\fP to the \fIcheck-command\fP specified with
\fBDEB_CHECK_COMMAND\fP or \fB\-\-check\-command\fP (since dpkg 1.17.6).
Can be used multiple times.
.TP
.BI \-\-hook\- hook-name = hook-command
Set the specified shell code \fIhook-command\fP as the hook \fIhook-name\fP,
which will run at the times specified in the run steps (since dpkg 1.17.6).
The hooks will
always be executed even if the following action is not performed (except
for the \fBbinary\fP hook).

Note: Hooks can affect the build process, and cause build failures if
their commands fail, so watch out for unintended consequences.

The current \fIhook-name\fP supported are:

.B init preclean source build binary changes postclean check sign done

The \fIhook-command\fP supports the following substitution format string,
which will get applied to it before execution:

.RS
.TP
.B %%
A single % character.
.TP
.B %a
A boolean value (0 or 1), representing whether the following action is
being performed.
.TP
.B %p
The source package name.
.TP
.B %v
The source package version.
.TP
.B %s
The source package version (without the epoch).
.TP
.B %u
The upstream version.
.RE
.TP
.BI \-\-buildinfo-id= identifier
Specify the identifier part of the \fB.buildinfo\fP file name
(since dpkg 1.18.11).
By default, \fBdpkg\-buildpackage\fP will create an identifier using
the current time and the first characters of the MD5 hash.
An arbitrary identifier can be specified as a replacement.
The identifier has the same restriction as package names: it must consist
only of lower case letters (a-z), digits (0-9), plus (+) and minus (\-)
signs, and periods (.), be at least two characters long and must start
with an alphanumeric character.
.TP
.BI \-\-buildinfo\-option= opt
Pass option \fIopt\fP to \fBdpkg\-genbuildinfo\fP (since dpkg 1.18.11).
Can be used multiple times.
.TP
.BR \-p ", " \-\-sign\-command= \fIsign-command\fP
When \fBdpkg\-buildpackage\fP needs to execute GPG to sign a source
control (\fB.dsc\fP) file or a \fB.changes\fP file it will run
\fIsign-command\fP (searching the \fBPATH\fP if necessary) instead of
\fBgpg2\fP or \fBgpg\fP (long option since dpkg 1.18.8).
\fIsign-command\fP will get all the arguments
that \fBgpg2\fP or \fBgpg\fP would have gotten. \fIsign-command\fP
should not contain spaces or any other shell metacharacters.
.TP
.BR \-k ", " \-\-sign\-key= \fIkey-id\fP
Specify a key-ID to use when signing packages (long option since dpkg 1.18.8).
.TP
.BR \-us ", " \-\-unsigned\-source
Do not sign the source package (long option since dpkg 1.18.8).
.TP
.BR \-uc ", " \-\-unsigned\-changes
Do not sign the \fB.changes\fP file (long option since dpkg 1.18.8).
.TP
.BR \-\-force\-sign
Force the signing of the resulting files (since dpkg 1.17.0), regardless of
\fB\-us\fP, \fB\-\-unsigned\-source\fP, \fB\-uc\fP, \fB\-\-unsigned\-changes\fP
or other internal heuristics.
.TP
.BR \-sn
.TQ
.BR \-ss
.TQ
.BR \-sA
.TQ
.BR \-sk
.TQ
.BR \-su
.TQ
.BR \-sr
.TQ
.BR \-sK
.TQ
.BR \-sU
.TQ
.BR \-sR
.TQ
.BR \-i ", " \-\-diff\-ignore [=\fIregex\fP]
.TQ
.BR \-I ", " \-\-tar\-ignore [=\fIpattern\fP]
.TQ
.BR \-z ", " \-\-compression\-level= \fIlevel\fP
.TQ
.BR \-Z ", " \-\-compression= \fIcompressor\fP
Passed unchanged to \fBdpkg\-source\fP. See its manual page.
.TP
.BI \-\-source\-option= opt
Pass option \fIopt\fP to \fBdpkg\-source\fP (since dpkg 1.15.6).
Can be used multiple times.
.TP
.BI \-\-changes\-option= opt
Pass option \fIopt\fP to \fBdpkg\-genchanges\fP (since dpkg 1.15.6).
Can be used multiple times.
.TP
.BI \-\-admindir= dir
.TQ
.BI "\-\-admindir " dir
Change the location of the \fBdpkg\fR database (since dpkg 1.14.0).
The default location is \fI%ADMINDIR%\fP.
.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
.TP
.BR \-\-version
Show the version and exit.
.
.SH ENVIRONMENT
.SS External environment
.TP
.B DEB_CHECK_COMMAND
If set, it will be used as the command to check the \fB.changes\fP file
(since dpkg 1.17.6).
Overridden by the \fB\-\-check\-command\fP option.
.TP
.B DEB_SIGN_KEYID
If set, it will be used to sign the \fB.changes\fP and \fB.dsc\fP files
(since dpkg 1.17.2).
Overridden by the \fB\-\-sign\-key\fP option.
.TP
.B DEB_BUILD_OPTIONS
If set, it will contain a space-separated list of options that might
affect the build process in \fIdebian/rules\fP, and the behavior of some
dpkg commands.

With \fBnocheck\fP the \fBDEB_CHECK_COMMAND\fP variable will be ignored.
With \fBparallel=\fP\fIN\fP the parallel jobs will be set to \fIN\fP,
overridden by the \fB\-\-jobs\-try\fP option.
.TP
.B DEB_BUILD_PROFILES
If set, it will be used as the active build profile(s) for the package
being built (since dpkg 1.17.2).
It is a space separated list of profile names.
Overridden by the \fB\-P\fP option.
.TP
.B DPKG_COLORS
Sets the color mode (since dpkg 1.18.5).
The currently accepted values are: \fBauto\fP (default), \fBalways\fP and
\fBnever\fP.

.SS Internal environment
Even if \fBdpkg\-buildpackage\fP exports some variables, \fBdebian/rules\fP
should not rely on their presence and should instead use the
respective interface to retrieve the needed values, because that
file is the main entry point to build packages and running it
standalone should be supported.

.TP
.B DEB_BUILD_*
.TQ
.B DEB_HOST_*
.TQ
.B DEB_TARGET_*
\fBdpkg\-architecture\fP is called with the \fB\-a\fP and \fB\-t\fP
parameters forwarded. Any variable that is output by its \fB\-s\fP
option is integrated in the build environment.

.TP
.B SOURCE_DATE_EPOCH
This variable is set to the Unix timestamp since the epoch of the
latest entry in \fIdebian/changelog\fP, if it is not already defined.
.
.SH FILES
.TP
.I %PKGCONFDIR%/buildpackage.conf
System wide configuration file
.TP
.IR $XDG_CONFIG_HOME/dpkg/buildpackage.conf " or"
.TQ
.I $HOME/.config/dpkg/buildpackage.conf
User configuration file.
.
.SH NOTES
.SS Compiler flags are no longer exported
Between dpkg 1.14.17 and 1.16.1, \fBdpkg\-buildpackage\fP
exported compiler flags (\fBCFLAGS\fP, \fBCXXFLAGS\fP, \fBFFLAGS\fP,
\fBCPPFLAGS\fP and \fBLDFLAGS\fP) with values as returned
by \fBdpkg\-buildflags\fP. This is no longer the case.
.SS Default build targets
\fBdpkg\-buildpackage\fP is using the \fBbuild\-arch\fP and
\fBbuild\-indep\fP targets since dpkg 1.16.2. Those targets are thus
mandatory. But to avoid breakages of existing packages, and ease
the transition, if the source package does not build both architecture
independent and dependent binary packages (since dpkg 1.18.8) it will
fallback to use the \fBbuild\fP target if \fBmake \-f debian/rules \-qn\fP
\fIbuild-target\fP returns 2 as exit code.
.SH BUGS
It should be possible to specify spaces and shell metacharacters
and initial arguments for
.IR gain-root-command " and " sign-command .
.
.SH SEE ALSO
.ad l
.BR dpkg\-source (1),
.BR dpkg\-architecture (1),
.BR dpkg\-buildflags (1),
.BR dpkg\-genbuildinfo (1),
.BR dpkg\-genchanges (1),
.BR fakeroot (1),
.BR lintian (1),
.BR gpg2 (1),
.BR gpg (1).
