/***************************************************************************
 *            dyndns.c
 *
 *  Fri Sep 10 23:09:19 2004
 *  Copyright  2004  User
 *  Email
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "ddnsu.h"
#include "dyndns.h"
#include "base64_encode.h"

int update_dyndns() {
	FILE *rfile;
	char b64user[512];
	char userpass[256];
	char somecraptmpvar[1025];
	char recv_buffer[1025];
	char getline[4097];
	int donewithheaders = 0;
	int sock;

char *dyndns_word[] = {
	"good", "nochg", "badauth", "!donator", "badsys", "badagent",
	"nohost", "!yours", "abuse", "numhost", "dnserr", NULL
};
int dyndns_code[] = {
	DYNDNS_UPDATE_COMPLETE, DYNDNS_NOIPCHG_COMPLETE, DYNDNS_BADAUTH_ERROR,
	DYNDNS_NOTDONATOR_ERROR, DYNDNS_BADSYS_ERROR, DYNDNS_BADAGENT_ERROR,
	DYNDNS_NOHOST_ERROR, DYNDNS_NOTYOURS_ERROR, DYNDNS_ABUSE_ERROR,
	DYNDNS_NUMHOST_ERROR, DYNDNS_DNSERR_ERROR, -1
};
	
    sock = get_connection(DYNDNS_HOST, DYNDNS_PORT);
	if ( sock == -1 )
		return(-1);

	memset(getline, '\0', sizeof(getline));
	snprintf(getline, sizeof(getline), "GET /nic/update?&hostname=%s%s%s", domain, strlen(ip_address) > 0 ? "&myip=" : "", strlen(ip_address) > 0 ? ip_address : "");
	if ( wildcard >= 0 ) {
		strncat(getline, "&wildcard=", sizeof(getline));
		strncat(getline, wildcard == 0 ? "OFF" : "ON", sizeof(getline));
	}
	if ( strlen(mx) > 0 ) {
		strncat(getline, "&mx=", sizeof(getline));
		strncat(getline, mx, sizeof(getline));
	}
	if ( backupmx >= 0 ) {
		strncat(getline, "&backmx=", sizeof(getline));
		strncat(getline, backupmx == 0 ? "NO" : "YES", sizeof(getline));
	}
	if ( offline >= 0 ) {
		strncat(getline, "&offline=", sizeof(getline));
		strncat(getline, offline == 0 ? "NO" : "YES", sizeof(getline));
	}
	if ( strlen(service) > 0 ) {
		strncat(getline, "&system=", sizeof(getline));
		strncat(getline, service, sizeof(getline));
	}

	memset(userpass, '\0', sizeof(userpass));
	if ( (strlen(username) > 0) || (strlen(password) > 0) )
		snprintf(userpass, 255, "%s:%s", username, password);

	memset(b64user, '\0', sizeof(b64user));
	base64_encode(userpass, strlen(userpass), b64user);

	memset(somecraptmpvar, '\0', sizeof(somecraptmpvar));
	snprintf(somecraptmpvar, sizeof(somecraptmpvar), 
		" HTTP/1.1\015\012Host: %s\015\012Authorization: basic %s\015\012"
		"User-Agent: %s/%s %s\015\012Connection: close\015\012"
		"Pragma: no-cache\015\012\015\012",
		DYNDNS_HOST, b64user, PROGRAM_NAME, PROGRAM_VERSION,
		PROGRAM_HOMEPAGE);
	strncat(getline, somecraptmpvar, sizeof(getline));	

	write(sock, getline, strlen(getline));
	
#ifdef DEBUG
	printf("debug: sent http request: \"%s\"\n", getline);
#endif

	rfile = fdopen(sock, "r");

	while ( ! feof(rfile) ) {

		int i = -1;
		memset(recv_buffer, '\0', sizeof(recv_buffer));
		fgets(recv_buffer, sizeof(recv_buffer) - 2, rfile);
		/* ugh; ugly mess that removes CRLF's */
		while ( recv_buffer[++i] ) {
			if ( recv_buffer[i] == '\r' || recv_buffer[i] == '\n' )
				recv_buffer[i] = '\0';
		}

#ifdef DEBUG
		printf("debug: http response: \"%s\"\n", recv_buffer);
#endif

		if ( strlen(recv_buffer) < 1 ) {
			donewithheaders = 1;
			continue;
		}


		if ( donewithheaders ) {
			for (i=0; dyndns_word[i] != NULL; i++) {
				if ( strncmp(recv_buffer, dyndns_word[i], strlen(dyndns_word[i])) == 0 ) {
#ifdef DEBUG					
					printf("debug: found %s (code %i)\n", dyndns_word[i], dyndns_code[i]);
#endif
					close(sock);
					return ( dyndns_code[i] );
				}
			}
		}

	}
    
	close(sock); 
	return(-1);
}
