/*
** ddnsu - "small" dynamic dns updater
** Copyright (c) 2003,2004  Peter Willis <psyphreak@phreaker.net>
**
** original source from dtcl - Copyright (c) 2002 Jeff Irvine
** additional source taken from updatedd - Copyright (c) Philip Benner
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/* 

	See the ABOUT file for details about this program and its origins.

*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <stdlib.h>

#include "base64_encode.c" // for http auth

#include "ddnsu.h"

#ifdef DYNDNS_SERVICE
#include "dyndns.h"
#endif

char domain[_DOMAINSIZE];
char username[_USERNAMESIZE];
char password[_PASSWORDSIZE];
char ip_address[_IP_ADDRESSSIZE];
char service[_SERVICESIZE]; // "dyndns", "statdns", "custom"
char service_provider[_SERVICE_PROVIDERSIZE];
char mx[_MXSIZE];
int wildcard = -1;
int backupmx = -1;
int offline = -1;

void show_help(void) {
    printf("%s %s dynamic dns updater - %s\n", PROGRAM_NAME, PROGRAM_VERSION, COPYRIGHT);
    printf("\t-S SERVICE\tset SERVICE provider ( "
#ifdef DYNDNS_SERVICE
	DYNDNS_SERVICE_NAME " "
#endif
	")\n");
    printf("\t-u USERNAME\tset USERNAME\n");
    printf("\t-p PASSWORD\tset PASSWORD\n");
    printf("\t-a ADDRESS\tset ip ADDRESS\n");
    printf("\t-d DOMAIN\tset DOMAIN name\n");
    printf("\t-w on|off\tset wildcard status\n");
    printf("\t-m DOMAIN\tmake DOMAIN an mx record\n");
    printf("\t-b yes|no\tmakes the previous mx record a backup mx\n");
    printf("\t-s TYPE\t\tset system TYPE (dnydns [default], statdns, custom)\n");
    printf("\t-h\t\tthis help\n");
}


int parse_options(int argc, char **argv) {
	int i;
	memset(username, '\0', sizeof(username));
	memset(password, '\0', sizeof(password));
	memset(ip_address, '\0', sizeof(ip_address));
	memset(domain, '\0', sizeof(domain));
	memset(mx, '\0', sizeof(mx));
	memset(service, '\0', sizeof(service));
	memset(service_provider, '\0', sizeof(service_provider));
#ifdef DEBUG
	printf("argc %i\n", argc);
#endif
	for (i=1; i<(argc); i++) {
		if ( (strncmp(argv[i], "-", 1) == 0) && (argc > (i+1)) ) {
			char *ptr = (argv[i]+1);
#ifdef DEBUG
			printf("switching over %c (%i)\n", *ptr, *ptr);
#endif
			switch ( (int) *ptr ) {
				case 83: /* service provider */
#ifdef DEBUG
					printf("debug: setting service provider\n");
#endif
				strncpy(service_provider, argv[i+1], sizeof(service_provider));
					continue;
				case 117: /* username */
#ifdef DEBUG
					printf("debug: setting username\n");
#endif
					strncpy(username, argv[i+1], sizeof(username));
					continue;
				case 112: /* password */
#ifdef DEBUG
					printf("debug: setting password\n");
#endif
					strncpy(password, argv[i+1], sizeof(password));
					continue;
				case 97: /* ip address */
#ifdef DEBUG
					printf("debug: setting ip address\n");
#endif
					strncpy(ip_address, argv[i+1], sizeof(ip_address));
					continue;
				case 100: /* domain */
#ifdef DEBUG
					printf("debug: setting domain\n");
#endif
					strncpy(domain, argv[i+1], sizeof(domain));
					continue;
				case 119: /* wildcard */
#ifdef DEBUG
					printf("debug: setting wildcard\n");
#endif
					if ( strncasecmp(argv[i+1], "on", 2) == 0 )
						wildcard = 1;
					if ( strncasecmp(argv[i+1], "off", 3) == 0 )
						wildcard = 0;
					continue;
				case 109: /* mx */
#ifdef DEBUG
					printf("debug: setting mx\n");
#endif
					strncpy(mx, argv[i+1], sizeof(mx));
					continue;
				case 98: /* backup mx */
#ifdef DEBUG
					printf("debug: setting backup mx\n");
#endif
					if ( strncasecmp(argv[i+1], "yes", 2) == 0 )
						backupmx = 1;
					if ( strncasecmp(argv[i+1], "no", 3) == 0 )
						backupmx = 0;
					continue;
				case 115: /* system type */
#ifdef DEBUG
					printf("debug: setting service\n");
#endif
					strncpy(service, argv[i+1], sizeof(service));
					continue;
			}
		} else if ( strncasecmp(argv[i], "-h", 2) == 0 ) {
			show_help();
			exit(0);
		}
	}
	return ( argc );
}
	

/* TODO: re-write parse_options() function. */

int get_connection(char *server, int port) {
    int sock;
    struct sockaddr_in addr;
    struct hostent *hostinfo;

    if ( ! (hostinfo = gethostbyname(server)) ) {
	    fprintf(stderr, "Error: Unable to resolve host %s\n", server);
	    return(-1);
    }

    if ( (sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1 ) {
	    fprintf(stderr, "Error: Unable to get network socket\n");
	    return(-1);
    }

    addr.sin_family = AF_INET;
    addr.sin_port = htons(port);
    addr.sin_addr = *(struct in_addr*)*hostinfo->h_addr_list;

    if(connect(sock, (struct sockaddr*)&addr, sizeof(addr)) == -1) {
        fprintf(stderr, "Error: Unable to connect\n");
        return(-1);
    }
	
#ifdef DEBUG
	printf("debug: socket connected\n");
#endif

    return(sock);
}


int do_update() {

	int returnval = -1;

	if ( strlen(service_provider) < 1 ) {
		fprintf(stderr, "Error: no service provider supplied.\n");
		show_help();
		exit(1);
	}
	
#ifdef DYNDNS_SERVICE
	if (strncmp(service_provider, DYNDNS_SERVICE_NAME, sizeof(service_provider)) == 0) {
		returnval = update_dyndns();
	}
#endif

#ifdef DEBUG
	printf("debug: update complete (returned code %i)\n", returnval);
#endif

    if (  returnval != 0 ) {
        fprintf(stderr, "Error performing update; Code %i.\n", returnval);
    }

	return(returnval);
}


int main(int argc, char **argv) {
	
	int return_code;
	
    if ( parse_options(argc, argv) < 2 ) {
        fprintf(stderr, "Error parsing command line.\n");
        show_help();
        return(1);
    }


	return_code = do_update();

#ifdef DEBUG
	printf("debug: do_update() returned %i\n", return_code);
#endif

    return(return_code);
}
