/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.communications.interfaces.SocketCloseListener;
import com.amazon.redshift.api.PGArrayColumnMetaData;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.api.PGTimestamp;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.inbound.DataRow;
import com.amazon.redshift.client.messages.inbound.RowDescription;
import com.amazon.redshift.core.PGArray;
import com.amazon.redshift.core.PGArrayParser;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.dataengine.metadata.ColumnsIsNullResultSet;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.GeneralException;
import com.amazon.utilities.TypeNames;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;

public class PGResultSet
implements IResultSet,
PGConstants,
SocketCloseListener {
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    private ArrayList<ColumnMetadata> m_columnMetadata;
    protected PGMessagingContext m_currentMessagingContext = null;
    protected ILogger m_log;
    private int m_fetchSize;
    protected long m_currentRow = 0L;
    protected boolean m_hasStartedFetch = false;
    private IWarningListener m_warningListener = null;
    protected ErrorException m_fatalException = null;
    private BitSet m_needsData = new BitSet();
    private ColumnsIsNullResultSet m_columnsIsNullResultSet = null;

    public PGResultSet(PGMessagingContext pGMessagingContext, ILogger iLogger) {
        this.m_currentMessagingContext = pGMessagingContext;
        this.m_log = iLogger;
        this.m_currentMessagingContext.addSocketCloseListener(this);
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            if (n < this.m_currentMessagingContext.m_currentDataRow.getNumberOfColumns()) {
                ColumnMetadata columnMetadata = this.getSelectColumns().get(n);
                byte[] byArray = this.m_currentMessagingContext.m_currentDataRow.getData();
                int n2 = this.m_currentMessagingContext.m_currentDataRow.getColumnBeginIndex(n);
                int n3 = this.m_currentMessagingContext.m_currentDataRow.getColumnEndIndex(n);
                int n4 = n3 - n2 + 1;
                if (-1 == n3) {
                    dataWrapper.setNull(columnMetadata.getTypeMetadata().getType());
                    return false;
                }
                switch (columnMetadata.getTypeMetadata().getType()) {
                    case 2003: {
                        if (columnMetadata instanceof PGArrayColumnMetaData) {
                            Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                            if (null != object && object instanceof PGArray) {
                                dataWrapper.setArray((PGArray)object);
                            } else {
                                PGArrayColumnMetaData pGArrayColumnMetaData = (PGArrayColumnMetaData)columnMetadata;
                                int n5 = pGArrayColumnMetaData.getBaseType();
                                IColumn iColumn = pGArrayColumnMetaData.getBaseColumnMetadata();
                                Object object2 = PGArrayParser.parseArray(byArray, n5, n2, n4);
                                PGArray pGArray = new PGArray(object2, columnMetadata, iColumn);
                                this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, pGArray);
                                dataWrapper.setArray(pGArray);
                            }
                            return false;
                        }
                        throw new GeneralException(1, JDBCMessageKey.INVALID_COLUMN_TYPE.name(), new String[]{String.valueOf(n), TypeNames.getTypeName(2003)});
                    }
                    case 1: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof String) {
                            dataWrapper.setChar(PGDataTypeUtilities.convertStringToUTF8((String)object));
                        } else {
                            String string = PGDataTypeUtilities.toUTF8String(byArray, n2, n4);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, string);
                            dataWrapper.setChar(string);
                        }
                        return false;
                    }
                    case 12: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof String) {
                            dataWrapper.setVarChar(PGDataTypeUtilities.convertStringToUTF8((String)object));
                        } else {
                            String string = PGDataTypeUtilities.toUTF8String(byArray, n2, n4);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, string);
                            dataWrapper.setVarChar(string);
                        }
                        return false;
                    }
                    case -1: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof String) {
                            dataWrapper.setLongVarChar(PGDataTypeUtilities.convertStringToUTF8((String)object));
                        } else {
                            String string = PGDataTypeUtilities.toUTF8String(byArray, n2, n4);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, string);
                            dataWrapper.setLongVarChar(string);
                        }
                        return false;
                    }
                    case -4: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof byte[]) {
                            dataWrapper.setLongVarBinary((byte[])object);
                        } else {
                            byte[] byArray2 = PGDataTypeUtilities.transformByteFormat(byArray, n2, n4);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, byArray2);
                            dataWrapper.setLongVarBinary(byArray2);
                        }
                        return false;
                    }
                    case -7: 
                    case 16: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof String) {
                            dataWrapper.setVarChar((String)object);
                        } else {
                            String string = null;
                            string = PGDataTypeUtilities.toBit(byArray, n2) != false ? TRUE : FALSE;
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, string);
                            dataWrapper.setVarChar(string);
                        }
                        return false;
                    }
                    case 5: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof Integer) {
                            dataWrapper.setSmallInt((Integer)object);
                        } else {
                            Integer n6 = new Integer(PGDataTypeUtilities.toShort(byArray, n2, n4));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, n6);
                            dataWrapper.setSmallInt(n6);
                        }
                        return false;
                    }
                    case 4: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof Long) {
                            dataWrapper.setInteger((Long)object);
                        } else {
                            Long l3 = new Long(PGDataTypeUtilities.toInteger(byArray, n2, n4));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, l3);
                            dataWrapper.setInteger(l3);
                        }
                        return false;
                    }
                    case -5: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof Long) {
                            dataWrapper.setBigInt((Long)object);
                        } else {
                            Long l4 = new Long(PGDataTypeUtilities.toLong(byArray, n2, n4));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, l4);
                            dataWrapper.setBigInt(l4);
                        }
                        return false;
                    }
                    case 7: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof Float) {
                            dataWrapper.setReal((Float)object);
                        } else {
                            Float f = new Float(PGDataTypeUtilities.toFloat(byArray, n2, n4));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, f);
                            dataWrapper.setReal(f);
                        }
                        return false;
                    }
                    case 8: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof Double) {
                            dataWrapper.setDouble((Double)object);
                        } else {
                            Double d = new Double(PGDataTypeUtilities.toDouble(byArray, n2, n4));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, d);
                            dataWrapper.setDouble(d);
                        }
                        return false;
                    }
                    case 91: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof Date) {
                            dataWrapper.setDate((Date)object);
                        } else {
                            int[] nArray = PGDataTypeUtilities.toDate(byArray, n2, n4);
                            Date date = PGDataTypeUtilities.toSqlDate(nArray);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, date);
                            dataWrapper.setDate(date);
                        }
                        return false;
                    }
                    case 92: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof int[]) {
                            int[] nArray = (int[])object;
                            dataWrapper.setTime(nArray[0], nArray[1], nArray[2], nArray[3]);
                        } else {
                            int[] nArray = PGDataTypeUtilities.toTime(byArray, n2, n4);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, nArray);
                            dataWrapper.setTime(nArray[0], nArray[1], nArray[2], nArray[3]);
                        }
                        return false;
                    }
                    case 93: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof PGTimestamp) {
                            dataWrapper.setTimestamp((PGTimestamp)object);
                        } else if (null != object && object instanceof int[]) {
                            int[] nArray = (int[])object;
                            Timestamp timestamp = PGDataTypeUtilities.toSqlTimestamp(nArray);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, timestamp);
                            dataWrapper.setTimestamp(timestamp);
                        } else {
                            String string = PGDataTypeUtilities.toUTF8String(byArray, n2, n4);
                            if ((string = string.toLowerCase()).contains("infinity")) {
                                if (string.startsWith("-")) {
                                    dataWrapper.setTimestamp(new PGTimestamp(Long.MIN_VALUE));
                                } else {
                                    dataWrapper.setTimestamp(new PGTimestamp(Long.MAX_VALUE));
                                }
                            } else {
                                int[] nArray = PGDataTypeUtilities.toTimestamp(byArray, n2, n4);
                                Timestamp timestamp = PGDataTypeUtilities.toSqlTimestamp(nArray);
                                dataWrapper.setTimestamp(timestamp);
                            }
                        }
                        return false;
                    }
                    case 2: 
                    case 3: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof BigDecimal) {
                            dataWrapper.setNumeric((BigDecimal)object);
                        } else {
                            BigDecimal bigDecimal = PGDataTypeUtilities.toBigDecimal(byArray, n2, n4);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, bigDecimal);
                            dataWrapper.setNumeric(bigDecimal);
                        }
                        return false;
                    }
                }
            }
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_log);
            throw this.buildError(exception);
        }
        return false;
    }

    @Override
    public long getRowCount() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            return this.m_currentMessagingContext.m_dataRowCount;
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_log);
            throw this.buildError(exception);
        }
    }

    public ArrayList<ColumnMetadata> getSelectColumns() throws ErrorException {
        return this.getSelectColumns(true);
    }

    public ArrayList<ColumnMetadata> getSelectColumns(boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            if (null == this.m_columnMetadata) {
                this.m_columnMetadata = new ArrayList();
                RowDescription rowDescription = this.m_currentMessagingContext.getRowDescription();
                if (null != rowDescription) {
                    ColumnsIsNullResultSet columnsIsNullResultSet = this.m_currentMessagingContext.m_columnsIsNullResultSet;
                    for (int i = 0; i < rowDescription.getFieldDescriptions().length; ++i) {
                        Boolean bl2 = null;
                        if (null != columnsIsNullResultSet) {
                            bl2 = columnsIsNullResultSet.isNullable(rowDescription.getFieldDescriptions()[i].getTableObjectIDString(), rowDescription.getFieldDescriptions()[i].getColumnAttributeNumberString());
                        }
                        this.m_columnMetadata.add(PGDataTypeUtilities.createColumn(null, null, "", PGDataTypeUtilities.toUTF8String(rowDescription.getFieldDescriptions()[i].getFieldName()), rowDescription.getFieldDescriptions()[i], bl2));
                    }
                }
            }
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_log);
            throw this.buildError(exception);
        }
        return this.m_columnMetadata;
    }

    public int isNullable(int n) throws ErrorException {
        if (null != this.m_columnsIsNullResultSet) {
            return this.getIsNullable(n);
        }
        if (null != this.m_currentMessagingContext.m_columnsIsNullResultSet) {
            this.m_columnsIsNullResultSet = this.m_currentMessagingContext.m_columnsIsNullResultSet;
            return this.getIsNullable(n);
        }
        if (null == this.m_currentMessagingContext.m_columnsIsNullResultSetQuery) {
            return 2;
        }
        String string = this.m_currentMessagingContext.m_columnsIsNullResultSetQuery;
        PGClient pGClient = this.m_currentMessagingContext.getClient();
        this.m_columnsIsNullResultSet = new ColumnsIsNullResultSet(pGClient.directExecute(string, false, 0, 0, null, true), this.m_log);
        return this.getIsNullable(n);
    }

    private int getIsNullable(int n) throws ErrorException {
        if (null == this.m_currentMessagingContext) {
            return 2;
        }
        RowDescription rowDescription = this.m_currentMessagingContext.getRowDescription();
        if (null != rowDescription) {
            Boolean bl = null;
            if (n - 1 < rowDescription.getFieldDescriptions().length && null != this.m_columnsIsNullResultSet) {
                bl = this.m_columnsIsNullResultSet.isNullable(rowDescription.getFieldDescriptions()[n - 1].getTableObjectIDString(), rowDescription.getFieldDescriptions()[n - 1].getColumnAttributeNumberString());
                if (null == bl) {
                    return 2;
                }
                if (!bl.booleanValue()) {
                    return 0;
                }
                return 1;
            }
        }
        return 2;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (this.m_currentMessagingContext.peekNextMessage(0) instanceof DataRow) {
            return true;
        }
        return this.getRowCount() > this.getCurrentRow() + 1L;
    }

    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return !this.m_currentMessagingContext.hasOpenOperation();
    }

    @Override
    public void appendRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_currentMessagingContext.closeOperation();
        this.m_currentMessagingContext.removeSocketCloseListener(this);
    }

    @Override
    public void closeCursor() throws ErrorException {
        this.m_hasStartedFetch = false;
        this.m_currentRow = 0L;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_currentMessagingContext.closeOperation();
        this.m_currentMessagingContext.removeSocketCloseListener(this);
    }

    @Override
    public void deleteRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public int getFetchSize() throws ErrorException {
        return this.m_fetchSize;
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (!this.m_hasStartedFetch) {
            this.m_hasStartedFetch = true;
            this.m_currentRow = 0L;
        } else {
            ++this.m_currentRow;
        }
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            if (this.hasMoreRows()) {
                return this.m_currentMessagingContext.doMoveToNextRow();
            }
            return false;
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_log);
            throw this.buildError(exception);
        }
    }

    @Override
    public void onFinishRowUpdate() {
    }

    @Override
    public void onStartRowUpdate() {
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public void setCursorType(CursorType cursorType) throws ErrorException {
        if (CursorType.FORWARD_ONLY != cursorType) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CURSOR_NOT_SUPPORTED.name(), String.valueOf((Object)cursorType));
        }
    }

    @Override
    public void setFetchSize(int n) throws ErrorException {
        this.m_fetchSize = n;
    }

    @Override
    public boolean writeData(int n, DataWrapper dataWrapper, long l, boolean bl) throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    protected long getCurrentRow() {
        return this.m_currentRow;
    }

    @Override
    public void socketClosed(ErrorException errorException) {
        this.m_fatalException = errorException;
    }

    @Override
    public boolean supportsHasMoreRows() {
        return true;
    }

    protected ErrorException buildError(Exception exception) {
        if (null != this.m_fatalException) {
            return this.m_fatalException;
        }
        if (exception instanceof ErrorException) {
            return (ErrorException)exception;
        }
        ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        errorException.initCause(exception);
        return errorException;
    }

    @Override
    public boolean getDataNeeded(int n) {
        return this.m_needsData.get(n);
    }

    @Override
    public void setDataNeeded(int n, boolean bl) {
        this.m_needsData.set(n, bl);
    }
}

