/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.dataengine.PGEscaper;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PGCallableStatementParser {
    private String m_result = "";
    private boolean m_returnParameter = false;
    private Matcher m_commentMatcher;
    private String m_query;
    private int m_inputPassed = 0;
    private List<Boolean> m_indicesPassed;
    private static final Pattern S_PARAMETERPLACEHOLDER = Pattern.compile("((\\s)*\\$[0-9]+(\\s)*)");
    private Map<Integer, String> m_valuesPassed;
    private ILogger m_log;

    public PGCallableStatementParser(ILogger iLogger) {
        this.m_log = iLogger;
        this.m_query = "";
    }

    public PGCallableStatementParser(String string, ILogger iLogger) {
        this(iLogger);
        this.m_query = string;
    }

    public String translate(String string) throws Exception {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        String string2 = string.trim();
        StringBuilder stringBuilder = new StringBuilder(string2);
        if (stringBuilder.charAt(0) == '{' && stringBuilder.charAt(stringBuilder.length() - 1) == '}') {
            stringBuilder.deleteCharAt(0);
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        this.m_result = stringBuilder.toString();
        return this.m_result;
    }

    public String getResult() {
        return this.m_result;
    }

    public boolean isReturnParameter() {
        String string = this.m_query.trim();
        int n = string.indexOf("$1");
        if (-1 != n) {
            if (-1 == (n = PGCallableStatementParser.getIndexOfNextNotOf(string, n + 2, ' '))) {
                return false;
            }
            if ('=' == string.charAt(n)) {
                this.m_returnParameter = true;
            }
        }
        return this.m_returnParameter;
    }

    public String changeSelectToCall(String string) {
        if (string.contains("SELECT")) {
            StringBuilder stringBuilder = new StringBuilder(string);
            int n = stringBuilder.toString().indexOf("SELECT");
            return stringBuilder.replace(n, n + 6, "CALL").toString();
        }
        return string;
    }

    public String extractStoredProcName(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.removeComments();
        this.m_indicesPassed = new ArrayList<Boolean>();
        this.m_valuesPassed = new HashMap<Integer, String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.m_query.toLowerCase().indexOf("call ");
        if (-1 == n) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PARSINGPROBLEM_ENCOUNTERED.name(), "");
            throw errorException;
        }
        n += 4;
        while (Character.isWhitespace(this.m_query.charAt(n++))) {
        }
        int n2 = this.m_query.indexOf("(", n + 1);
        if (-1 == n2) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PARSINGPROBLEM_ENCOUNTERED.name(), "");
            throw errorException;
        }
        String string2 = this.m_query.substring(n - 1, n2).trim();
        stringBuilder.append(string2);
        stringBuilder.insert(0, "'");
        stringBuilder.append("'");
        LogUtilities.logDebug("Name of the stored procedure is " + stringBuilder.toString(), this.m_log);
        int n3 = 0;
        n = n2 + 1;
        int n4 = this.m_query.indexOf(")", n);
        if (-1 == n4) {
            return stringBuilder.toString();
        }
        if (this.isReturnParameter()) {
            this.m_indicesPassed.add(Boolean.FALSE);
        }
        if (-1 == (n2 = this.m_query.indexOf(44, n + 1))) {
            n2 = this.m_query.indexOf(41, n + 1);
        }
        while (-1 < n2 && n2 <= n4) {
            String string3 = this.m_query.substring(n, n2);
            if (n2 - n > 0 && -1 == string3.indexOf(36)) {
                this.m_indicesPassed.add(Boolean.TRUE);
                int n5 = n4 == n2 ? 0 : 1;
                this.m_valuesPassed.put(++n3, string3.substring(n5));
            } else {
                this.m_indicesPassed.add(Boolean.FALSE);
            }
            if (-1 != (n2 = this.m_query.indexOf(44, (n = n2) + 1))) continue;
            n2 = this.m_query.indexOf(41, n + 1);
        }
        this.m_inputPassed = n3;
        return stringBuilder.toString();
    }

    public String removeOutputParameters(int n, int n2, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        StringBuilder stringBuilder = new StringBuilder(this.m_query);
        int n3 = n2 - this.m_inputPassed;
        if (this.m_returnParameter) {
            int n4 = stringBuilder.indexOf("$1");
            int n5 = stringBuilder.toString().toLowerCase().indexOf("call");
            stringBuilder.delete(n4, n5);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            int n6 = stringBuilder.indexOf("(");
            String[] stringArray = stringBuilder.toString().substring(n6 + 1).split(",");
            arrayList3.addAll(Arrays.asList(stringArray));
            int n7 = stringBuilder.indexOf(stringArray[stringArray.length - 1]);
            int n8 = stringBuilder.indexOf(")", n7);
            arrayList3.set(arrayList3.size() - 1, stringArray[stringArray.length - 1].substring(0, n8 - n7));
            stringBuilder = this.updateIndicesAfterRemovingOutput(arrayList3, arrayList2, stringBuilder, n6, n8, true, true);
        } else if (0 < n && 0 == n3) {
            while (n > n3) {
                int n9 = stringBuilder.indexOf("$" + n);
                int n10 = stringBuilder.substring(0, n9).lastIndexOf(44);
                int n11 = 0;
                if (-1 != n10) {
                    n11 = n9 - n10;
                    n9 = n10;
                }
                stringBuilder.delete(n9, n9 + n11 + 3);
                --n;
            }
        } else {
            ArrayList<String> arrayList4 = new ArrayList<String>();
            int n12 = stringBuilder.indexOf("(");
            String[] stringArray = stringBuilder.toString().substring(n12 + 1).split(",");
            arrayList4.addAll(Arrays.asList(stringArray));
            ArrayList<String> arrayList5 = new ArrayList<String>();
            int n13 = stringBuilder.indexOf(stringArray[stringArray.length - 1]);
            int n14 = stringBuilder.indexOf(")", n13);
            arrayList4.set(arrayList4.size() - 1, stringArray[stringArray.length - 1].substring(0, n14 - n13));
            Matcher matcher = S_PARAMETERPLACEHOLDER.matcher(stringBuilder);
            int n15 = 0;
            int n16 = 0;
            for (String string : arrayList4) {
                matcher = S_PARAMETERPLACEHOLDER.matcher(string);
                if (!matcher.find()) {
                    arrayList5.add(string);
                } else if (arrayList.contains(n16)) {
                    ++n15;
                } else {
                    int n17 = string.indexOf("$");
                    int n18 = string.indexOf(" ", n17 + 1);
                    if (-1 == n18) {
                        n18 = string.length();
                    }
                    int n19 = Integer.valueOf(string.substring(n17 + 1, n18)) - n15;
                    arrayList5.add(string.substring(0, n17 + 1) + n19 + string.substring(n18, string.length()));
                }
                ++n16;
            }
            stringBuilder = n - n15 > n3 ? this.updateIndicesAfterRemovingOutput(arrayList5, arrayList2, stringBuilder, n12, n14, true, false) : this.updateIndicesAfterRemovingOutput(arrayList5, null, stringBuilder, n12, n14, false, false);
        }
        LogUtilities.logDebug("Query before change: " + this.m_query + " , query after change: " + stringBuilder.toString(), this.m_log);
        return stringBuilder.toString();
    }

    public int getInputPassed() {
        return this.m_inputPassed;
    }

    public List<Boolean> getSetIndices() {
        return this.m_indicesPassed;
    }

    public HashMap<Integer, String> getPassedValues() {
        return (HashMap)this.m_valuesPassed;
    }

    private StringBuilder updateIndicesAfterRemovingOutput(List<String> list, ArrayList<Integer> arrayList, StringBuilder stringBuilder, int n, int n2, boolean bl, boolean bl2) {
        Serializable serializable;
        if (bl) {
            serializable = new ArrayList();
            int n3 = 0;
            if (bl2) {
                n3 = 1;
            }
            int n4 = 0;
            for (String string : list) {
                Matcher object = S_PARAMETERPLACEHOLDER.matcher(string);
                if (!object.find()) {
                    ((ArrayList)serializable).add(string);
                } else if (arrayList.contains(n4)) {
                    ++n3;
                } else {
                    int n5 = string.indexOf("$");
                    int n6 = string.indexOf(" ", n5 + 1);
                    if (-1 == n6) {
                        n6 = string.length();
                    }
                    int n7 = Integer.valueOf(string.substring(n5 + 1, n6)) - n3;
                    ((ArrayList)serializable).add(string.substring(0, n5 + 1) + n7 + string.substring(n6, string.length()));
                }
                ++n4;
            }
            list.clear();
            list.addAll((Collection<String>)((Object)serializable));
            ((ArrayList)serializable).clear();
        }
        serializable = new StringBuilder();
        for (String string : list) {
            ((StringBuilder)serializable).append(string).append(" ,");
        }
        ((StringBuilder)serializable).deleteCharAt(((StringBuilder)serializable).length() - 1);
        stringBuilder.replace(n + 1, n2, ((StringBuilder)serializable).toString());
        return stringBuilder;
    }

    private static int getIndexOfNextNotOf(String string, int n, char c) {
        for (int i = n + 1; i < string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            return i;
        }
        return -1;
    }

    private void removeComments() {
        String string = this.m_query;
        this.m_commentMatcher = PGEscaper.s_re_comment.matcher(string);
        StringBuilder stringBuilder = new StringBuilder(this.m_query);
        int n = 0;
        int n2 = this.scan(n, this.m_commentMatcher);
        while (this.m_query.length() != n2) {
            int n3 = this.m_commentMatcher.end();
            stringBuilder.delete(n2, n3 + 1);
            this.m_commentMatcher = PGEscaper.s_re_comment.matcher(stringBuilder.toString());
            n2 = this.scan(++n, this.m_commentMatcher);
        }
        this.m_query = stringBuilder.toString();
    }

    private int scan(int n, Matcher matcher) {
        assert (matcher != null);
        assert (n >= 0 && n <= this.m_query.length());
        int n2 = -1;
        if (!matcher.find(n)) {
            return this.m_query.length();
        }
        if (matcher.groupCount() > 0) {
            n2 = matcher.start(1);
        }
        if (-1 == n2) {
            n2 = matcher.start(0);
        }
        if (n2 == -1 || n2 >= this.m_query.length()) {
            return this.m_query.length();
        }
        return n2;
    }
}

