/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration;

import com.install4j.api.Util;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.List;

public class LockFile {
    private static final String PROPNAME_LOCK_FILE = "install4j.lockFile";
    private static final String PROPNAME_TIMEOUT = "install4j.lockFileTimeout";

    public static void deleteLockFile() {
        String lockFileName = System.getProperty(PROPNAME_LOCK_FILE);
        if (lockFileName != null) {
            new File(lockFileName).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForLockFile() {
        File lockFile;
        String lockFileName = System.getProperty(PROPNAME_LOCK_FILE);
        if (lockFileName != null && (lockFile = new File(lockFileName)).isFile()) {
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(lockFile, "rw");){
                int maxTryCount = Integer.getInteger(PROPNAME_TIMEOUT, 120) * 2;
                int tryCount = 0;
                FileLock fileLock = randomAccessFile.getChannel().tryLock();
                while (fileLock == null) {
                    if (tryCount++ == maxTryCount) {
                        Util.showMessage("Calling process did not terminate. Could not run updater.", 0);
                        System.exit(1);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    fileLock = randomAccessFile.getChannel().tryLock();
                }
                fileLock.release();
            }
            catch (IOException iOException) {
            }
            finally {
                if (!lockFile.delete() && lockFile.isFile()) {
                    lockFile.deleteOnExit();
                }
            }
        }
    }

    private static String createLockFile() {
        try {
            File file = File.createTempFile("lock", ".tmp", AutomaticUpdate.getUpdateDir());
            new RandomAccessFile(file, "rw").getChannel().lock();
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static void addLockFile(List<String> arguments) {
        String lockFileName = LockFile.createLockFile();
        if (lockFileName != null) {
            arguments.add("-Dinstall4j.lockFile=" + lockFileName);
        }
    }
}

