/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos.macho;

import com.install4j.runtime.installer.platform.macos.macho.LoadCommand;
import com.install4j.runtime.installer.platform.macos.macho.Part;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

class Header
implements Part {
    private int cputype;
    private int cpusubtype;
    private int filetype;
    private int ncmds;
    private int sizeofcmds;
    private int flags;

    Header() {
    }

    @Override
    public void read(ByteBuffer buf, boolean bit64) throws IOException {
        this.cputype = buf.getInt();
        this.cpusubtype = buf.getInt();
        this.filetype = buf.getInt();
        this.ncmds = buf.getInt();
        this.sizeofcmds = buf.getInt();
        this.flags = buf.getInt();
        if (bit64) {
            buf.getInt();
        }
    }

    @Override
    public void write(ByteBuffer buf, boolean bit64) throws IOException {
        buf.putInt(this.cputype);
        buf.putInt(this.cpusubtype);
        buf.putInt(this.filetype);
        buf.putInt(this.ncmds);
        buf.putInt(this.sizeofcmds);
        buf.putInt(this.flags);
        if (bit64) {
            buf.putInt(0);
        }
    }

    public int getNcmds() {
        return this.ncmds;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void updateHeader(List<LoadCommand> loadCommands) {
        this.ncmds = loadCommands.size();
        this.sizeofcmds = 0;
        for (LoadCommand loadCommand : loadCommands) {
            this.sizeofcmds += loadCommand.getSize();
        }
    }

    public String toString() {
        return "Header{, cputype=" + this.cputype + ", cpusubtype=" + this.cpusubtype + ", filetype=" + this.filetype + ", ncmds=" + this.ncmds + ", sizeofcmds=" + this.sizeofcmds + ", flags=" + this.flags + '}';
    }
}

