/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.net.DigestAlgorithm;
import com.install4j.runtime.installer.helper.CompilerVariableHelper;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.Downloader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;

public class ChecksumChecker {
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getHexStringFromBytes(byte[] bytes) {
        StringBuilder buffer = new StringBuilder();
        for (byte b : bytes) {
            int msb = (b & 0xFF) / 16;
            int lsb = (b & 0xFF) % 16;
            buffer.append(hexChars[msb]);
            buffer.append(hexChars[lsb]);
        }
        return buffer.toString();
    }

    public static String getExpectedDigest(Context context, String urlString, String expectedFileName) throws IOException, UserCanceledException {
        Downloader downloader = new Downloader(context, null);
        downloader.setAskForProxy(true);
        return ChecksumChecker.getExpectedDigest(downloader, context, urlString, "", DigestAlgorithm.SHA256, expectedFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExpectedDigest(Downloader downloader, Context context, String digestUrl, String downloadUrl, DigestAlgorithm digestAlgorithm, String expectedFileName) throws UserCanceledException, IOException {
        boolean previousProgress = downloader.isProgressEnabled();
        try {
            downloader.setProgressEnabled(false);
            File checksumFile = File.createTempFile("digest", ".tmp");
            ChecksumChecker.connect(downloader, digestUrl, downloadUrl, digestAlgorithm);
            downloader.download(checksumFile, -1L, true);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(checksumFile), StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    int spaceIndex = line.indexOf(32);
                    if (spaceIndex > -1) {
                        String checksum = line.substring(0, spaceIndex).toLowerCase(Locale.ENGLISH);
                        String fileName = line.substring(spaceIndex + 1);
                        while (fileName.startsWith("*") || fileName.startsWith(" ")) {
                            fileName = fileName.substring(1);
                        }
                        if (Objects.equals(fileName, expectedFileName)) {
                            String string = checksum;
                            return string;
                        }
                    }
                    line = reader.readLine();
                }
            }
            finally {
                checksumFile.delete();
            }
        }
        catch (IOException e) {
            Logger.getInstance().error(ChecksumChecker.class, "could not get digest file");
            Logger.getInstance().log(e);
            if (context != null && CompilerVariableHelper.getCompilerExtensionVariable(context, "failOnDigestFileError", false)) {
                throw e;
            }
        }
        catch (UserCanceledException e) {
            Logger.getInstance().error(ChecksumChecker.class, "could not get digest file");
            Logger.getInstance().log(e);
            if (context != null && context.isCancelling()) {
                throw e;
            }
        }
        finally {
            downloader.setProgressEnabled(previousProgress);
        }
        String message = "file with name " + expectedFileName + " not found in digest file";
        Logger.getInstance().error(ChecksumChecker.class, message);
        if (CompilerVariableHelper.getCompilerExtensionVariable(context, "failOnDigestFileError", false)) {
            throw new IOException(message);
        }
        return "";
    }

    private static void connect(Downloader downloader, String digestUrl, String downloadUrl, DigestAlgorithm digestAlgorithm) throws IOException, UserCanceledException {
        if (digestUrl == null || digestUrl.trim().length() == 0) {
            if (digestAlgorithm == DigestAlgorithm.SHA256_OR_MD5) {
                try {
                    downloader.connect(ChecksumChecker.createDigestUrl(downloadUrl, "sha256sums"));
                }
                catch (FileNotFoundException e) {
                    downloader.connect(ChecksumChecker.createDigestUrl(downloadUrl, "md5sums"));
                }
            } else if (digestAlgorithm == DigestAlgorithm.SHA256) {
                downloader.connect(ChecksumChecker.createDigestUrl(downloadUrl, "sha256sums"));
            } else if (digestAlgorithm == DigestAlgorithm.MD5) {
                downloader.connect(ChecksumChecker.createDigestUrl(downloadUrl, "md5sums"));
            }
        } else {
            downloader.connect(digestUrl);
        }
    }

    public static String createDigestUrl(String mainSpec, String checksumFileName) throws MalformedURLException {
        int index;
        String path;
        URL mainUrl = new URL(mainSpec);
        String urlString = mainUrl.getProtocol() + ":";
        if (mainUrl.getAuthority() != null && mainUrl.getAuthority().length() > 0) {
            urlString = urlString + "//" + mainUrl.getAuthority();
        }
        if ((path = mainUrl.getPath()) != null && (index = path.lastIndexOf(47)) > -1) {
            urlString = urlString + path.substring(0, index);
        }
        if (!urlString.endsWith("/")) {
            urlString = urlString + "/";
        }
        urlString = urlString + checksumFileName;
        if (mainUrl.getQuery() != null) {
            urlString = urlString + "?" + mainUrl.getQuery();
        }
        if (mainUrl.getRef() != null) {
            urlString = urlString + "#" + mainUrl.getRef();
        }
        return urlString;
    }
}

