/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.apiimpl;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.launcher.Variables;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.beans.styles.StyleManagerImpl;
import com.install4j.runtime.installer.Application;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.util.StringUtil;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

public class ApplicationLauncherImpl {
    public static boolean waitForInProcessApplication(long timeout, TimeUnit unit) throws InterruptedException {
        if (InstallerConfig.getCurrentApplication() == null) {
            return true;
        }
        long startTime = System.nanoTime();
        while (InstallerConfig.getCurrentInstance() != null && (timeout == 0L || unit.toNanos(timeout) > System.nanoTime() - startTime)) {
            Thread.sleep(30L);
        }
        return InstallerConfig.getCurrentInstance() == null;
    }

    public static void launchApplicationInProcess(final String applicationId, final String[] arguments, final ApplicationLauncher.Callback callback, final ApplicationLauncher.WindowMode windowMode, final Object parentWindow) {
        if (InstallerConfig.getCurrentApplication() != null) {
            throw new IllegalStateException("Only one installer application can be run at the same time.");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                InstallerUtil.setInProcessCallback(callback);
                try {
                    Application.runApplicationInProcess(applicationId, arguments, windowMode == ApplicationLauncher.WindowMode.DIALOG, (Window)parentWindow);
                }
                finally {
                    Variables.clearInstallerVariablesCache();
                    StyleManagerImpl.getInstance().clear();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    public static void launchApplication(String applicationId, String[] arguments, boolean blocking, ApplicationLauncher.Callback callback) throws IOException {
        LaunchDescriptor launchDescriptor;
        String launcherId;
        InstallerConfig config = InstallerConfig.getConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf"));
        com.install4j.runtime.beans.applications.Application app = config.getApplicationById(applicationId);
        if (app == null) {
            throw new IOException("Application with ID " + applicationId + " could not be found");
        }
        if (!(app instanceof CustomApplication)) {
            throw new IOException("Application is no custom application");
        }
        CustomApplication customApplication = (CustomApplication)app;
        File execFile = Application.getExeFile(customApplication);
        File commFile = File.createTempFile("i4jshd", ".tmp");
        ArrayList<String> realArgs = new ArrayList<String>();
        if (!execFile.exists()) {
            StringUtil.splitupCommandLine(realArgs, customApplication.getVmParameters());
            if (Util.isMacOS()) {
                StringUtil.splitupCommandLine(realArgs, ApplicationLauncherImpl.getDockOptions(config, customApplication, applicationId, execFile));
            }
            realArgs.add("-classpath");
            String classpath = new File(ResourceHelper.getRuntimeDir(), "i4jruntime.jar").getAbsolutePath();
            realArgs.add(classpath);
            realArgs.add(Application.class.getName());
            realArgs.add(String.valueOf(applicationId));
            StringUtil.splitupCommandLine(realArgs, customApplication.getArguments());
            execFile = new File(System.getProperty("java.home"), "bin/java");
        }
        if (arguments != null) {
            realArgs.addAll(Arrays.asList(arguments));
        }
        realArgs.add("-Dinstall4j.shutdownFile=" + commFile.getAbsolutePath());
        realArgs.add("-Dinstall4j.fromService=" + Launcher.isService());
        String launcherPath = System.getProperty("exe4j.moduleName");
        if (launcherPath != null) {
            realArgs.add("-Dinstall4j.fromLauncher=" + launcherPath);
        }
        if ((launcherId = System.getProperty("install4j.launcherId")) != null) {
            realArgs.add("-Dinstall4j.fromLauncherId=" + launcherId);
        }
        if (LaunchHelper.launchApplication(launchDescriptor = new LaunchDescriptor(execFile).arguments(realArgs.toArray(new String[0])).receiveProcess(true)) == null) {
            throw new IOException("Could not start process");
        }
        CommFileWaiter commFileWaiter = new CommFileWaiter(commFile, callback, launchDescriptor.getProcess());
        commFileWaiter.start();
        if (blocking) {
            try {
                launchDescriptor.getProcess().waitFor();
                commFileWaiter.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getDockOptions(InstallerConfig config, ApplicationWithPath customApplication, String applicationId, File execFile) {
        String ret = "";
        File iconFile = new File(execFile.getAbsolutePath() + ".app", "Contents/Resources/app.icns");
        if (!iconFile.exists() && Objects.equals(applicationId, "uninstaller")) {
            String applicationName = ContentInstaller.replaceSlashes(config.getApplicationName());
            String uninstallerName = Messages.format(Messages.getMessages().getString("UninstallerMenuEntry"), applicationName);
            iconFile = new File(execFile.getParentFile() + "/" + uninstallerName + ".app", "Contents/Resources/app.icns");
        }
        if (!iconFile.exists() && config.getMacSpecificConfig().isSingleBundle()) {
            String executableDir = customApplication.getUsedExecutableDirectory();
            if (executableDir.startsWith(config.getMacSpecificConfig().getRuntimeDirParent())) {
                executableDir = executableDir.substring(config.getMacSpecificConfig().getRuntimeDirParent().length());
            }
            if (!(iconFile = new File(ResourceHelper.getRuntimeDir(), "icons/" + executableDir + "/" + customApplication.getExecutableName() + ".icns")).exists()) {
                iconFile = new File(ResourceHelper.getRuntimeDir(), "icons/app.icns");
            }
        }
        if (iconFile.exists()) {
            ret = ret + "\"-Xdock:icon=" + iconFile.getAbsolutePath() + "\" ";
        }
        ret = ret + "\"-Xdock:name=" + customApplication.getExecutableName() + "\"";
        return ret;
    }

    private static class CommFileWaiter
    extends Thread {
        private File commFile;
        private ApplicationLauncher.Callback callback;
        private Process process;

        private CommFileWaiter(File commFile, ApplicationLauncher.Callback callback, Process process) {
            super("_i4j_commfile_waiter");
            this.setDaemon(true);
            this.setPriority(4);
            this.process = process;
            this.commFile = commFile;
            this.callback = callback;
            commFile.deleteOnExit();
        }

        @Override
        public void run() {
            boolean running = true;
            int exitValue = 0;
            while (running && this.commFile.length() == 0L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    exitValue = this.process.exitValue();
                    running = false;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
            this.exited(exitValue);
        }

        public synchronized void exited(int exitCode) {
            Variables.clearInstallerVariablesCache();
            boolean debug = Boolean.getBoolean("install4j.debugShutdownFile");
            if (debug) {
                System.err.println("application exited");
            }
            if (this.commFile.length() > 0L) {
                if (debug) {
                    System.err.println("commFile = " + this.commFile);
                    System.err.println("commFile.length() = " + this.commFile.length());
                }
                if (this.callback != null) {
                    this.callback.prepareShutdown();
                }
                System.exit(0);
            } else if (this.callback != null) {
                this.callback.exited(exitCode);
            }
            this.commFile.delete();
        }
    }
}

