/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.RegistryView;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.beans.actions.desktop.IconSource;
import com.install4j.runtime.beans.actions.registry.DeleteRegistryItemAction;
import com.install4j.runtime.beans.actions.registry.SetRegistryValueAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MsiHelper;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class RegisterAddRemoveAction
extends SystemAutoUninstallInstallAction {
    private static final String UNINSTALL_KEY = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\";
    private static final String DISPLAY_NAME_VALUE_NAME = "DisplayName";
    private static final String DISPLAY_ICON_VALUE_NAME = "DisplayIcon";
    private static final String DISPLAY_VERSION_VALUE_NAME = "DisplayVersion";
    private static final String UNINSTALL_STRING_VALUE_NAME = "UninstallString";
    private static final String PUBLISHER_VALUE_NAME = "Publisher";
    private static final String URL_INFO_ABOUT_VALUE_NAME = "URLInfoAbout";
    private static final String VERSION_MAJOR_VALUE_NAME = "VersionMajor";
    private static final String VERSION_MINOR_VALUE_NAME = "VersionMinor";
    private static final String INSTALL_LOCATION_VALUE_NAME = "InstallLocation";
    private static final String MSI_PREFIX = "MsiExec.exe /X";
    private static final String MSI_UNINSTALLER_VARIABLE = " I4JUNINSTALLER=";
    private String itemName = "";
    private IconSource iconSource = IconSource.INSTALLER;
    private ExternalFile icon;

    public String getItemName() {
        return RegisterAddRemoveAction.replaceVariables(RegisterAddRemoveAction.replaceVariables(this.itemName, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE));
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public IconSource getIconSource() {
        return this.replaceWithTextOverride("iconSource", this.iconSource, IconSource.class);
    }

    public void setIconSource(IconSource iconSource) {
        this.iconSource = iconSource;
    }

    public ExternalFile getIcon() {
        return this.replaceWithTextOverride("icon", this.icon, ExternalFile.class);
    }

    public void setIcon(ExternalFile icon) {
        this.icon = icon;
    }

    @Override
    public boolean uninstall(UninstallerContext context) throws UserCanceledException {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        File uninstaller = context.getDestinationFile(this.getUninstallerFilename());
        if (uninstaller.exists()) {
            this.removeUninstallLinks(uninstaller, context);
        }
        return true;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        String publisherURL;
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        File uninstaller = context.getDestinationFile(this.getUninstallerFilename());
        if (!uninstaller.exists()) {
            Logger.getInstance().log(this, "No uninstaller was found.", false);
            return false;
        }
        this.removeUninstallLinks(uninstaller, context);
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        RegistryRoot root = RegistryRoot.HKEY_LOCAL_MACHINE;
        String uninstallKey = this.getUnusedKey(UNINSTALL_KEY + context.getApplicationId(), root);
        if (WinRegistry.createKey(root, uninstallKey)) {
            WinRegistry.deleteKey(root, uninstallKey, true);
        } else {
            root = RegistryRoot.HKEY_CURRENT_USER;
            uninstallKey = this.getUnusedKey(UNINSTALL_KEY + context.getApplicationId(), root);
        }
        SetRegistryValueAction action = new SetRegistryValueAction(root, uninstallKey, DISPLAY_NAME_VALUE_NAME, this.getItemName(), false);
        this.addRollbackAction(action);
        action.execute(context);
        File iconFile = this.getUsedIconFile(context);
        if (iconFile != null) {
            action = new SetRegistryValueAction(root, uninstallKey, DISPLAY_ICON_VALUE_NAME, iconFile.getAbsolutePath(), false);
            this.addRollbackAction(action);
            action.execute(context);
        }
        String uninstallerString = "\"" + uninstaller.getAbsolutePath() + "\"";
        String msiProduct = MsiHelper.getMsiProductId();
        if (msiProduct != null) {
            uninstallerString = MSI_PREFIX + msiProduct + MSI_UNINSTALLER_VARIABLE + uninstallerString;
        }
        action = new SetRegistryValueAction(root, uninstallKey, UNINSTALL_STRING_VALUE_NAME, uninstallerString, false);
        this.addRollbackAction(action);
        action.execute(context);
        String publisherName = config.getPublisherName();
        if (publisherName != null && !Objects.equals(publisherName.trim(), "")) {
            action = new SetRegistryValueAction(root, uninstallKey, PUBLISHER_VALUE_NAME, publisherName, false);
            this.addRollbackAction(action);
            action.execute(context);
        }
        if ((publisherURL = config.getPublisherURL()) != null && !Objects.equals(publisherURL.trim(), "")) {
            action = new SetRegistryValueAction(root, uninstallKey, URL_INFO_ABOUT_VALUE_NAME, publisherURL, false);
            this.addRollbackAction(action);
            action.execute(context);
        }
        action = new SetRegistryValueAction(root, uninstallKey, INSTALL_LOCATION_VALUE_NAME, context.getInstallationDirectory().getAbsolutePath(), false);
        this.addRollbackAction(action);
        action.execute(context);
        try {
            action = new SetRegistryValueAction(root, uninstallKey, DISPLAY_VERSION_VALUE_NAME, InstallerConfig.getCurrentInstance().getApplicationVersion(), false);
            this.addRollbackAction(action);
            action.execute(context);
            StringTokenizer tok = new StringTokenizer(InstallerConfig.getCurrentInstance().getApplicationVersion(), ",.", false);
            if (tok.hasMoreTokens()) {
                action = new SetRegistryValueAction(root, uninstallKey, VERSION_MAJOR_VALUE_NAME, new Integer(tok.nextToken().trim()), false);
                this.addRollbackAction(action);
                action.execute(context);
            }
            if (tok.hasMoreTokens()) {
                action = new SetRegistryValueAction(root, uninstallKey, VERSION_MINOR_VALUE_NAME, new Integer(tok.nextToken().trim()), false);
                this.addRollbackAction(action);
                action.execute(context);
            }
        }
        catch (Exception e) {
            Logger.getInstance().info(this, "Could not set app version: " + e.getMessage());
        }
        return true;
    }

    private File getUsedIconFile(InstallerContext context) {
        switch (this.getIconSource()) {
            case INSTALLER: {
                File icoFileName = new File(ContextImpl.getContextInt(context).getRuntimeDirectory(), "installer.ico");
                if (icoFileName.exists()) {
                    return icoFileName;
                }
                return null;
            }
            case CUSTOM: {
                return context.getExternalFile(this.getIcon(), true);
            }
        }
        throw new RuntimeException(this.getIconSource().name());
    }

    private String getUnusedKey(String baseUninstallKey, RegistryRoot root) {
        String uninstallKey = baseUninstallKey;
        int count = 0;
        boolean win64 = Util.is64BitWindows();
        while (this.keyExistsForEveryBitness(win64, root, uninstallKey)) {
            uninstallKey = baseUninstallKey + "-" + ++count;
        }
        return uninstallKey;
    }

    private boolean keyExistsForEveryBitness(boolean win64, RegistryRoot root, String uninstallKey) {
        if (win64) {
            return WinRegistry.keyExists(root, uninstallKey, RegistryView.BIT32) || WinRegistry.keyExists(root, uninstallKey, RegistryView.BIT64);
        }
        return WinRegistry.keyExists(root, uninstallKey);
    }

    private String getUninstallerFilename() {
        return InstallerConfig.getCurrentInstance().getUninstallerPath() + ".exe";
    }

    private void removeUninstallLinks(File uninstaller, Context context) throws UserCanceledException {
        this.removeUninstallLinks(uninstaller, context, RegistryRoot.HKEY_LOCAL_MACHINE);
        this.removeUninstallLinks(uninstaller, context, RegistryRoot.HKEY_CURRENT_USER);
    }

    private void removeUninstallLinks(File uninstaller, Context context, RegistryRoot registryRoot) throws UserCanceledException {
        String[] subKeys = WinRegistry.getSubKeyNames(registryRoot, UNINSTALL_KEY);
        if (subKeys != null) {
            for (String subKey : subKeys) {
                File regUninstallerFile;
                String regUninstallerStringLowerCase;
                String softwareKey = UNINSTALL_KEY + subKey;
                Object regUninstallerObject = WinRegistry.getValue(registryRoot, softwareKey, UNINSTALL_STRING_VALUE_NAME);
                if (!(regUninstallerObject instanceof String)) continue;
                String regUninstallerString = ((String)regUninstallerObject).trim();
                if ((regUninstallerString = RegisterAddRemoveAction.getFromMsiValue(regUninstallerString)).startsWith("\"")) {
                    regUninstallerString = regUninstallerString.substring(1);
                }
                if (regUninstallerString.endsWith("\"")) {
                    regUninstallerString = regUninstallerString.substring(0, regUninstallerString.length() - 1);
                }
                if (!(regUninstallerStringLowerCase = regUninstallerString.toLowerCase(Locale.ENGLISH)).endsWith(".exe") || !regUninstallerStringLowerCase.startsWith(uninstaller.getAbsolutePath().substring(0, 2).toLowerCase(Locale.ENGLISH)) || !(regUninstallerFile = new File(regUninstallerString)).exists()) continue;
                try {
                    if (!Objects.equals(regUninstallerFile.getCanonicalFile(), uninstaller.getCanonicalFile())) continue;
                    DeleteRegistryItemAction action = new DeleteRegistryItemAction(registryRoot, softwareKey, "", false);
                    this.addRollbackAction(action);
                    action.execute(context);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @NotNull
    private static String getFromMsiValue(String regUninstallerString) {
        int uninstallerStart;
        if (regUninstallerString.startsWith(MSI_PREFIX) && (uninstallerStart = regUninstallerString.indexOf(MSI_UNINSTALLER_VARIABLE)) > -1) {
            regUninstallerString = regUninstallerString.substring(uninstallerStart + MSI_UNINSTALLER_VARIABLE.length());
        }
        return regUninstallerString;
    }
}

