/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.util;

import java.text.NumberFormat;
import java.text.ParseException;

public class JavaVersion {
    private static final String VERSION = System.getProperty("java.version");
    public static final boolean JAVA5 = VERSION.startsWith("1.5.");
    public static final boolean JAVA6 = VERSION.startsWith("1.6.");
    public static final boolean JAVA6U10_OR_ABOVE = JavaVersion.isJava6uNOrAbove(10);
    public static final boolean JAVA7 = VERSION.startsWith("1.7.");
    public static final boolean JAVA7_OR_ABOVE = !JAVA5 && !JAVA6;
    public static final boolean JAVA7U8_OR_ABOVE = JavaVersion.isJava7uNOrAbove(8);
    public static final boolean JAVA8 = VERSION.startsWith("1.8.");
    public static final boolean JAVA9 = VERSION.startsWith("9");
    public static final boolean JAVA8_OR_ABOVE = JAVA8 || !JAVA7 && !JAVA6 && !JAVA5;
    public static final boolean JAVA9_OR_ABOVE = JAVA9 || !JAVA8 && !JAVA7 && !JAVA6 && !JAVA5;

    public static boolean isJava6uNOrAbove(int n) {
        if (JAVA5) {
            return false;
        }
        if (VERSION.equals("1.6.0")) {
            return false;
        }
        if (VERSION.startsWith("1.6.0_")) {
            try {
                int n2 = ((Long)NumberFormat.getIntegerInstance().parse(VERSION.substring(6))).intValue();
                return n2 >= n;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }

    public static boolean isJava7uNOrAbove(int n) {
        if (JAVA5 || JAVA6) {
            return false;
        }
        if (VERSION.equals("1.7.0")) {
            return false;
        }
        if (VERSION.startsWith("1.7.0_")) {
            try {
                int n2 = ((Long)NumberFormat.getIntegerInstance().parse(VERSION.substring(6))).intValue();
                return n2 >= n;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }
}

