/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.TablePainter;
import de.javasoft.swing.JYTableScrollPane;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.plaf.synth.SynthContext;

public class JYTablePainter
extends TablePainter {
    public static final String JYTABLE_PAINTER = "Synthetica.JYTablePainter";
    private static String[] orderKeys = new String[]{"", ".ascending", ".descending"};

    public static JYTablePainter getInstance() {
        return JYTablePainter.getInstance(null);
    }

    public static JYTablePainter getInstance(SynthContext sc) {
        TablePainter instance = (TablePainter)instances.get(JYTablePainter.getPainterClassName(sc, JYTablePainter.class, JYTABLE_PAINTER));
        if (instance == null) {
            instance = (TablePainter)JYTablePainter.getInstance(sc, JYTablePainter.class, JYTABLE_PAINTER);
        }
        return (JYTablePainter)instance;
    }

    @Override
    public void paintTableHeaderBackground(JTable table, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        String imagePath = SyntheticaLookAndFeel.getString("JYTable.header.background.image", table);
        if (imagePath == null || !this.hasVisibleSubHeaders(table)) {
            super.paintTableHeaderBackground(table, state, g, x, y, w, h);
        } else {
            Insets sInsets = SyntheticaLookAndFeel.getInsets("JYTable.header.background.image.insets", (Component)table, true);
            ImagePainter imagePainter = new ImagePainter(table.getTableHeader(), g, x, y, w, h, imagePath, sInsets, sInsets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintTableSubHeaderBackground(JTable table, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        String imagePath = SyntheticaLookAndFeel.getString("JYTable.subHeader.background.image", table);
        if (imagePath == null) {
            this.paintTableHeaderBackground(table, state, g, x, y, w, h);
        } else {
            Insets sInsets = SyntheticaLookAndFeel.getInsets("JYTable.subHeader.background.image.insets", (Component)table, true);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, sInsets, 0, 0);
            imagePainter.draw();
        }
    }

    @Override
    public void paintTableHeaderCellBackground(JTable table, SyntheticaState state, Graphics g, int x, int y, int w, int h, int sortOrder) {
        String imagePath = SyntheticaLookAndFeel.getString("JYTable.header.cell" + orderKeys[sortOrder] + ".background.image", table);
        if (imagePath == null || !this.hasVisibleSubHeaders(table)) {
            super.paintTableHeaderCellBackground(table, state, g, x, y, w, h, sortOrder);
        } else {
            Insets sInsets = SyntheticaLookAndFeel.getInsets("JYTable.header.cell.background.image.insets", (Component)table, true);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, sInsets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintTableSubHeaderCellBackground(JTable table, SyntheticaState state, Graphics g, int x, int y, int w, int h, int sortOrder) {
        String imagePath = SyntheticaLookAndFeel.getString("JYTable.subHeader.cell" + orderKeys[sortOrder] + ".background.image", table);
        if (imagePath == null) {
            this.paintTableHeaderCellBackground(table, state, g, x, y, w, h, sortOrder);
        } else {
            Insets sInsets = SyntheticaLookAndFeel.getInsets("JYTable.subHeader.cell.background.image.insets", (Component)table, true);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, sInsets, 0, 0);
            imagePainter.draw();
        }
    }

    private boolean hasVisibleSubHeaders(JTable table) {
        if (table.getParent() != null && table.getParent().getParent() instanceof JYTableScrollPane) {
            JYTableScrollPane scroller = (JYTableScrollPane)table.getParent().getParent();
            return scroller.getColumnSubHeaderCount() > 0;
        }
        return false;
    }

    public static /* bridge */ /* synthetic */ TablePainter getInstance(SynthContext synthContext) {
        return JYTablePainter.getInstance(synthContext);
    }

    public static /* bridge */ /* synthetic */ TablePainter getInstance() {
        return JYTablePainter.getInstance();
    }
}

