/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.plaf.basic.BasicJYButtonUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;

public class SyntheticaJYButtonUI
extends BasicJYButtonUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new SyntheticaJYButtonUI();
    }

    protected void installDefaults(AbstractButton abstractButton) {
        Border border;
        super.installDefaults(abstractButton);
        Font font = abstractButton.getFont();
        if (font == null || font instanceof UIResource) {
            if (UIManager.getFont("Button.font") == null) {
                abstractButton.setFont(new FontUIResource(SyntheticaLookAndFeel.getFontName(), 0, SyntheticaLookAndFeel.getFontSize()));
            } else {
                abstractButton.setFont(new FontUIResource(UIManager.getFont("Button.font").deriveFont(0)));
            }
        }
        abstractButton.setOpaque(false);
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(abstractButton, Region.BUTTON);
        SynthContext synthContext = new SynthContext(abstractButton, Region.BUTTON, synthStyle, 0);
        Insets insets = (Insets)synthStyle.get(synthContext, "Button.margin");
        Insets insets2 = synthStyle.getInsets(synthContext, null);
        this.textShiftOffset = synthStyle.getInt(synthContext, "Button.textShiftOffset", 0);
        Insets insets3 = abstractButton.getMargin();
        if (insets3 == null || insets3 instanceof UIResource) {
            abstractButton.setMargin(new InsetsUIResource(insets.top, insets.left, insets.bottom, insets.right));
        }
        if ((border = abstractButton.getBorder()) == null || border instanceof UIResource) {
            abstractButton.setBorder(WidgetUtils.createRotatableEmptyBorder(insets2, true));
        }
        LookAndFeel.installProperty(abstractButton, "rolloverEnabled", Boolean.TRUE);
    }

    protected void paintButtonText(AbstractButton abstractButton, String string, Graphics graphics, Rectangle rectangle) {
        View view = (View)abstractButton.getClientProperty("html");
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            FontMetrics fontMetrics = abstractButton.getFontMetrics(abstractButton.getFont());
            rectangle.y += fontMetrics.getAscent();
            SynthStyle synthStyle = SynthLookAndFeel.getStyle(abstractButton, Region.BUTTON);
            SynthContext synthContext = new SynthContext(abstractButton, Region.BUTTON, synthStyle, abstractButton.isEnabled() ? 0 : 8);
            Color color = abstractButton.isEnabled() ? abstractButton.getForeground() : synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND);
            graphics.setColor(color);
            synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string, rectangle.x, rectangle.y - graphics.getFontMetrics().getAscent(), abstractButton.getDisplayedMnemonicIndex());
        }
    }
}

