/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.jydocking.ActiveDockableTracker;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingPath;
import de.javasoft.swing.jydocking.DockingPortTracker;
import de.javasoft.swing.jydocking.DockingState;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.NestedComponents;
import de.javasoft.swing.jydocking.Perspective;
import de.javasoft.swing.jydocking.RootWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

class RestorationManager {
    private static final String[] REGIONS = new String[]{"CENTER", "WEST", "EAST", "SOUTH", "NORTH"};
    private static final RestorationManager INSTANCE = new RestorationManager();

    private RestorationManager() {
    }

    public static RestorationManager getInstance() {
        return INSTANCE;
    }

    public boolean restore(IDockable iDockable, Perspective perspective) {
        DockingState dockingState = perspective.getDockingState(iDockable, true);
        if (this.restoreMaximized(iDockable, perspective, dockingState)) {
            return true;
        }
        if (this.restoreAlreadyRestored(iDockable, perspective, dockingState)) {
            return true;
        }
        if (this.restoreFloating(iDockable, perspective, dockingState)) {
            return true;
        }
        if (this.restoreMinimized(iDockable, perspective, dockingState)) {
            return true;
        }
        if (this.restoreRelative(iDockable, perspective, dockingState)) {
            return true;
        }
        if (this.restoreDockingPath(iDockable, perspective, dockingState)) {
            return true;
        }
        if (this.restorePoint(iDockable, perspective, dockingState)) {
            return true;
        }
        return this.restoreUnknownState(iDockable, perspective, dockingState);
    }

    private boolean restoreAlreadyRestored(IDockable iDockable, Perspective perspective, DockingState dockingState) {
        if (!DockingManager.isDocked(iDockable)) {
            return false;
        }
        ActiveDockableTracker.requestDockableActivation(iDockable.getComponent(), false);
        this.focus(iDockable.getComponent());
        return true;
    }

    private void focus(final Component component) {
        RootWindow rootWindow = RootWindow.getRootWindow(component);
        if (rootWindow == null) {
            return;
        }
        Component component2 = rootWindow.getRootComponent();
        Component component3 = component;
        Container container = component3.getParent();
        while (container != component2) {
            if (container instanceof JTabbedPane && ((JTabbedPane)container).indexOfComponent(component3) > 0) {
                ((JTabbedPane)container).setSelectedComponent(component3);
            } else if (container.getParent() instanceof JYTabbedPane && ((JTabbedPane)container.getParent()).indexOfComponent(component3) > 0) {
                ((JTabbedPane)container.getParent()).setSelectedComponent(component3);
            }
            component3 = container;
            container = component3.getParent();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                component.requestFocus();
            }
        });
    }

    private boolean restoreDockingPath(IDockable iDockable, Perspective perspective, DockingState dockingState) {
        DockingPath dockingPath = dockingState.getPath();
        return dockingPath == null ? false : dockingPath.restore(iDockable, perspective);
    }

    private boolean restoreFloating(IDockable iDockable, Perspective perspective, DockingState dockingState) {
        if (dockingState == null || !dockingState.isFloating()) {
            return false;
        }
        Component component = this.getRestoreContainer(iDockable);
        if (component == null) {
            return false;
        }
        Window window = DockingManager.floatDockable(iDockable, component, perspective);
        return window != null;
    }

    private boolean restoreMaximized(IDockable iDockable, Perspective perspective, DockingState dockingState) {
        if (dockingState == null || !dockingState.isMaximized()) {
            return false;
        }
        IDockingPort iDockingPort = DockingManager.getRootDockingPort(iDockable.getComponent());
        if (iDockingPort == null) {
            return false;
        }
        iDockingPort.uninstallMaximizedDockable();
        DockingManager.returnFromMaximization(iDockingPort);
        DockingManager.removeMaximizedState(iDockingPort);
        return DockingManager.isMaximized(iDockable);
    }

    private boolean restoreMinimized(IDockable iDockable, Perspective perspective, DockingState dockingState) {
        if (dockingState == null || !dockingState.isMinimized()) {
            return false;
        }
        DockingPath dockingPath = dockingState.getPath();
        return dockingPath == null ? false : dockingPath.restore(iDockable, perspective);
    }

    private boolean restorePoint(IDockable iDockable, Perspective perspective, DockingState dockingState) {
        if (DockingManager.isDocked(iDockable) || !dockingState.hasCenterPoint()) {
            return false;
        }
        RootWindow rootWindow = RootWindow.getRootWindow(this.getRestoreContainer(iDockable));
        Container container = rootWindow.getContentPane();
        float f = (float)dockingState.getCenterX() / 100.0f;
        float f2 = (float)dockingState.getCenterY() / 100.0f;
        Point point = new Point();
        point.x = Math.round((float)container.getWidth() * f);
        point.y = Math.round((float)container.getHeight() * f2);
        Component component = SwingUtilities.getDeepestComponentAt(container, point.x, point.y);
        NestedComponents nestedComponents = NestedComponents.find(component, IDockable.class, IDockingPort.class);
        IDockingPort iDockingPort = nestedComponents == null ? null : (IDockingPort)((Object)nestedComponents.parent);
        Point point2 = iDockingPort == null ? null : SwingUtilities.convertPoint(container, point, iDockingPort.getComponent());
        String string = iDockingPort == null ? "UNKNOWN" : iDockingPort.getRegion(point2);
        return DockingManager.dock(iDockable, iDockingPort, perspective, string);
    }

    private boolean restoreRelative(IDockable iDockable, Perspective perspective, DockingState dockingState) {
        IDockable iDockable2;
        IDockable iDockable3 = iDockable2 = dockingState == null ? null : DockingManager.getDockable(dockingState.getRelativeParentID());
        if (!DockingManager.isDocked(iDockable2)) {
            return false;
        }
        DockingState dockingState2 = DockingManager.getPerspectiveManager().getCurrentPerspective().getDockingState(iDockable2, false);
        if (dockingState2 == null || dockingState2.isFloating() || dockingState2.isMinimized()) {
            return false;
        }
        float f = dockingState.getSplitRatio();
        String string = dockingState.getRegion();
        boolean bl = DockingManager.dockRelative(iDockable, iDockable2, perspective, string, f);
        if (bl) {
            DockingUtility.setSplitProportion(iDockable, f);
        }
        return bl;
    }

    private boolean restoreUnknownState(IDockable iDockable, Perspective perspective, DockingState dockingState) {
        IDockingPort iDockingPort = DockingPortTracker.getRootDockingPort(null, false);
        if (iDockingPort == null) {
            return false;
        }
        if (iDockingPort.getDockedComponent() == null) {
            return this.dock(iDockable, null, iDockingPort, perspective);
        }
        DockingInfo dockingInfo = this.getDeepestWest(iDockingPort);
        if (dockingInfo.dockable == null) {
            return this.dock(iDockable, null, dockingInfo.port, perspective);
        }
        return this.dock(iDockable, dockingInfo.dockable, null, perspective);
    }

    private DockingInfo getDeepestWest(IDockingPort iDockingPort) {
        Component component = iDockingPort.getDockedComponent();
        if (component instanceof JTabbedPane) {
            IDockable iDockable = iDockingPort.getDockable("CENTER");
            return new DockingInfo(iDockable, iDockingPort);
        }
        if (component instanceof JSplitPane && (component = ((JSplitPane)component).getLeftComponent()) instanceof IDockingPort) {
            return this.getDeepestWest((IDockingPort)((Object)component));
        }
        return new DockingInfo(DockingManager.getDockable(component), iDockingPort);
    }

    private boolean dock(IDockable iDockable, IDockable iDockable2, IDockingPort iDockingPort, Perspective perspective) {
        boolean bl = false;
        int n = 0;
        while (n < REGIONS.length) {
            bl = iDockable2 == null ? DockingManager.dock(iDockable, iDockingPort, perspective, REGIONS[n]) : DockingManager.dock(iDockable, iDockable2, perspective, REGIONS[n], -1.0f);
            if (bl) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private RootWindow getRestoreWindow(IDockable iDockable) {
        RootWindow rootWindow = RootWindow.getRootWindow(iDockable.getComponent());
        return rootWindow != null ? rootWindow : DockingPortTracker.getDockingRootWindows().get(0);
    }

    private Component getRestoreContainer(IDockable iDockable) {
        RootWindow rootWindow = this.getRestoreWindow(iDockable);
        return rootWindow == null ? null : rootWindow.getRootComponent();
    }

    private static class DockingInfo {
        private IDockable dockable;
        private IDockingPort port;

        private DockingInfo(IDockable iDockable, IDockingPort iDockingPort) {
            this.dockable = iDockable;
            this.port = iDockingPort;
        }
    }
}

