/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.RootWindow;
import java.awt.Component;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NestedComponents {
    Component searchSrc;
    Component child;
    Component parent;

    public static NestedComponents find(Component component, Class<?> clazz, Class<?> clazz2) {
        if (component == null || clazz == null || clazz2 == null) {
            return null;
        }
        NestedComponents nestedComponents = new NestedComponents(component, null, null);
        Component component2 = component;
        while (component2 != null && (!(component2 instanceof JRootPane) || component2.getParent() instanceof JInternalFrame)) {
            if (nestedComponents.child == null && NestedComponents.isInstanceOf(component2, clazz)) {
                nestedComponents.child = component2;
            } else if (nestedComponents.child == null && component2 instanceof JTabbedPane && NestedComponents.isInstanceOf(((JTabbedPane)component2).getSelectedComponent(), clazz)) {
                nestedComponents.child = ((JTabbedPane)component2).getSelectedComponent();
            } else if (NestedComponents.isParentContainer(component2, clazz2)) {
                nestedComponents.parent = component2;
                break;
            }
            component2 = component2.getParent();
        }
        return nestedComponents;
    }

    private static boolean isParentContainer(Component component, Class<?> clazz) {
        if (clazz == RootWindow.class) {
            return RootWindow.isValidRootContainer(component);
        }
        return clazz.isAssignableFrom(component.getClass());
    }

    private static boolean isInstanceOf(Object object, Class<?> clazz) {
        if (clazz.isAssignableFrom(object.getClass())) {
            return true;
        }
        if (clazz == IDockable.class) {
            return DockingUtility.isDockable(object);
        }
        return false;
    }

    private NestedComponents(Component component, Component component2, Component component3) {
        this.searchSrc = component;
        this.child = component2;
        this.parent = component3;
    }

    public boolean isFull() {
        return this.child != null && this.parent != null;
    }

    public int hashCode() {
        int n = this.searchSrc.hashCode();
        n += this.child == null ? 0 : this.child.hashCode();
        return n += this.parent == null ? 0 : this.parent.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof NestedComponents)) {
            return false;
        }
        NestedComponents nestedComponents = (NestedComponents)object;
        return this.searchSrc == nestedComponents.searchSrc && this.child == nestedComponents.child && this.parent == nestedComponents.parent;
    }
}

