/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.jydocking.DockingEvent;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingPort;
import de.javasoft.swing.jydocking.DockingPortTracker;
import de.javasoft.swing.jydocking.DockingSplitPane;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.DragManager;
import de.javasoft.swing.jydocking.DragOperation;
import de.javasoft.swing.jydocking.FloatingDialog;
import de.javasoft.swing.jydocking.FloatingFrame;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingConstants;
import de.javasoft.swing.jydocking.IDockingEventListener;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.IDockingStrategy;
import de.javasoft.swing.jydocking.IFloatingDockingPort;
import de.javasoft.swing.jydocking.IRegionChecker;
import de.javasoft.swing.jydocking.Perspective;
import de.javasoft.swing.jydocking.RootWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class DockingStrategy
implements IDockingStrategy,
IDockingConstants {
    static final String PREFERRED_PROPORTION = "DefaultDockingStrategy.PREFERRED_PROPORTION";
    static final String REGION = "region";

    public boolean dock(IDockable iDockable, IDockingPort iDockingPort, Perspective perspective, String string) {
        if (!this.isDockingPossible(iDockable, iDockingPort, string)) {
            return false;
        }
        DragOperation dragOperation = DragManager.getCurrentDragOperation();
        if (!this.dragThresholdElapsed(dragOperation)) {
            return false;
        }
        IDockingPort iDockingPort2 = iDockable.getDockingPort();
        DockingResults dockingResults = this.dropComponent(iDockable, iDockingPort, perspective, string, dragOperation);
        IDockingPort iDockingPort3 = dockingResults.dropTarget;
        if (!dockingResults.success) {
            DockingEvent dockingEvent = new DockingEvent(iDockable, iDockingPort2, iDockingPort3, dockingResults.success ? 4 : 5, DragManager.getDragContext(iDockable));
            dockingEvent.setRegion(string);
            DockingManager.dispatchEvent(dockingEvent, true, true);
        }
        return dockingResults.success;
    }

    public boolean undock(IDockable iDockable) {
        if (iDockable == null) {
            return false;
        }
        JComponent jComponent = iDockable.getComponent();
        Container container = jComponent.getParent();
        if (container == null) {
            return false;
        }
        RootWindow rootWindow = RootWindow.getRootWindow(container);
        if (container.getParent() instanceof JYTabbedPane) {
            container = container.getParent();
        }
        boolean bl = false;
        IDockingPort iDockingPort = DockingUtility.getParentDockingPort(jComponent);
        Map<Object, Object> map = DragManager.getDragContext(iDockable);
        DockingEvent dockingEvent = new DockingEvent(iDockable, iDockingPort, iDockingPort, 7, map);
        DockingManager.dispatchEvent(dockingEvent);
        if (iDockingPort != null) {
            bl = iDockingPort.undockComponent(jComponent);
        } else {
            container.remove(jComponent);
            bl = true;
        }
        if (rootWindow != null) {
            ((JComponent)rootWindow.getContentPane()).revalidate();
            ((JComponent)rootWindow.getContentPane()).repaint();
        }
        if (bl) {
            dockingEvent = new DockingEvent(iDockable, iDockingPort, iDockingPort, 6, map);
            DockingManager.dispatchEvent(dockingEvent, false, true);
        }
        return bl;
    }

    public IDockingPort createDockingPort(IDockingPort iDockingPort) {
        IDockingPort iDockingPort2 = this.createDockingPortImpl(iDockingPort);
        if (iDockingPort2 instanceof DockingPort && iDockingPort instanceof DockingPort) {
            DockingPort dockingPort = (DockingPort)iDockingPort2;
            DockingPort dockingPort2 = (DockingPort)iDockingPort;
            dockingPort.setBorderManager(dockingPort2.getBorderManager());
            dockingPort.setTabsAsDragSourceEnabled(dockingPort2.isTabsAsDragSourceEnabled());
            dockingPort.setRoot(false);
        }
        return iDockingPort2;
    }

    public JSplitPane createSplitPane(IDockingPort iDockingPort, String string) {
        JSplitPane jSplitPane = this.createSplitPaneImpl(iDockingPort, string);
        jSplitPane.putClientProperty(REGION, string);
        boolean bl = !DockingUtility.isRegionTopLeft(string);
        boolean bl2 = bl;
        jSplitPane.setResizeWeight((double)bl2);
        int n = 1;
        if ("NORTH".equals(string) || "SOUTH".equals(string)) {
            n = 0;
        }
        jSplitPane.setOrientation(n);
        jSplitPane.setBorder(null);
        jSplitPane.setDividerSize(SyntheticaLookAndFeel.getInt("JYDocking.splitPane.divider.size", jSplitPane, 3));
        jSplitPane.setOneTouchExpandable(false);
        if (!(jSplitPane.getUI() instanceof BasicSplitPaneUI)) {
            return jSplitPane;
        }
        return jSplitPane;
    }

    public int getInitialDividerLocation(IDockingPort iDockingPort, JSplitPane jSplitPane) {
        if (iDockingPort == null || jSplitPane == null) {
            return 0;
        }
        Container container = (Container)((Object)iDockingPort);
        Insets insets = container.getInsets();
        boolean bl = jSplitPane.getOrientation() == 0;
        int n = bl ? insets.top + insets.bottom : insets.left + insets.right;
        int n2 = bl ? container.getHeight() : container.getWidth();
        n2 -= n;
        double d = this.getDividerProportion(iDockingPort, jSplitPane);
        if (d < 0.0 || d > 1.0) {
            d = 0.5;
        }
        return (int)((double)n2 * d);
    }

    public double getDividerProportion(IDockingPort iDockingPort, JSplitPane jSplitPane) {
        IDockable iDockable;
        if (iDockingPort == null || jSplitPane == null) {
            return DockingManager.getDefaultSiblingSize();
        }
        Component component = this.getElderComponent(jSplitPane);
        if (component == null) {
            return DockingManager.getDefaultSiblingSize();
        }
        Float f = this.getPreferredProportion(jSplitPane, component);
        if (f != null) {
            return f.doubleValue();
        }
        if (component instanceof DockingSplitPane) {
            component = ((DockingSplitPane)component).getElderComponent();
        }
        if ((iDockable = DockingManager.getDockable(component)) != null) {
            IRegionChecker iRegionChecker = iDockingPort.getRegionChecker();
            float f2 = iRegionChecker.getSiblingSize(iDockable.getComponent(), this.getCreationRegion(jSplitPane));
            return this.isElderTopLeft(jSplitPane) ? 1.0f - f2 : f2;
        }
        return DockingManager.getDefaultSiblingSize();
    }

    public static IDockable getSibling(IDockable iDockable) {
        IDockingPort iDockingPort = iDockable.getDockingPort();
        String string = DockingStrategy.findRegion(iDockable.getComponent());
        String string2 = DockingUtility.flipRegion(string);
        return DockingStrategy.findDockable(iDockingPort, iDockable.getComponent(), string2, string);
    }

    public static IDockable getSibling(IDockable iDockable, String string) {
        if (iDockable == null || !DockingManager.isValidDockingRegion(string) || "CENTER".equals(string)) {
            return null;
        }
        IDockingPort iDockingPort = iDockable.getDockingPort();
        String string2 = DockingStrategy.findRegion(iDockable.getComponent());
        return DockingStrategy.findDockable(iDockingPort, iDockable.getComponent(), string, string2);
    }

    public static String findRegion(JComponent jComponent) {
        Object object;
        if (jComponent == null) {
            return null;
        }
        IDockingPort iDockingPort = DockingManager.getDockingPort(jComponent);
        JComponent jComponent2 = iDockingPort.getDockedComponent();
        if (!(jComponent2 instanceof JSplitPane)) {
            object = DockingManager.getDockingPort(iDockingPort.getComponent());
            JComponent jComponent3 = jComponent2 = object == null ? jComponent2 : object.getDockedComponent();
        }
        if (!(jComponent2 instanceof JSplitPane)) {
            return "CENTER";
        }
        object = (JSplitPane)jComponent2;
        boolean bl = ((JSplitPane)object).getOrientation() == 1;
        Component component = ((JSplitPane)object).getLeftComponent();
        if (component == iDockingPort) {
            return bl ? "WEST" : "NORTH";
        }
        return bl ? "EAST" : "SOUTH";
    }

    private static IDockable findDockable(IDockingPort iDockingPort, Component component, String string, String string2) {
        if (iDockingPort == null) {
            return null;
        }
        JComponent jComponent = iDockingPort.getDockedComponent();
        if (!(jComponent instanceof JSplitPane)) {
            IDockingPort iDockingPort2 = DockingManager.getDockingPort(iDockingPort.getComponent());
            return DockingStrategy.findDockable(iDockingPort2, component, string, string2);
        }
        JComponent jComponent2 = iDockingPort.getDockedComponent(string);
        if (jComponent2 == component) {
            if (!(component instanceof JSplitPane)) {
                IDockingPort iDockingPort3 = DockingManager.getDockingPort(iDockingPort.getComponent());
                return DockingStrategy.findDockable(iDockingPort3, component, string, string2);
            }
            return null;
        }
        if (jComponent2 instanceof JSplitPane) {
            IDockingPort iDockingPort4 = DockingManager.getDockingPort(jComponent2);
            JComponent jComponent3 = iDockingPort.getDockedComponent(DockingUtility.flipRegion(string));
            String string3 = DockingStrategy.findSubRegion((JSplitPane)jComponent2, jComponent3, string, string2);
            return DockingStrategy.findDockable(iDockingPort4, component, string3, string2);
        }
        if (jComponent2 == null) {
            IDockingPort iDockingPort5 = DockingManager.getDockingPort(iDockingPort.getComponent());
            component = iDockingPort.getDockedComponent();
            return DockingStrategy.findDockable(iDockingPort5, component, string, string2);
        }
        return DockingManager.getDockable(jComponent2);
    }

    private static String findSubRegion(JSplitPane jSplitPane, Component component, String string, String string2) {
        boolean bl;
        String string3 = DockingUtility.translateRegionAxis(jSplitPane, string);
        if (!(component instanceof JSplitPane)) {
            return string3;
        }
        boolean bl2 = bl = !string.equals(string3);
        if (bl && !DockingUtility.isAxisEquivalent(string3, string2)) {
            string3 = DockingUtility.flipRegion(string3);
        }
        return string3;
    }

    protected boolean dragThresholdElapsed(DragOperation dragOperation) {
        if (dragOperation == null || dragOperation.isPseudoDrag() || dragOperation.getStartTime() == -1L) {
            return true;
        }
        long l = System.currentTimeMillis() - dragOperation.getStartTime();
        return l > 200L;
    }

    protected boolean isDockingPossible(IDockable iDockable, IDockingPort iDockingPort, String string) {
        IDockingEventListener iDockingEventListener;
        if (this.isFloatable(iDockable, DragManager.getCurrentDragOperation())) {
            return true;
        }
        IDockingPort iDockingPort2 = DockingManager.getDockingPort(iDockable);
        if (iDockingPort2 instanceof IFloatingDockingPort && iDockingPort2 == iDockingPort && (iDockingEventListener = (IFloatingDockingPort)iDockingPort2).getDockableCount() == 1) {
            return false;
        }
        if (iDockable == null || iDockable.getComponent() == null || iDockingPort == null) {
            return false;
        }
        if (!DockingManager.isValidDockingRegion(string)) {
            return false;
        }
        iDockingEventListener = DockingManager.getDockable(iDockingPort.getDockedComponent());
        if (iDockingEventListener == null) {
            return true;
        }
        Container container = iDockingEventListener.getComponent().getParent();
        IDockingPort iDockingPort3 = DockingManager.getDockingPort(container);
        if (iDockingPort3 == null) {
            return true;
        }
        JComponent jComponent = iDockingPort3.getDockedComponent(string);
        return jComponent != iDockable.getComponent();
    }

    protected boolean isFloatable(IDockable iDockable, DragOperation dragOperation) {
        if (iDockable == null || iDockable.getComponent() == null || dragOperation == null || dragOperation.getCurrentMouse(true) == null) {
            return false;
        }
        if (dragOperation.isPseudoDrag()) {
            return false;
        }
        return !dragOperation.isOverWindow();
    }

    DockingResults dropComponent(IDockable iDockable, IDockingPort iDockingPort, Perspective perspective, String string, DragOperation dragOperation) {
        if (this.isFloatable(iDockable, dragOperation)) {
            return this.floatComponent(iDockable, iDockingPort, perspective, dragOperation);
        }
        DockingResults dockingResults = new DockingResults(iDockingPort, false);
        if ("UNKNOWN".equals(string) || iDockingPort == null) {
            return dockingResults;
        }
        JComponent jComponent = iDockingPort.getDockedComponent();
        JComponent jComponent2 = iDockable.getComponent();
        if (jComponent2 != null && jComponent2 == jComponent) {
            return dockingResults;
        }
        Container container = DockingUtility.getContentPane(iDockingPort.getComponent());
        Point point = dragOperation == null ? null : dragOperation.getCurrentMouse(container);
        IDockingPort iDockingPort2 = DockingUtility.findDockingPort(container, point);
        JComponent jComponent3 = iDockingPort2 == null ? null : iDockingPort2.getDockedComponent();
        this.undock(iDockable);
        if (point != null && container != null) {
            iDockingPort2 = DockingManager.getDockingPort(jComponent3);
            if (iDockingPort2 == null) {
                iDockingPort2 = DockingUtility.findDockingPort(container, point);
            }
            if (iDockingPort2 != null) {
                dockingResults.dropTarget = iDockingPort2;
                iDockingPort = dockingResults.dropTarget;
            }
        }
        dockingResults.success = iDockingPort.dockComponent(jComponent2, perspective, string);
        iDockingPort.getComponent().revalidate();
        return dockingResults;
    }

    DockingResults floatComponent(IDockable iDockable, IDockingPort iDockingPort, Perspective perspective, DragOperation dragOperation) {
        DockingResults dockingResults = new DockingResults(iDockingPort, false);
        Point point = dragOperation.getCurrentMouse(true);
        this.add(point, dragOperation.getMouseOffset());
        Rectangle rectangle = iDockable.getComponent().getBounds();
        rectangle.setLocation(point);
        RootWindow rootWindow = RootWindow.getRootWindow(iDockable.getComponent());
        Component component = rootWindow != null ? rootWindow.getRootComponent() : DockingPortTracker.getDockingRootWindows().get(0).getRootComponent();
        Window window = DockingManager.floatDockable(iDockable, component, perspective, rectangle);
        if (window instanceof FloatingDialog) {
            dockingResults.dropTarget = ((FloatingDialog)window).getDockingPort();
        } else if (window instanceof FloatingFrame) {
            dockingResults.dropTarget = ((FloatingFrame)window).getDockingPort();
        }
        dockingResults.success = true;
        return dockingResults;
    }

    private void add(Point point, Point point2) {
        if (point != null && point2 != null) {
            point.x += point2.x;
            point.y += point2.y;
        }
    }

    protected IDockingPort createDockingPortImpl(IDockingPort iDockingPort) {
        return new DockingPort();
    }

    protected JSplitPane createSplitPaneImpl(IDockingPort iDockingPort, String string) {
        return new DockingSplitPane(iDockingPort, string);
    }

    protected String getCreationRegion(JSplitPane jSplitPane) {
        if (jSplitPane instanceof DockingSplitPane) {
            return ((DockingSplitPane)jSplitPane).getRegion();
        }
        return (String)jSplitPane.getClientProperty(REGION);
    }

    protected boolean isElderTopLeft(JSplitPane jSplitPane) {
        if (jSplitPane instanceof DockingSplitPane) {
            return ((DockingSplitPane)jSplitPane).isElderTopLeft();
        }
        String string = this.getCreationRegion(jSplitPane);
        return !DockingUtility.isRegionTopLeft(string);
    }

    protected Float getPreferredProportion(JSplitPane jSplitPane, Component component) {
        Container container = component.getParent();
        return DockingStrategy.getPreferredProportion(container);
    }

    protected Component getElderComponent(JSplitPane jSplitPane) {
        Component component;
        if (jSplitPane instanceof DockingSplitPane) {
            return ((DockingSplitPane)jSplitPane).getElderComponent();
        }
        boolean bl = this.isElderTopLeft(jSplitPane);
        Component component2 = component = bl ? jSplitPane.getLeftComponent() : jSplitPane.getRightComponent();
        if (component instanceof IDockingPort) {
            component = ((IDockingPort)((Object)component)).getDockedComponent();
        }
        return component;
    }

    protected static Float getPreferredProportion(Component component) {
        return component == null ? null : (Float)((JComponent)component).getClientProperty(PREFERRED_PROPORTION);
    }

    private static class DockingResults {
        private IDockingPort dropTarget;
        private boolean success;

        public DockingResults(IDockingPort iDockingPort, boolean bl) {
            this.dropTarget = iDockingPort;
            this.success = bl;
        }
    }
}

