/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.IRotatableComponent;
import de.javasoft.swing.JYLabel;
import de.javasoft.swing.jydocking.Dockbar;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.IDockable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class DockbarLabel
extends JYLabel {
    private static final long serialVersionUID = 2965469910633138220L;
    public static final String uiClassID = "JYDockingDockbarLabelUI";
    private String dockingId;
    private int placement;

    public DockbarLabel(String string, int n) {
        this.dockingId = string;
        this.setPlacement(n);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                DockbarLabel.this.activate(true);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                DockbarLabel.this.activate(false);
            }
        });
        this.updateLabel();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    private void activate(boolean bl) {
        Dockbar dockbar = (Dockbar)SwingUtilities.getAncestorOfClass(Dockbar.class, this);
        if (dockbar != null) {
            dockbar.activate(this.dockingId, bl);
        }
    }

    private void updateLabel() {
        IDockable iDockable = this.getDockable();
        this.setText(iDockable.getTabText());
        this.setIcon(iDockable.getDockbarIcon());
    }

    private IRotatableComponent.Rotation placementToRotation(int n) {
        if (n == 3) {
            return IRotatableComponent.Rotation.NONE;
        }
        if (n == 4) {
            return IRotatableComponent.Rotation.RIGHT;
        }
        return IRotatableComponent.Rotation.LEFT;
    }

    public IDockable getDockable() {
        return DockingManager.getDockable(this.dockingId);
    }

    private void setPlacement(int n) {
        int n2 = this.placement;
        this.placement = n;
        this.setRotation(this.placementToRotation(this.getPlacement()));
        this.firePropertyChange("placement", n2, n);
    }

    public int getPlacement() {
        return this.placement;
    }
}

