/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc.logger;

import com.nuodb.jdbc.logger.Level;
import com.nuodb.jdbc.logger.Logger;
import com.nuodb.jdbc.logger.LoggerException;
import com.nuodb.jdbc.logger.LoggerFactory;
import com.nuodb.jdbc.logger.StandardLogger;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class StandardLoggerFactory
implements LoggerFactory {
    private Level level = StandardLogger.LEVEL_DEFAULT;
    private StandardLogger.Format format = StandardLogger.FORMAT_DEFAULT;
    private PrintWriter logWriter;
    private Map<String, Logger> loggers = new HashMap<String, Logger>();

    @Override
    public void init(Properties properties) throws LoggerException {
        String value = properties.getProperty("standardLogger.level");
        try {
            this.level = value != null ? Enum.valueOf(Level.class, value) : StandardLogger.LEVEL_DEFAULT;
        }
        catch (IllegalArgumentException exception) {
            throw new LoggerException(String.format("Standard logger level %s is invalid", value));
        }
        String pattern = properties.getProperty("standardLogger.pattern", "[%date(yyyy-MM-dd HH:mm:ss.SSS)] (%level) (%line(long)) - %message");
        this.format = StandardLogger.FormatParser.getInstance().parsePattern(pattern);
        Object logWriterObject = properties.get("standardLogger.logWriter");
        PrintWriter logWriter = null;
        if (logWriterObject instanceof PrintWriter) {
            logWriter = (PrintWriter)logWriterObject;
        } else if (logWriterObject instanceof String) {
            try {
                logWriter = new PrintWriter((String)logWriterObject);
            }
            catch (FileNotFoundException exception) {
                throw new LoggerException(exception);
            }
        }
        this.logWriter = logWriter;
    }

    @Override
    public Logger getLogger() {
        return this.getLogger("com.nuodb.jdbc");
    }

    @Override
    public Logger getLogger(String loggerName) {
        Logger logger = this.loggers.get(loggerName);
        if (logger == null) {
            logger = this.createLogger(loggerName);
            this.loggers.put(loggerName, logger);
        }
        return logger;
    }

    protected Logger createLogger(String loggerName) {
        StandardLogger logger = new StandardLogger(loggerName);
        logger.setFormat(this.format);
        logger.setLevel(this.level);
        logger.setLogWriter(this.logWriter);
        return logger;
    }
}

