/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Conversions;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.Resources;
import com.nuodb.jdbc.SQLContext;
import com.nuodb.jdbc.SQLException;
import com.nuodb.jdbc.SQLState;
import com.nuodb.jdbc.Value;
import java.math.BigDecimal;

public class ValueLong
extends Value {
    private final long value;

    public ValueLong(long value) {
        this.value = value;
    }

    public ValueLong(Object value) {
        this.value = value instanceof Number ? ((Number)value).longValue() : (value instanceof Boolean ? (Boolean.TRUE.equals(value) ? 1L : 0L) : Long.parseLong(value.toString()));
    }

    @Override
    int getType() {
        return 6;
    }

    @Override
    int getScale() {
        return 0;
    }

    @Override
    void encodeValue(EncodedDataStream dataStream) throws SQLException {
        dataStream.encodeLong(this.value);
    }

    @Override
    String getString() {
        return ValueLong.getString(this.value, 0);
    }

    @Override
    String getZeroPaddedString(int numZeroes, SQLContext context) {
        return ValueLong.getString(this.value, 0, numZeroes);
    }

    @Override
    boolean getBoolean() {
        return this.value != 0L;
    }

    @Override
    byte getByte() throws SQLException {
        long value = this.getLong();
        if (value < -128L || value > 127L) {
            throw new SQLException(Resources.getMessage("error.byte.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return (byte)value;
    }

    @Override
    short getShort() throws SQLException {
        long value = this.getLong();
        if (value < -32768L || value > 32767L) {
            throw new SQLException(Resources.getMessage("error.short.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return (short)value;
    }

    @Override
    int getInt() throws SQLException {
        long value = this.getLong();
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new SQLException(Resources.getMessage("error.int.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return (int)value;
    }

    @Override
    long getLong() {
        return this.value;
    }

    @Override
    float getFloat() {
        return this.getLong();
    }

    @Override
    double getDouble() {
        return this.getLong();
    }

    @Override
    BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.value, 0);
    }

    @Override
    Object getObject() {
        return this.getLong();
    }

    @Override
    public byte[] getBytes() {
        return Conversions.toBytes(this.getLong());
    }
}

