/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.xml;

import com.nuodb.impl.util.Preconditions;
import com.nuodb.xml.Attribute;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TagUtils {
    private static boolean equals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    private static Tag clone(Tag dst, Tag src) {
        Iterator<Attribute> attributes = src.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            dst.addAttribute(attribute.getName(), attribute.getValue());
        }
        if (src.getText() != null) {
            dst.setText(src.getText());
        }
        Iterator<Tag> children = src.children();
        while (children.hasNext()) {
            Tag srcChild = children.next();
            Tag dstChild = dst.addChild(srcChild.getName());
            TagUtils.clone(dstChild, srcChild);
        }
        return dst;
    }

    public static Tag clone(Tag tag) {
        return TagUtils.clone(TagFactory.createTag(tag.getName()), tag);
    }

    private static boolean allAttributesTheSame(Tag tag1, Tag tag2) {
        boolean result = true;
        if (tag1.getAttributeCount() != tag2.getAttributeCount()) {
            result = false;
        } else {
            Iterator<Attribute> iA = tag1.getAttributes();
            while (iA.hasNext()) {
                Attribute attr1 = iA.next();
                try {
                    String value2 = tag2.getAttribute(attr1.getName());
                    if (TagUtils.equals(attr1.getValue(), value2)) continue;
                    result = false;
                }
                catch (XmlException e) {
                    result = false;
                }
                break;
            }
        }
        return result;
    }

    private static Tag findMatchingTag(Tag tag1, Tag parentTag2) {
        Iterator<Tag> iTag2 = parentTag2.children();
        while (iTag2.hasNext()) {
            Tag tag2 = iTag2.next();
            if (!TagUtils.equals(tag1.getName(), tag2.getName()) || !TagUtils.allAttributesTheSame(tag1, tag2)) continue;
            return tag2;
        }
        return null;
    }

    public static boolean isSame(Tag parentTag1, Tag parentTag2) {
        if (!TagUtils.equals(parentTag1.getName(), parentTag2.getName())) {
            return false;
        }
        if (!TagUtils.allAttributesTheSame(parentTag1, parentTag2)) {
            return false;
        }
        if (parentTag1.getChildCount() != parentTag2.getChildCount()) {
            return false;
        }
        Iterator<Tag> iTag1 = parentTag1.children();
        while (iTag1.hasNext()) {
            Tag tag1 = iTag1.next();
            Tag tag2 = TagUtils.findMatchingTag(tag1, parentTag2);
            if (tag2 == null) {
                return false;
            }
            if (TagUtils.isSame(tag1, tag2)) continue;
            return false;
        }
        return true;
    }

    public static List<Tag> childrenAsList(Tag parentTag) {
        ArrayList<Tag> list = new ArrayList<Tag>();
        for (Tag childTag : parentTag) {
            list.add(childTag);
        }
        return list;
    }

    public static Tag mapAsTag(Map<?, ?> entries, String name, String elemName, String keyName) {
        ValueConverter<Object, String> toStringConverter = new ValueConverter<Object, String>(){

            @Override
            public String convert(Object value) {
                return value.toString();
            }
        };
        return TagUtils.mapAsTag(entries, name, elemName, keyName, toStringConverter, toStringConverter);
    }

    public static <K, V> Tag mapAsTag(Map<? extends K, ? extends V> entries, String name, String elemName, String keyName, ValueConverter<K, String> keyConverter, ValueConverter<V, String> valueConverter) {
        Tag tag = TagFactory.createTag(name);
        for (Map.Entry<K, V> elem : entries.entrySet()) {
            Tag entry = tag.addChild(elemName);
            entry.addAttribute(keyName, keyConverter.convert(elem.getKey()));
            entry.setText(valueConverter.convert(elem.getValue()));
        }
        return tag;
    }

    public static Map<String, String> asMap(Tag tag, String keyName) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Tag elem : tag) {
            String key = elem.getAttribute(keyName, null);
            if (key == null) continue;
            map.put(key, elem.getText());
        }
        return map;
    }

    public static <T> Map<String, T> asMap(Tag tag, String keyName, ValueConverter<String, T> converter) {
        HashMap<String, T> map = new HashMap<String, T>();
        for (Tag elem : tag) {
            String key = elem.getAttribute(keyName, null);
            if (key == null) continue;
            map.put(key, converter.convert(elem.getText()));
        }
        return map;
    }

    public static void writeFile(Tag tag, String filename, boolean overwriteIfExists) {
        OutputStreamWriter writer = null;
        try {
            File file = new File(filename);
            if (file.exists()) {
                Preconditions.checkArgument(overwriteIfExists, "file %s already exists", file.getAbsoluteFile());
            }
            writer = new FileWriter(filename);
            writer.write(tag.toString());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to write: " + filename, ioe);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static interface ValueConverter<S, T> {
        public T convert(S var1);
    }
}

