/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;

public class JVMUtils {
    public static String getJVMLibrary() {
        String javaHome = System.getProperty("java.home");
        String delim = System.getProperty("file.separator");
        String os = System.getProperty("os.name").toLowerCase();
        LinkedList<File> candidates = new LinkedList<File>();
        if (os.contains("windows")) {
            candidates.add(new File(javaHome + delim + "bin" + delim + "server" + delim + "jvm.dll"));
            candidates.add(new File(javaHome + delim + "bin" + delim + "client" + delim + "jvm.dll"));
            candidates.add(new File(javaHome + delim + "jre" + delim + "bin" + delim + "server" + delim + "jvm.dll"));
            candidates.add(new File(javaHome + delim + "jre" + delim + "bin" + delim + "client" + delim + "jvm.dll"));
        } else if (os.contains("linux")) {
            String arch = System.getProperty("os.arch");
            candidates.add(new File(javaHome + delim + "lib" + delim + "server" + delim + "libjvm.so"));
            candidates.add(new File(javaHome + delim + "lib" + delim + "client" + delim + "libjvm.so"));
            candidates.add(new File(javaHome + delim + "jre" + delim + "lib" + delim + "server" + delim + "libjvm.so"));
            candidates.add(new File(javaHome + delim + "jre" + delim + "lib" + delim + "client" + delim + "libjvm.so"));
            candidates.add(new File(javaHome + delim + "lib" + delim + arch + delim + "server" + delim + "libjvm.so"));
            candidates.add(new File(javaHome + delim + "lib" + delim + arch + delim + "client" + delim + "libjvm.so"));
            candidates.add(new File(javaHome + delim + "jre" + delim + "lib" + delim + arch + delim + "server" + delim + "libjvm.so"));
            candidates.add(new File(javaHome + delim + "jre" + delim + "lib" + delim + arch + delim + "client" + delim + "libjvm.so"));
        } else if (os.contains("mac")) {
            candidates.add(new File(javaHome + delim + "lib" + delim + "server" + delim + "libjvm.dylib"));
            candidates.add(new File(javaHome + delim + "lib" + delim + "client" + delim + "libjvm.dylib"));
            candidates.add(new File(javaHome + delim + ".." + delim + "Libraries" + delim + "libjvm.dylib"));
            candidates.add(new File("/System/Library/Frameworks/JavaVM.framework/JavaVM"));
        }
        try {
            for (File f : candidates) {
                if (!f.exists()) continue;
                return f.getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

