/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import com.nuodb.impl.util.Preconditions;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class Addresses {
    public static String formatAddress(String hostname, String address) {
        Preconditions.checkArgument(hostname != null || address != null, "No address or hostname provided");
        if (hostname == null) {
            return address;
        }
        if (address == null) {
            return hostname;
        }
        return hostname + "/" + address;
    }

    public static String asPrintString(InetAddress address, String advertised) {
        if (address == null) {
            return advertised;
        }
        String addr = address.toString();
        if (addr.indexOf(47) == 0 && advertised != null) {
            addr = advertised + addr;
        }
        return addr;
    }

    public static String asHostname(InetSocketAddress address) {
        return address.isUnresolved() ? address.getHostName() : address.getAddress().getHostAddress();
    }

    public static String asHostname(InetAddress address) {
        String result = address.getHostName();
        if (result == null) {
            result = address.getHostAddress();
        }
        return result;
    }

    public static InetSocketAddress splitAddress(String addr, int defaultPort) {
        return new AddressString(addr, defaultPort).asInetSocketAddress();
    }

    public static AddressString splitAddressString(String addr, int defaultPort) {
        return new AddressString(addr, defaultPort);
    }

    public static class AddressString {
        final String address;
        final int port;

        public AddressString(String addr, int defaultPort) {
            int splitPos = addr.indexOf(58);
            if (splitPos == -1) {
                this.address = addr;
                this.port = defaultPort;
                return;
            }
            this.address = addr.substring(0, splitPos);
            this.port = Integer.valueOf(addr.substring(splitPos + 1));
        }

        public InetSocketAddress asInetSocketAddress() {
            return new InetSocketAddress(this.address, this.port);
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return this.address + ":" + this.port;
        }
    }
}

