/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.security;

import com.nuodb.impl.security.Cipher;
import com.nuodb.impl.security.StreamCipher;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class CipherBaseAESCTR
implements StreamCipher {
    public static final String CIPHER_NAME = "AES/CTR/NOPADDING";
    protected final int keyLenBytes;
    private Cipher cipher;

    public CipherBaseAESCTR(int keyLenBytes) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.keyLenBytes = keyLenBytes;
        this.cipher = Cipher.getInstance(CIPHER_NAME);
    }

    @Override
    public void initialize(byte[] key, Cipher.CipherMode cipherMode, byte[] initializationVector) throws GeneralSecurityException {
        if (key.length != this.keyLenBytes) {
            throw new InvalidKeyException("Incorrect key length. Required length = " + this.keyLenBytes + ". Provided length = " + key.length);
        }
        SecretKeySpec cryptoKey = new SecretKeySpec(key, 0, key.length, "AES");
        if (initializationVector.length != this.getBlockSize()) {
            throw new InvalidParameterSpecException("Incorrect initialization vector length. Required length = " + this.getBlockSize());
        }
        IvParameterSpec initVectorParamSpec = new IvParameterSpec(initializationVector);
        try {
            this.cipher.init(cipherMode == Cipher.CipherMode.ENCRYPT ? 1 : 2, (Key)cryptoKey, initVectorParamSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
            // empty catch block
        }
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public void transform(byte[] data) throws GeneralSecurityException {
        this.transform(data, 0, data.length);
    }

    @Override
    public void transform(byte[] data, int offset, int length) throws GeneralSecurityException {
        this.cipher.update(data, offset, length, data, offset);
    }
}

