/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.HashtypeColumn;
import com.exasol.jdbc.IntervalDayColumn;
import com.exasol.jdbc.IntervalYearColumn;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.VarCharColumn;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class CharColumn
extends Column {
    protected String[] values;
    protected int maxWidth;
    protected int maxOctetLength;
    protected int maxWidthSpecified = 0;

    CharColumn() {
        this.values = new String[initialBatchCapacity];
        this.maxWidth = 0;
    }

    CharColumn(int n) {
        this.values = new String[initialBatchCapacity];
        this.maxWidth = n;
    }

    CharColumn(int n, int n2) {
        this.values = new String[initialBatchCapacity];
        this.maxWidth = n;
        this.maxOctetLength = n2;
    }

    CharColumn(String string, String[] stringArray) {
        super(string);
        this.values = stringArray;
        this.maxWidth = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.maxWidth >= this.values[i].length()) continue;
            this.maxWidth = this.values[i].length();
        }
    }

    @Override
    int getPrecision() throws SQLException {
        return this.maxWidth;
    }

    public void setMaxColumnSize(int n) {
        this.maxWidthSpecified = n;
    }

    public int getMaxColumnSize() {
        return this.maxWidthSpecified;
    }

    @Override
    void setPrecision(int n) {
        this.maxWidth = n;
    }

    @Override
    void setScale(int n) throws SQLException {
        throw new SQLException("Not implemented for CharColumn - setScale()");
    }

    @Override
    String getClassName() {
        return "java.lang.String";
    }

    @Override
    int getDisplaySize(EXAConnection eXAConnection) throws SQLException {
        return this.getPrecision();
    }

    int getOctetLength() {
        return this.maxOctetLength;
    }

    @Override
    int getType() {
        return 1;
    }

    @Override
    String getTypeName() {
        return "CHAR";
    }

    @Override
    Object getObject(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getObject: " + Translator.Accessed_null_value());
        }
        return this.values[n];
    }

    @Override
    String getString(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getString: " + Translator.Accessed_null_value());
        }
        return this.values[n];
    }

    @Override
    Time getTime(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getTime: " + Translator.Accessed_null_value());
        }
        return Time.valueOf(this.values[n]);
    }

    @Override
    boolean getBoolean(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getBoolean: " + Translator.Accessed_null_value());
        }
        if (this.values[n].trim().equalsIgnoreCase("1")) {
            return true;
        }
        if (this.values[n].trim().equalsIgnoreCase("0")) {
            return false;
        }
        if (this.values[n].trim().equalsIgnoreCase("Y")) {
            return true;
        }
        if (this.values[n].trim().equalsIgnoreCase("N")) {
            return false;
        }
        if (this.values[n].trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (this.values[n].trim().equalsIgnoreCase("false")) {
            return false;
        }
        throw new SQLException("CharColumn::getBoolean: " + Translator.Conversion_not_possible());
    }

    @Override
    byte getByte(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getByte: " + Translator.Accessed_null_value());
        }
        return Byte.parseByte(this.values[n]);
    }

    @Override
    double getDouble(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getDouble: " + Translator.Accessed_null_value());
        }
        return Double.parseDouble(this.values[n]);
    }

    @Override
    float getFloat(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getFloat: " + Translator.Accessed_null_value());
        }
        return Float.parseFloat(this.values[n]);
    }

    @Override
    int getInt(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getInt: " + Translator.Accessed_null_value());
        }
        return Integer.parseInt(this.values[n]);
    }

    @Override
    long getLong(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getLong: " + Translator.Accessed_null_value());
        }
        return Long.parseLong(this.values[n]);
    }

    @Override
    short getShort(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getShort: " + Translator.Accessed_null_value());
        }
        return Short.parseShort(this.values[n]);
    }

    @Override
    Timestamp getTimestamp(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getTimestamp: " + Translator.Accessed_null_value());
        }
        return Timestamp.valueOf(this.values[n]);
    }

    @Override
    Date getDate(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getDate: " + Translator.Accessed_null_value());
        }
        return Date.valueOf(this.values[n]);
    }

    @Override
    BigDecimal getBigDecimal(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getBigDecimal: " + Translator.Accessed_null_value());
        }
        return new BigDecimal(this.values[n]);
    }

    @Override
    void resize(int n) {
        int n2;
        String[] stringArray = new String[n];
        boolean[] blArray = new boolean[n];
        int n3 = this.values.length;
        if (n3 > n) {
            n3 = n;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = this.values[n2];
            blArray[n2] = this.validMask[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            blArray[n2] = false;
        }
        this.values = stringArray;
        this.validMask = blArray;
    }

    static Column from_jdbc_type(EXAInputStream eXAInputStream, EXAConnection eXAConnection, int n) throws IOException {
        byte by = eXAInputStream.readByte();
        int n2 = eXAInputStream.readInt();
        int n3 = eXAInputStream.readInt();
        switch (n) {
            case 17: {
                return new IntervalDayColumn(n2, n3);
            }
            case 16: {
                return new IntervalYearColumn(n2, n3);
            }
            case 126: {
                return new HashtypeColumn(n2, n3);
            }
        }
        if (1 == (by & 1)) {
            return new VarCharColumn(n2, n3);
        }
        return new CharColumn(n2, n3);
    }

    @Override
    void setBigDecimal(int n, BigDecimal bigDecimal) {
        this.setString(n, bigDecimal.toString());
    }

    @Override
    void setBoolean(int n, boolean bl) {
        this.setString(n, bl ? "TRUE" : "FALSE");
    }

    @Override
    void setByte(int n, byte by) {
        this.setString(n, String.valueOf(by));
    }

    @Override
    void setDate(int n, Date date) {
        this.setString(n, date.toString());
    }

    @Override
    void setDouble(int n, double d) {
        this.setString(n, String.valueOf(d));
    }

    @Override
    void setFloat(int n, float f) {
        this.setString(n, String.valueOf(f));
    }

    @Override
    void setInt(int n, int n2) {
        this.setString(n, String.valueOf(n2));
    }

    @Override
    void setLong(int n, long l) {
        this.setString(n, String.valueOf(l));
    }

    @Override
    void setObject(int n, Object object) {
        this.setString(n, object.toString());
    }

    @Override
    void setShort(int n, short s) {
        this.setString(n, String.valueOf(s));
    }

    @Override
    void setString(int n, String string) {
        this.validMask[n] = true;
        if (string.length() > this.maxWidth) {
            this.maxWidth = string.length();
        }
        this.values[n] = string;
    }

    @Override
    void setTime(int n, Time time) {
        this.setString(n, time.toString());
    }

    @Override
    void setTimestamp(int n, Timestamp timestamp) {
        this.setString(n, timestamp.toString());
    }

    @Override
    void setNull(int n) {
        this.validMask[n] = false;
        this.values[n] = null;
    }

    @Override
    void value_to_jdbc(EXAOutputStream eXAOutputStream, int n) throws SQLException, IOException {
        if (this.validMask[n]) {
            eXAOutputStream.writeByte((byte)1);
            String string = this.values[n];
            if (string.length() > this.maxWidth) {
                throw new SQLDataException(Translator.string_data_right_truncation() + ". StringLength " + string.length() + " > MaxLength " + this.maxWidth + ". The string starts with: " + string.substring(0, 200 >= string.length() ? string.length() - 1 : 200), new String("001"));
            }
            byte[] byArray = string.getBytes(eXAOutputStream.getEncoding());
            eXAOutputStream.writeInt(byArray.length);
            eXAOutputStream.write(byArray);
        } else {
            eXAOutputStream.writeByte((byte)0);
        }
    }

    @Override
    void value_from_jdbc(EXAInputStream eXAInputStream, int n) throws SQLException, IOException {
        if (eXAInputStream.nextIsNull()) {
            this.validMask[n] = false;
        } else {
            this.values[n] = eXAInputStream.readString();
            this.validMask[n] = true;
        }
    }

    @Override
    int getEXAType() {
        return 10;
    }
}

