/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import java.awt.geom.AffineTransform;
import java.util.List;
import org.apache.batik.anim.dom.AttributeInitializer;
import org.apache.batik.anim.dom.SVGLocatableSupport;
import org.apache.batik.anim.dom.SVGOMAnimatedBoolean;
import org.apache.batik.anim.dom.SVGOMAnimatedLength;
import org.apache.batik.anim.dom.SVGOMAnimatedPreserveAspectRatio;
import org.apache.batik.anim.dom.SVGOMAnimatedRect;
import org.apache.batik.anim.dom.SVGOMLength;
import org.apache.batik.anim.dom.SVGStylableElement;
import org.apache.batik.anim.dom.TraitInformation;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AbstractSVGMatrix;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMAngle;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.apache.batik.dom.svg.SVGOMRect;
import org.apache.batik.dom.svg.SVGOMTransform;
import org.apache.batik.dom.svg.SVGSVGContext;
import org.apache.batik.dom.svg.SVGTestsSupport;
import org.apache.batik.dom.svg.SVGZoomAndPanSupport;
import org.apache.batik.dom.util.ListNodeList;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.util.DoublyIndexedTable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.stylesheets.DocumentStyle;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.svg.SVGAngle;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGStringList;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGViewSpec;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class SVGOMSVGElement
extends SVGStylableElement
implements SVGSVGElement {
    protected static DoublyIndexedTable xmlTraitInformation;
    protected static final AttributeInitializer attributeInitializer;
    protected SVGOMAnimatedLength x;
    protected SVGOMAnimatedLength y;
    protected SVGOMAnimatedLength width;
    protected SVGOMAnimatedLength height;
    protected SVGOMAnimatedBoolean externalResourcesRequired;
    protected SVGOMAnimatedPreserveAspectRatio preserveAspectRatio;
    protected SVGOMAnimatedRect viewBox;

    protected SVGOMSVGElement() {
    }

    public SVGOMSVGElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
        this.initializeLiveAttributes();
    }

    @Override
    protected void initializeAllLiveAttributes() {
        super.initializeAllLiveAttributes();
        this.initializeLiveAttributes();
    }

    private void initializeLiveAttributes() {
        this.x = this.createLiveAnimatedLength(null, "x", "0", (short)2, false);
        this.y = this.createLiveAnimatedLength(null, "y", "0", (short)1, false);
        this.width = this.createLiveAnimatedLength(null, "width", "100%", (short)2, true);
        this.height = this.createLiveAnimatedLength(null, "height", "100%", (short)1, true);
        this.externalResourcesRequired = this.createLiveAnimatedBoolean(null, "externalResourcesRequired", false);
        this.preserveAspectRatio = this.createLiveAnimatedPreserveAspectRatio();
        this.viewBox = this.createLiveAnimatedRect(null, "viewBox", null);
    }

    @Override
    public String getLocalName() {
        return "svg";
    }

    @Override
    public SVGAnimatedLength getX() {
        return this.x;
    }

    @Override
    public SVGAnimatedLength getY() {
        return this.y;
    }

    @Override
    public SVGAnimatedLength getWidth() {
        return this.width;
    }

    @Override
    public SVGAnimatedLength getHeight() {
        return this.height;
    }

    @Override
    public String getContentScriptType() {
        return this.getAttributeNS(null, "contentScriptType");
    }

    @Override
    public void setContentScriptType(String string) {
        this.setAttributeNS(null, "contentScriptType", string);
    }

    @Override
    public String getContentStyleType() {
        return this.getAttributeNS(null, "contentStyleType");
    }

    @Override
    public void setContentStyleType(String string) {
        this.setAttributeNS(null, "contentStyleType", string);
    }

    @Override
    public SVGRect getViewport() {
        SVGContext sVGContext = this.getSVGContext();
        return new SVGOMRect(0.0f, 0.0f, sVGContext.getViewportWidth(), sVGContext.getViewportHeight());
    }

    @Override
    public float getPixelUnitToMillimeterX() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    @Override
    public float getPixelUnitToMillimeterY() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    @Override
    public float getScreenPixelToMillimeterX() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    @Override
    public float getScreenPixelToMillimeterY() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    @Override
    public boolean getUseCurrentView() {
        throw new UnsupportedOperationException("SVGSVGElement.getUseCurrentView is not implemented");
    }

    @Override
    public void setUseCurrentView(boolean bl) throws DOMException {
        throw new UnsupportedOperationException("SVGSVGElement.setUseCurrentView is not implemented");
    }

    @Override
    public SVGViewSpec getCurrentView() {
        throw new UnsupportedOperationException("SVGSVGElement.getCurrentView is not implemented");
    }

    @Override
    public float getCurrentScale() {
        AffineTransform affineTransform = this.getSVGContext().getScreenTransform();
        if (affineTransform != null) {
            return (float)Math.sqrt(affineTransform.getDeterminant());
        }
        return 1.0f;
    }

    @Override
    public void setCurrentScale(float f) throws DOMException {
        SVGContext sVGContext = this.getSVGContext();
        AffineTransform affineTransform = sVGContext.getScreenTransform();
        float f2 = 1.0f;
        if (affineTransform != null) {
            f2 = (float)Math.sqrt(affineTransform.getDeterminant());
        }
        float f3 = f / f2;
        affineTransform = new AffineTransform(affineTransform.getScaleX() * (double)f3, affineTransform.getShearY() * (double)f3, affineTransform.getShearX() * (double)f3, affineTransform.getScaleY() * (double)f3, affineTransform.getTranslateX(), affineTransform.getTranslateY());
        sVGContext.setScreenTransform(affineTransform);
    }

    @Override
    public SVGPoint getCurrentTranslate() {
        return new SVGPoint(){

            protected AffineTransform getScreenTransform() {
                SVGContext sVGContext = SVGOMSVGElement.this.getSVGContext();
                return sVGContext.getScreenTransform();
            }

            @Override
            public float getX() {
                AffineTransform affineTransform = this.getScreenTransform();
                return (float)affineTransform.getTranslateX();
            }

            @Override
            public float getY() {
                AffineTransform affineTransform = this.getScreenTransform();
                return (float)affineTransform.getTranslateY();
            }

            @Override
            public void setX(float f) {
                SVGContext sVGContext = SVGOMSVGElement.this.getSVGContext();
                AffineTransform affineTransform = sVGContext.getScreenTransform();
                affineTransform = new AffineTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), (double)f, affineTransform.getTranslateY());
                sVGContext.setScreenTransform(affineTransform);
            }

            @Override
            public void setY(float f) {
                SVGContext sVGContext = SVGOMSVGElement.this.getSVGContext();
                AffineTransform affineTransform = sVGContext.getScreenTransform();
                affineTransform = new AffineTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), (double)f);
                sVGContext.setScreenTransform(affineTransform);
            }

            @Override
            public SVGPoint matrixTransform(SVGMatrix sVGMatrix) {
                AffineTransform affineTransform = this.getScreenTransform();
                float f = (float)affineTransform.getTranslateX();
                float f2 = (float)affineTransform.getTranslateY();
                float f3 = sVGMatrix.getA() * f + sVGMatrix.getC() * f2 + sVGMatrix.getE();
                float f4 = sVGMatrix.getB() * f + sVGMatrix.getD() * f2 + sVGMatrix.getF();
                return new SVGOMPoint(f3, f4);
            }
        };
    }

    @Override
    public int suspendRedraw(int n) {
        if (n > 60000) {
            n = 60000;
        } else if (n < 0) {
            n = 0;
        }
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.suspendRedraw(n);
    }

    @Override
    public void unsuspendRedraw(int n) throws DOMException {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        if (!sVGSVGContext.unsuspendRedraw(n)) {
            throw this.createDOMException((short)8, "invalid.suspend.handle", new Object[]{new Integer(n)});
        }
    }

    @Override
    public void unsuspendRedrawAll() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.unsuspendRedrawAll();
    }

    @Override
    public void forceRedraw() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.forceRedraw();
    }

    @Override
    public void pauseAnimations() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.pauseAnimations();
    }

    @Override
    public void unpauseAnimations() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.unpauseAnimations();
    }

    @Override
    public boolean animationsPaused() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.animationsPaused();
    }

    @Override
    public float getCurrentTime() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.getCurrentTime();
    }

    @Override
    public void setCurrentTime(float f) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.setCurrentTime(f);
    }

    @Override
    public NodeList getIntersectionList(SVGRect sVGRect, SVGElement sVGElement) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        List list = sVGSVGContext.getIntersectionList(sVGRect, sVGElement);
        return new ListNodeList(list);
    }

    @Override
    public NodeList getEnclosureList(SVGRect sVGRect, SVGElement sVGElement) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        List list = sVGSVGContext.getEnclosureList(sVGRect, sVGElement);
        return new ListNodeList(list);
    }

    @Override
    public boolean checkIntersection(SVGElement sVGElement, SVGRect sVGRect) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.checkIntersection(sVGElement, sVGRect);
    }

    @Override
    public boolean checkEnclosure(SVGElement sVGElement, SVGRect sVGRect) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.checkEnclosure(sVGElement, sVGRect);
    }

    @Override
    public void deselectAll() {
        ((SVGSVGContext)this.getSVGContext()).deselectAll();
    }

    @Override
    public SVGNumber createSVGNumber() {
        return new SVGNumber(){
            protected float value;

            @Override
            public float getValue() {
                return this.value;
            }

            @Override
            public void setValue(float f) {
                this.value = f;
            }
        };
    }

    @Override
    public SVGLength createSVGLength() {
        return new SVGOMLength(this);
    }

    @Override
    public SVGAngle createSVGAngle() {
        return new SVGOMAngle();
    }

    @Override
    public SVGPoint createSVGPoint() {
        return new SVGOMPoint(0.0f, 0.0f);
    }

    @Override
    public SVGMatrix createSVGMatrix() {
        return new AbstractSVGMatrix(){
            protected AffineTransform at = new AffineTransform();

            @Override
            protected AffineTransform getAffineTransform() {
                return this.at;
            }
        };
    }

    @Override
    public SVGRect createSVGRect() {
        return new SVGOMRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public SVGTransform createSVGTransform() {
        SVGOMTransform sVGOMTransform = new SVGOMTransform();
        sVGOMTransform.setType((short)1);
        return sVGOMTransform;
    }

    @Override
    public SVGTransform createSVGTransformFromMatrix(SVGMatrix sVGMatrix) {
        SVGOMTransform sVGOMTransform = new SVGOMTransform();
        sVGOMTransform.setMatrix(sVGMatrix);
        return sVGOMTransform;
    }

    @Override
    public Element getElementById(String string) {
        return this.ownerDocument.getChildElementById(this, string);
    }

    @Override
    public SVGElement getNearestViewportElement() {
        return SVGLocatableSupport.getNearestViewportElement(this);
    }

    @Override
    public SVGElement getFarthestViewportElement() {
        return SVGLocatableSupport.getFarthestViewportElement(this);
    }

    @Override
    public SVGRect getBBox() {
        return SVGLocatableSupport.getBBox(this);
    }

    @Override
    public SVGMatrix getCTM() {
        return SVGLocatableSupport.getCTM(this);
    }

    @Override
    public SVGMatrix getScreenCTM() {
        return SVGLocatableSupport.getScreenCTM(this);
    }

    @Override
    public SVGMatrix getTransformToElement(SVGElement sVGElement) throws SVGException {
        return SVGLocatableSupport.getTransformToElement(this, sVGElement);
    }

    @Override
    public DocumentView getDocument() {
        return (DocumentView)((Object)this.getOwnerDocument());
    }

    @Override
    public CSSStyleDeclaration getComputedStyle(Element element, String string) {
        AbstractView abstractView = ((DocumentView)((Object)this.getOwnerDocument())).getDefaultView();
        return ((ViewCSS)abstractView).getComputedStyle(element, string);
    }

    @Override
    public Event createEvent(String string) throws DOMException {
        return ((DocumentEvent)((Object)this.getOwnerDocument())).createEvent(string);
    }

    @Override
    public boolean canDispatch(String string, String string2) throws DOMException {
        AbstractDocument abstractDocument = (AbstractDocument)this.getOwnerDocument();
        return abstractDocument.canDispatch(string, string2);
    }

    @Override
    public StyleSheetList getStyleSheets() {
        return ((DocumentStyle)((Object)this.getOwnerDocument())).getStyleSheets();
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(Element element, String string) {
        return ((DocumentCSS)((Object)this.getOwnerDocument())).getOverrideStyle(element, string);
    }

    @Override
    public String getXMLlang() {
        return XMLSupport.getXMLLang(this);
    }

    @Override
    public void setXMLlang(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", string);
    }

    @Override
    public String getXMLspace() {
        return XMLSupport.getXMLSpace(this);
    }

    @Override
    public void setXMLspace(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", string);
    }

    @Override
    public short getZoomAndPan() {
        return SVGZoomAndPanSupport.getZoomAndPan(this);
    }

    @Override
    public void setZoomAndPan(short s) {
        SVGZoomAndPanSupport.setZoomAndPan(this, s);
    }

    @Override
    public SVGAnimatedRect getViewBox() {
        return this.viewBox;
    }

    @Override
    public SVGAnimatedPreserveAspectRatio getPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    @Override
    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return this.externalResourcesRequired;
    }

    @Override
    public SVGStringList getRequiredFeatures() {
        return SVGTestsSupport.getRequiredFeatures(this);
    }

    @Override
    public SVGStringList getRequiredExtensions() {
        return SVGTestsSupport.getRequiredExtensions(this);
    }

    @Override
    public SVGStringList getSystemLanguage() {
        return SVGTestsSupport.getSystemLanguage(this);
    }

    @Override
    public boolean hasExtension(String string) {
        return SVGTestsSupport.hasExtension(this, string);
    }

    @Override
    protected AttributeInitializer getAttributeInitializer() {
        return attributeInitializer;
    }

    @Override
    protected Node newNode() {
        return new SVGOMSVGElement();
    }

    @Override
    protected DoublyIndexedTable getTraitInformationTable() {
        return xmlTraitInformation;
    }

    static {
        DoublyIndexedTable doublyIndexedTable = new DoublyIndexedTable(SVGStylableElement.xmlTraitInformation);
        doublyIndexedTable.put(null, "x", new TraitInformation(true, 3, 1));
        doublyIndexedTable.put(null, "y", new TraitInformation(true, 3, 2));
        doublyIndexedTable.put(null, "width", new TraitInformation(true, 3, 1));
        doublyIndexedTable.put(null, "height", new TraitInformation(true, 3, 2));
        doublyIndexedTable.put(null, "preserveAspectRatio", new TraitInformation(true, 32));
        doublyIndexedTable.put(null, "viewBox", new TraitInformation(true, 50));
        doublyIndexedTable.put(null, "externalResourcesRequired", new TraitInformation(true, 49));
        xmlTraitInformation = doublyIndexedTable;
        attributeInitializer = new AttributeInitializer(7);
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", null, "xmlns", "http://www.w3.org/2000/svg");
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns", "xlink", "http://www.w3.org/1999/xlink");
        attributeInitializer.addAttribute(null, null, "preserveAspectRatio", "xMidYMid meet");
        attributeInitializer.addAttribute(null, null, "zoomAndPan", "magnify");
        attributeInitializer.addAttribute(null, null, "version", "1.0");
        attributeInitializer.addAttribute(null, null, "contentScriptType", "text/ecmascript");
        attributeInitializer.addAttribute(null, null, "contentStyleType", "text/css");
    }
}

