/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import com.jidesoft.plaf.basic.BasicRangeSliderUI;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthRangeSliderUI
extends BasicRangeSliderUI
implements PropertyChangeListener,
SynthUI {
    protected Dimension contentDim = new Dimension();
    protected Rectangle valueRect = new Rectangle();
    protected boolean paintValue;
    private Dimension \u0108 = null;
    private int \u0106;
    private int \u0102;
    private int \u0107;
    private int \u0105;
    private SynthStyle \u0101;
    private SynthStyle \u0109;
    private SynthStyle \u0104;
    private static Rectangle \u0103 = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthRangeSliderUI((JSlider)jComponent);
    }

    public SynthRangeSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    @Override
    protected void installDefaults(JSlider jSlider) {
        this.\u0101(jSlider);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.slider, 1);
        this.\u0101.uninstallDefaults(synthContext);
        this.\u0102(synthContext);
        this.\u0101 = null;
        synthContext = this.\u0101(this.slider, Region.SLIDER_TRACK, 1);
        this.\u0109.uninstallDefaults(synthContext);
        this.\u0102(synthContext);
        this.\u0109 = null;
        synthContext = this.\u0101(this.slider, Region.SLIDER_THUMB, 1);
        this.\u0104.uninstallDefaults(synthContext);
        this.\u0102(synthContext);
        this.\u0104 = null;
    }

    @Override
    protected void installListeners(JSlider jSlider) {
        super.installListeners(jSlider);
        jSlider.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JSlider jSlider) {
        jSlider.removePropertyChangeListener(this);
        super.uninstallListeners(jSlider);
    }

    private SynthStyle \u0101(SynthContext synthContext, SynthUI synthUI) {
        try {
            Method method = SynthLookAndFeel.class.getDeclaredMethod("updateStyle", SynthContext.class, SynthUI.class);
            method.setAccessible(true);
            return (SynthStyle)method.invoke(null, synthContext, synthUI);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void \u0101(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        try {
            Method method = SynthLookAndFeel.class.getDeclaredMethod("updateSubregion", SynthContext.class, Graphics.class, Rectangle.class);
            method.setAccessible(true);
            method.invoke(null, synthContext, graphics, rectangle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private SynthPainter \u0101(SynthContext synthContext) {
        try {
            Method method = SynthContext.class.getDeclaredMethod("getPainter", new Class[0]);
            method.setAccessible(true);
            return (SynthPainter)method.invoke((Object)synthContext, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void \u0101(SynthContext synthContext, Graphics graphics) {
        try {
            Method method = SynthLookAndFeel.class.getDeclaredMethod("update", SynthContext.class, Graphics.class);
            method.setAccessible(true);
            method.invoke(null, synthContext, graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean \u0101(PropertyChangeEvent propertyChangeEvent) {
        try {
            Method method = SynthLookAndFeel.class.getDeclaredMethod("shouldUpdateStyle", PropertyChangeEvent.class);
            method.setAccessible(true);
            return (Boolean)method.invoke(null, propertyChangeEvent);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void \u0101(JSlider jSlider) {
        SynthContext synthContext = this.getContext((JComponent)jSlider, 1);
        SynthStyle synthStyle = this.\u0101;
        this.\u0101 = this.\u0101(synthContext, this);
        if (this.\u0101 != synthStyle) {
            this.\u0107 = this.\u0101.getInt(synthContext, "Slider.thumbWidth", 30);
            this.\u0105 = this.\u0101.getInt(synthContext, "Slider.thumbHeight", 14);
            String string = (String)this.slider.getClientProperty("JComponent.sizeVariant");
            if (string != null) {
                if ("large".equals(string)) {
                    this.\u0107 = (int)((double)this.\u0107 * 1.15);
                    this.\u0105 = (int)((double)this.\u0105 * 1.15);
                } else if ("small".equals(string)) {
                    this.\u0107 = (int)((double)this.\u0107 * 0.857);
                    this.\u0105 = (int)((double)this.\u0105 * 0.857);
                } else if ("mini".equals(string)) {
                    this.\u0107 = (int)((double)this.\u0107 * 0.784);
                    this.\u0105 = (int)((double)this.\u0105 * 0.784);
                }
            }
            this.\u0102 = this.\u0101.getInt(synthContext, "Slider.trackBorder", 1);
            this.\u0106 = this.\u0105 + this.\u0102 * 2;
            this.paintValue = this.\u0101.getBoolean(synthContext, "Slider.paintValue", true);
            if (synthStyle != null) {
                this.uninstallKeyboardActions(jSlider);
                this.installKeyboardActions(jSlider);
            }
        }
        this.\u0102(synthContext);
        synthContext = this.\u0101(jSlider, Region.SLIDER_TRACK, 1);
        this.\u0109 = this.\u0101(synthContext, this);
        this.\u0102(synthContext);
        synthContext = this.\u0101(jSlider, Region.SLIDER_THUMB, 1);
        this.\u0104 = this.\u0101(synthContext, this);
        this.\u0102(synthContext);
    }

    private void \u0102(SynthContext synthContext) {
        try {
            Method method = SynthContext.class.getDeclaredMethod("dispose", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)synthContext, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public int getBaseline(JComponent jComponent, int n2, int n3) {
        if (jComponent == null) {
            throw new NullPointerException("Component must be non-null");
        }
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Width and height must be >= 0");
        }
        if (this.slider.getPaintLabels() && this.labelsHaveSameBaselines()) {
            Integer n4;
            Insets insets = new Insets(0, 0, 0, 0);
            SynthContext synthContext = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
            this.\u0101.getInsets(synthContext, insets);
            synthContext.dispose();
            if (this.slider.getOrientation() == 0) {
                int n5 = 0;
                if (this.paintValue) {
                    SynthContext synthContext2 = this.getContext(this.slider);
                    n5 = synthContext2.getStyle().getGraphicsUtils(synthContext2).getMaximumCharHeight(synthContext2);
                    this.\u0102(synthContext2);
                }
                int n6 = 0;
                if (this.slider.getPaintTicks()) {
                    n6 = this.getTickLength();
                }
                int n7 = this.getHeightOfTallestLabel();
                int n8 = n5 + this.\u0106 + insets.top + insets.bottom + n6 + n7 + 4;
                int n9 = n3 / 2 - n8 / 2;
                n9 += n5 + 2;
                n9 += this.\u0106 + insets.top + insets.bottom;
                Component component = (Component)this.slider.getLabelTable().elements().nextElement();
                Dimension dimension = component.getPreferredSize();
                return (n9 += n6 + 2) + component.getBaseline(dimension.width, dimension.height);
            }
            Integer n10 = n4 = this.slider.getInverted() ? this.getLowestValue() : this.getHighestValue();
            if (n4 != null) {
                int n11 = this.insetCache.top;
                int n12 = 0;
                if (this.paintValue) {
                    SynthContext synthContext3 = this.getContext(this.slider);
                    n12 = synthContext3.getStyle().getGraphicsUtils(synthContext3).getMaximumCharHeight(synthContext3);
                    this.\u0102(synthContext3);
                }
                int n13 = n3 - this.insetCache.top - this.insetCache.bottom;
                int n14 = n11 + n12;
                int n15 = n13 - n12;
                int n16 = this.yPositionForValue(n4, n14, n15);
                Component component = (Component)this.slider.getLabelTable().get(n4);
                Dimension dimension = component.getPreferredSize();
                return n16 - dimension.height / 2 + component.getBaseline(dimension.width, dimension.height);
            }
        }
        return -1;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        Dimension dimension = new Dimension(this.contentDim);
        if (this.slider.getOrientation() == 1) {
            dimension.height = 200;
        } else {
            dimension.width = 200;
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        Dimension dimension = new Dimension(this.contentDim);
        if (this.slider.getOrientation() == 1) {
            dimension.height = this.thumbRect.height + this.insetCache.top + this.insetCache.bottom;
        } else {
            dimension.width = this.thumbRect.width + this.insetCache.left + this.insetCache.right;
        }
        return dimension;
    }

    @Override
    protected void calculateGeometry() {
        this.layout();
        this.calculateThumbLocation();
    }

    protected void layout() {
        SynthContext synthContext = this.getContext(this.slider);
        SynthGraphicsUtils synthGraphicsUtils = this.\u0101.getGraphicsUtils(synthContext);
        Dimension dimension = this.getThumbSize();
        this.thumbRect.setSize(dimension.width, dimension.height);
        Insets insets = new Insets(0, 0, 0, 0);
        SynthContext synthContext2 = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
        this.\u0101.getInsets(synthContext2, insets);
        this.\u0102(synthContext2);
        if (this.slider.getOrientation() == 0) {
            int n2;
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphicsUtils.getMaximumCharHeight(synthContext);
            }
            this.trackRect.height = this.\u0106;
            this.tickRect.height = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.height = this.getTickLength();
            }
            this.labelRect.height = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.height = this.getHeightOfTallestLabel();
            }
            this.contentDim.height = this.valueRect.height + this.trackRect.height + insets.top + insets.bottom + this.tickRect.height + this.labelRect.height + 4;
            this.contentDim.width = this.slider.getWidth() - this.insetCache.left - this.insetCache.right;
            int n3 = 0;
            if (this.slider.getPaintLabels()) {
                this.trackRect.x = this.insetCache.left;
                this.trackRect.width = this.contentDim.width;
                Dictionary dictionary = this.slider.getLabelTable();
                if (dictionary != null) {
                    int n4 = this.slider.getMinimum();
                    int n5 = this.slider.getMaximum();
                    int n6 = Integer.MAX_VALUE;
                    int n7 = Integer.MIN_VALUE;
                    Enumeration enumeration = dictionary.keys();
                    while (enumeration.hasMoreElements()) {
                        int n8 = (Integer)enumeration.nextElement();
                        if (n8 >= n4 && n8 < n6) {
                            n6 = n8;
                        }
                        if (n8 > n5 || n8 <= n7) continue;
                        n7 = n8;
                    }
                    n3 = this.\u0101(n6);
                    n3 = Math.max(n3, this.\u0101(n7));
                }
            }
            this.tickRect.x = this.labelRect.x = this.insetCache.left + n3;
            this.trackRect.x = this.labelRect.x;
            this.valueRect.x = this.labelRect.x;
            this.tickRect.width = this.labelRect.width = this.contentDim.width - n3 * 2;
            this.trackRect.width = this.labelRect.width;
            this.valueRect.width = this.labelRect.width;
            this.valueRect.y = n2 = this.slider.getHeight() / 2 - this.contentDim.height / 2;
            this.trackRect.y = (n2 += this.valueRect.height + 2) + insets.top;
            this.tickRect.y = n2 += this.trackRect.height + insets.top + insets.bottom;
            this.labelRect.y = n2 += this.tickRect.height + 2;
            n2 += this.labelRect.height;
        } else {
            this.trackRect.width = this.\u0106;
            this.tickRect.width = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.width = this.getTickLength();
            }
            this.labelRect.width = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.width = this.getWidthOfWidestLabel();
            }
            this.valueRect.y = this.insetCache.top;
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphicsUtils.getMaximumCharHeight(synthContext);
            }
            FontMetrics fontMetrics = this.slider.getFontMetrics(this.slider.getFont());
            this.valueRect.width = Math.max(synthGraphicsUtils.computeStringWidth(synthContext, this.slider.getFont(), fontMetrics, "" + this.slider.getMaximum()), synthGraphicsUtils.computeStringWidth(synthContext, this.slider.getFont(), fontMetrics, "" + this.slider.getMinimum()));
            int n9 = this.valueRect.width / 2;
            int n10 = insets.left + this.trackRect.width / 2;
            int n11 = this.trackRect.width / 2 + insets.right + this.tickRect.width + this.labelRect.width;
            this.contentDim.width = Math.max(n10, n9) + Math.max(n11, n9) + 2 + this.insetCache.left + this.insetCache.right;
            this.contentDim.height = this.slider.getHeight() - this.insetCache.top - this.insetCache.bottom;
            this.tickRect.y = this.labelRect.y = this.valueRect.y + this.valueRect.height;
            this.trackRect.y = this.labelRect.y;
            this.tickRect.height = this.labelRect.height = this.contentDim.height - this.valueRect.height;
            this.trackRect.height = this.labelRect.height;
            int n12 = this.slider.getWidth() / 2 - this.contentDim.width / 2;
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                if (n9 > n10) {
                    n12 += n9 - n10;
                }
                this.trackRect.x = n12 + insets.left;
                this.tickRect.x = n12 += insets.left + this.trackRect.width + insets.right;
                this.labelRect.x = n12 + this.tickRect.width + 2;
            } else {
                if (n9 > n11) {
                    n12 += n9 - n11;
                }
                this.labelRect.x = n12;
                this.tickRect.x = n12 += this.labelRect.width + 2;
                this.trackRect.x = n12 + this.tickRect.width + insets.left;
            }
        }
        this.\u0102(synthContext);
        this.\u0108 = this.slider.getSize();
    }

    private int \u0101(int n2) {
        Dictionary dictionary = this.slider.getLabelTable();
        int n3 = 0;
        Object v2 = dictionary.get(n2);
        if (v2 != null) {
            int n4;
            Component component = (Component)v2;
            int n5 = this.xPositionForValue(n2);
            if (n5 - (n4 = component.getPreferredSize().width / 2) < this.insetCache.left) {
                n3 = Math.max(n3, this.insetCache.left - (n5 - n4));
            }
            if (n5 + n4 > this.slider.getWidth() - this.insetCache.right) {
                n3 = Math.max(n3, n5 + n4 - (this.slider.getWidth() - this.insetCache.right));
            }
        }
        return n3;
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.slider.getOrientation() == 0) {
            int n2 = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = n2 - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y + this.\u0102;
        } else {
            int n3 = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x + this.\u0102;
            this.thumbRect.y = n3 - this.thumbRect.height / 2;
        }
    }

    @Override
    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height + 2 + this.getTickLength();
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            if (SynthLookAndFeel.isLeftToRight(this.slider)) {
                this.tickRect.x = this.trackRect.x + this.trackRect.width;
                this.tickRect.width = this.getTickLength();
            } else {
                this.tickRect.width = this.getTickLength();
                this.tickRect.x = this.trackRect.x - this.tickRect.width;
            }
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    @Override
    protected int xPositionForValue(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.x + this.thumbRect.width / 2 + this.\u0102;
        int n7 = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - this.\u0102;
        int n8 = n7 - n6;
        double d2 = (double)n5 - (double)n4;
        double d3 = (double)n8 / d2;
        if (!this.drawInverted()) {
            n3 = n6;
            n3 = (int)((long)n3 + Math.round(d3 * ((double)n2 - (double)n4)));
        } else {
            n3 = n7;
            n3 = (int)((long)n3 - Math.round(d3 * ((double)n2 - (double)n4)));
        }
        n3 = Math.max(n6, n3);
        n3 = Math.min(n7, n3);
        return n3;
    }

    @Override
    protected int yPositionForValue(int n2, int n3, int n4) {
        int n5;
        int n6 = this.slider.getMinimum();
        int n7 = this.slider.getMaximum();
        int n8 = n3 + this.thumbRect.height / 2 + this.\u0102;
        int n9 = n3 + n4 - this.thumbRect.height / 2 - this.\u0102;
        int n10 = n9 - n8;
        double d2 = (double)n7 - (double)n6;
        double d3 = (double)n10 / d2;
        if (!this.drawInverted()) {
            n5 = n8;
            n5 = (int)((long)n5 + Math.round(d3 * ((double)n7 - (double)n2)));
        } else {
            n5 = n8;
            n5 = (int)((long)n5 + Math.round(d3 * ((double)n2 - (double)n6)));
        }
        n5 = Math.max(n8, n5);
        n5 = Math.min(n9, n5);
        return n5;
    }

    @Override
    public int valueForYPosition(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.y + this.thumbRect.height / 2 + this.\u0102;
        int n7 = this.trackRect.y + this.trackRect.height - this.thumbRect.height / 2 - this.\u0102;
        int n8 = n7 - n6;
        if (n2 <= n6) {
            n3 = this.drawInverted() ? n4 : n5;
        } else if (n2 >= n7) {
            n3 = this.drawInverted() ? n5 : n4;
        } else {
            int n9 = n2 - n6;
            double d2 = (double)n5 - (double)n4;
            double d3 = d2 / (double)n8;
            int n10 = (int)Math.round((double)n9 * d3);
            n3 = this.drawInverted() ? n4 + n10 : n5 - n10;
        }
        return n3;
    }

    @Override
    public int valueForXPosition(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.x + this.thumbRect.width / 2 + this.\u0102;
        int n7 = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - this.\u0102;
        int n8 = n7 - n6;
        if (n2 <= n6) {
            n3 = this.drawInverted() ? n5 : n4;
        } else if (n2 >= n7) {
            n3 = this.drawInverted() ? n4 : n5;
        } else {
            int n9 = n2 - n6;
            double d2 = (double)n5 - (double)n4;
            double d3 = d2 / (double)n8;
            int n10 = (int)Math.round((double)n9 * d3);
            n3 = this.drawInverted() ? n5 - n10 : n4 + n10;
        }
        return n3;
    }

    @Override
    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = this.\u0105;
            dimension.height = this.\u0107;
        } else {
            dimension.width = this.\u0107;
            dimension.height = this.\u0105;
        }
        return dimension;
    }

    @Override
    protected void recalculateIfInsetsChanged() {
        SynthContext synthContext = this.getContext(this.slider);
        Insets insets = this.\u0101.getInsets(synthContext, null);
        if (!insets.equals(this.insetCache)) {
            this.insetCache = insets;
            this.calculateGeometry();
        }
        this.\u0102(synthContext);
    }

    public Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, int n2) {
        return this.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.\u0101, n2);
    }

    public SynthContext getContext(Class clazz, JComponent jComponent, Region region, SynthStyle synthStyle, int n2) {
        try {
            Method method = SynthContext.class.getDeclaredMethod("getContext", Class.class, JComponent.class, Region.class, SynthStyle.class, Integer.TYPE);
            method.setAccessible(true);
            return (SynthContext)method.invoke(null, clazz, jComponent, region, synthStyle, n2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public SynthContext getContext(JComponent jComponent, Region region) {
        return this.\u0101(jComponent, region, this.\u0101(jComponent, region));
    }

    private SynthContext \u0101(JComponent jComponent, Region region, int n2) {
        SynthStyle synthStyle = null;
        Class<SynthContext> clazz = SynthContext.class;
        if (region == Region.SLIDER_TRACK) {
            synthStyle = this.\u0109;
        } else if (region == Region.SLIDER_THUMB) {
            synthStyle = this.\u0104;
        }
        return this.getContext(clazz, jComponent, region, synthStyle, n2);
    }

    public int getComponentState(JComponent jComponent) {
        try {
            Method method = SynthLookAndFeel.class.getDeclaredMethod("getComponentState", Component.class);
            method.setAccessible(true);
            return (Integer)method.invoke(null, jComponent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    private int \u0101(JComponent jComponent, Region region) {
        if (region == Region.SLIDER_THUMB && (this.second ? this.rollover2 : this.rollover1) && jComponent.isEnabled()) {
            int n2;
            int n3 = (this.second ? this.pressed2 : this.pressed1) ? 4 : (n2 = 2);
            if (jComponent.isFocusOwner()) {
                n2 |= 0x100;
            }
            return n2;
        }
        return this.getComponentState(jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.\u0101(synthContext, graphics);
        this.\u0101(synthContext).paintSliderBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), this.slider.getOrientation());
        this.paint(synthContext, graphics);
        this.\u0102(synthContext);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        this.\u0102(synthContext);
    }

    public void paint(SynthContext synthContext, Graphics graphics) {
        Object object;
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle rectangle = graphics.getClipBounds();
        if (this.\u0108 == null || !this.\u0108.equals(this.slider.getSize())) {
            this.calculateGeometry();
        }
        if (this.paintValue) {
            object = JideSwingUtilities.getFontMetrics(this.slider, graphics);
            int n2 = synthContext.getStyle().getGraphicsUtils(synthContext).computeStringWidth(synthContext, graphics.getFont(), (FontMetrics)object, "" + this.slider.getValue());
            this.valueRect.x = this.thumbRect.x + (this.thumbRect.width - n2) / 2;
            if (this.slider.getOrientation() == 0) {
                if (this.valueRect.x + n2 > this.contentDim.width) {
                    this.valueRect.x = this.contentDim.width - n2;
                }
                this.valueRect.x = Math.max(this.valueRect.x, 0);
            }
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
            synthContext.getStyle().getGraphicsUtils(synthContext).paintText(synthContext, graphics, "" + this.slider.getValue(), this.valueRect.x, this.valueRect.y, -1);
        }
        if (this.slider.getPaintTrack() && rectangle.intersects(this.trackRect)) {
            object = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
            this.paintTrack((SynthContext)object, graphics, this.trackRect);
            this.\u0102((SynthContext)object);
        }
        this.second = false;
        if (rectangle.intersects(this.thumbRect)) {
            object = this.getContext((JComponent)this.slider, Region.SLIDER_THUMB);
            this.paintThumb((SynthContext)object, graphics, this.thumbRect);
            this.\u0102((SynthContext)object);
        }
        this.second = true;
        object = this.adjustThumbForHighValue();
        if (rectangle.intersects(this.thumbRect)) {
            SynthContext synthContext2 = this.getContext((JComponent)this.slider, Region.SLIDER_THUMB);
            this.paintThumb(synthContext2, graphics, this.thumbRect);
            this.\u0102(synthContext2);
        }
        this.second = false;
        this.restoreThumbForLowValue((Point)object);
        if (this.slider.getPaintTicks() && rectangle.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.\u0101(synthContext).paintSliderBorder(synthContext, graphics, n2, n3, n4, n5, this.slider.getOrientation());
    }

    public void paintThumb(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        int n2 = this.slider.getOrientation();
        this.\u0101(synthContext, graphics, rectangle);
        this.\u0101(synthContext).paintSliderThumbBackground(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2);
        this.\u0101(synthContext).paintSliderThumbBorder(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2);
    }

    public void paintTrack(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        int n2 = this.slider.getOrientation();
        this.\u0101(synthContext, graphics, rectangle);
        this.\u0101(synthContext).paintSliderTrackBackground(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2);
        this.\u0101(synthContext).paintSliderTrackBorder(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.\u0101(propertyChangeEvent)) {
            this.\u0101((JSlider)propertyChangeEvent.getSource());
        }
    }
}

