/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.tuple;

import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.tuple.TableTuple;
import com.jidesoft.thirdparty.prefuse.util.StringLib;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;
import java.util.Iterator;
import java.util.logging.Logger;

public class TupleManager {
    protected Table m_table;
    protected Class m_tupleType;
    private TableTuple[] \u0101;

    public TupleManager(Table table, Class clazz) {
        this.init(table, clazz);
    }

    public void init(Table table, Class clazz) {
        if (this.m_table != null) {
            throw new IllegalStateException("This TupleManager has already been initialized");
        }
        this.m_table = table;
        this.m_tupleType = clazz;
        this.\u0101 = null;
    }

    public Class getTupleType() {
        return this.m_tupleType;
    }

    private void \u0101() {
        int n2 = this.m_table.getRowCount();
        if (this.\u0101 == null) {
            this.\u0101 = new TableTuple[n2];
        } else if (this.\u0101.length < n2) {
            int n3 = Math.max(3 * this.\u0101.length / 2 + 1, n2);
            TableTuple[] tableTupleArray = new TableTuple[n3];
            System.arraycopy(this.\u0101, 0, tableTupleArray, 0, this.\u0101.length);
            this.\u0101 = tableTupleArray;
        }
    }

    public Tuple getTuple(int n2) {
        if (this.m_table.isValidRow(n2)) {
            this.\u0101();
            if (this.\u0101[n2] == null) {
                this.\u0101[n2] = this.newTuple(n2);
                return this.\u0101[n2];
            }
            return this.\u0101[n2];
        }
        throw new IllegalArgumentException("Invalid row index: " + n2);
    }

    protected TableTuple newTuple(int n2) {
        try {
            TableTuple tableTuple = (TableTuple)this.m_tupleType.newInstance();
            tableTuple.init(this.m_table, n2);
            return tableTuple;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).warning(exception.getMessage() + "\n" + StringLib.getStackTrace(exception));
            return null;
        }
    }

    public void invalidate(int n2) {
        if (this.\u0101 == null || n2 < 0 || n2 > this.\u0101.length) {
            return;
        }
        if (this.\u0101[n2] != null) {
            this.\u0101[n2].\u0101();
            this.\u0101[n2] = null;
        }
    }

    public void invalidateAll() {
        if (this.\u0101 == null) {
            return;
        }
        for (int i2 = 0; i2 < this.\u0101.length; ++i2) {
            this.invalidate(i2);
        }
    }

    public Iterator iterator(IntIterator intIterator) {
        return new TupleManagerIterator(this, intIterator);
    }

    public class TupleManagerIterator
    implements Iterator {
        private TupleManager \u0102;
        private IntIterator \u0103;

        public TupleManagerIterator(TupleManager tupleManager2, IntIterator intIterator) {
            this.\u0102 = tupleManager2;
            this.\u0103 = intIterator;
        }

        @Override
        public boolean hasNext() {
            return this.\u0103.hasNext();
        }

        public Object next() {
            return this.\u0102.getTuple(this.\u0103.nextInt());
        }

        @Override
        public void remove() {
            this.\u0103.remove();
        }
    }
}

