/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.expression;

import com.jidesoft.thirdparty.prefuse.data.expression.AbstractExpression;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.ExpressionVisitor;

public abstract class BinaryExpression
extends AbstractExpression {
    protected int m_op;
    protected Expression m_left;
    protected Expression m_right;

    protected BinaryExpression(int n2, int n3, int n4, Expression expression, Expression expression2) {
        if (n2 < n3 || n2 > n4) {
            throw new IllegalArgumentException("Unknown operation type: " + n2);
        }
        if (expression == null || expression2 == null) {
            throw new IllegalArgumentException("Expressions must be non-null.");
        }
        this.m_op = n2;
        this.m_left = expression;
        this.m_right = expression2;
    }

    public Expression getLeftExpression() {
        return this.m_left;
    }

    public Expression getRightExpression() {
        return this.m_right;
    }

    public void setLeftExpression(Expression expression) {
        this.m_left.removeExpressionListener(this);
        this.m_left = expression;
        if (this.hasListeners()) {
            expression.addExpressionListener(this);
        }
        this.fireExpressionChange();
    }

    public void setRightExpression(Expression expression) {
        this.m_right.removeExpressionListener(this);
        this.m_right = expression;
        if (this.hasListeners()) {
            expression.addExpressionListener(this);
        }
        this.fireExpressionChange();
    }

    public int getOperation() {
        return this.m_op;
    }

    @Override
    public void visit(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visitExpression(this);
        expressionVisitor.down();
        this.m_left.visit(expressionVisitor);
        expressionVisitor.up();
        expressionVisitor.down();
        this.m_right.visit(expressionVisitor);
        expressionVisitor.up();
    }

    @Override
    protected void addChildListeners() {
        this.m_left.addExpressionListener(this);
        this.m_right.addExpressionListener(this);
    }

    @Override
    protected void removeChildListeners() {
        this.m_left.removeExpressionListener(this);
        this.m_right.removeExpressionListener(this);
    }
}

