/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.G;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.event.SearchableEvent;
import com.jidesoft.swing.event.SearchableListener;
import com.jidesoft.utils.DefaultWildcardSupport;
import com.jidesoft.utils.WildcardSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class Searchable {
    private final PropertyChangeSupport \u0109 = new PropertyChangeSupport(this);
    protected final JComponent _component;
    private SearchPopup \u0116;
    private JLayeredPane \u0118;
    private boolean \u011c;
    private SearchableProvider \u010b;
    private Pattern \u0113;
    private String \u010c;
    private String \u011b;
    private boolean \u011d = true;
    private boolean \u0106 = false;
    private boolean \u010d = false;
    private boolean \u0104 = true;
    private boolean \u0112;
    protected int _matchCount;
    private WildcardSupport \u0117 = null;
    private Color \u010e;
    private Color \u0105 = null;
    private Color \u0107 = null;
    protected ComponentListener _componentListener;
    protected KeyListener _keyListener;
    protected FocusListener _focusListener;
    private SearchableListener \u0119;
    public static final String PROPERTY_SEARCH_TEXT = "searchText";
    private int \u010f = -1;
    private String \u0103 = null;
    private int \u0110 = 1;
    private int \u011a = 0;
    private int \u0102 = 0;
    private Timer \u0108;
    private boolean \u0111 = false;
    protected EventListenerList listenerList = new EventListenerList();
    private Component \u0114;
    public static final String CLIENT_PROPERTY_SEARCHABLE = "Searchable";
    private Set<Integer> \u0101;
    private boolean \u010a = true;
    private boolean \u0115 = true;

    public Searchable(JComponent jComponent) {
        Searchable searchable = Searchable.getSearchable(jComponent);
        if (searchable != null) {
            SearchableUtils.uninstallSearchable(searchable);
        }
        this.\u011b = null;
        this._component = jComponent;
        this.\u0101 = new HashSet<Integer>();
        this.installListeners();
        this.\u0101(this._component, this);
    }

    public Searchable(JComponent jComponent, SearchableProvider searchableProvider) {
        Searchable searchable = Searchable.getSearchable(jComponent);
        if (searchable != null) {
            SearchableUtils.uninstallSearchable(searchable);
        }
        this.\u010b = searchableProvider;
        this.\u011b = null;
        this._component = jComponent;
        this.\u0101 = new HashSet<Integer>();
        this.installListeners();
        this.\u0101(this._component, this);
    }

    protected abstract int getSelectedIndex();

    protected abstract void setSelectedIndex(int var1, boolean var2);

    public void adjustSelectedIndex(int n2, boolean bl) {
        this.setSelectedIndex(n2, bl);
    }

    protected abstract int getElementCount();

    protected abstract Object getElementAt(int var1);

    protected abstract String convertElementToString(Object var1);

    public String convertToString(Object object) {
        return this.convertElementToString(object);
    }

    public boolean isHideSearchPopupOnEvent() {
        return this.\u0115;
    }

    public void setHideSearchPopupOnEvent(boolean bl) {
        this.\u0115 = bl;
    }

    public void hidePopup() {
        if (this.\u0116 != null) {
            if (this.isHeavyweightComponentEnabled()) {
                this.\u0116.hidePopupImmediately();
            } else if (this.\u0118 != null) {
                this.\u0118.remove(this.\u0116);
                this.\u0118.validate();
                this.\u0118.repaint();
                this.\u0118 = null;
            }
            this.\u0116 = null;
            this.\u010b = null;
            this.\u011b = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3000, "", this.getCurrentIndex(), this.\u011b));
        }
        this.setCursor(-1);
    }

    public SearchableProvider getSearchableProvider() {
        return this.\u010b;
    }

    public void setSearchableProvider(SearchableProvider searchableProvider) {
        this.\u010b = searchableProvider;
    }

    public void installListeners() {
        if (this._componentListener == null) {
            this._componentListener = this.createComponentListener();
        }
        this._component.addComponentListener(this._componentListener);
        Component component = JideSwingUtilities.getScrollPane(this._component);
        if (component != null) {
            component.addComponentListener(this._componentListener);
        }
        if (this._keyListener == null) {
            this._keyListener = this.createKeyListener();
        }
        JideSwingUtilities.insertKeyListener(this.getComponent(), this._keyListener, 0);
        if (this._focusListener == null) {
            this._focusListener = this.createFocusListener();
        }
        this.getComponent().addFocusListener(this._focusListener);
        if (this.\u0119 == null) {
            this.\u0119 = new SearchableListener(){

                @Override
                public void searchableEventFired(SearchableEvent searchableEvent) {
                    if (searchableEvent.getID() == 2999) {
                        if (Searchable.this.getPopupTimeout() > 0) {
                            Searchable.this.\u0108 = new Timer(Searchable.this.getPopupTimeout(), new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    if (Searchable.this.isPopupVisible()) {
                                        Searchable.this.hidePopup();
                                    }
                                }
                            });
                            Searchable.this.\u0108.setRepeats(false);
                            Searchable.this.\u0108.start();
                        }
                    } else if (Searchable.this.\u0108 != null) {
                        if (searchableEvent.getID() == 3000) {
                            Searchable.this.\u0108.stop();
                        } else {
                            Searchable.this.\u0108.restart();
                        }
                    }
                }
            };
        }
        this.addSearchableListener(this.\u0119);
    }

    protected ComponentListener createComponentListener() {
        return new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                boolean bl;
                super.componentHidden(componentEvent);
                boolean bl2 = bl = Searchable.this.\u010b == null || Searchable.this.\u010b.isPassive();
                if (bl) {
                    Searchable.this.hidePopup();
                }
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                boolean bl;
                super.componentResized(componentEvent);
                boolean bl2 = bl = Searchable.this.\u010b == null || Searchable.this.\u010b.isPassive();
                if (bl) {
                    Searchable.this.\u0101();
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                boolean bl;
                super.componentMoved(componentEvent);
                boolean bl2 = bl = Searchable.this.\u010b == null || Searchable.this.\u010b.isPassive();
                if (bl) {
                    Searchable.this.\u0101();
                }
            }
        };
    }

    protected KeyListener createKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                boolean bl;
                boolean bl2 = bl = Searchable.this.\u010b == null || Searchable.this.\u010b.isPassive();
                if (bl) {
                    Searchable.this.keyTypedOrPressed(keyEvent);
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                boolean bl;
                boolean bl2 = bl = Searchable.this.\u010b == null || Searchable.this.\u010b.isPassive();
                if (bl) {
                    Searchable.this.keyTypedOrPressed(keyEvent);
                }
            }
        };
    }

    protected FocusListener createFocusListener() {
        return new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                boolean bl2 = bl = Searchable.this.\u010b == null || Searchable.this.\u010b.isPassive();
                if (bl) {
                    Searchable.this.hidePopup();
                }
            }
        };
    }

    public void uninstallListeners() {
        if (this._componentListener != null) {
            this.getComponent().removeComponentListener(this._componentListener);
            Component component = JideSwingUtilities.getScrollPane(this.getComponent());
            if (component != null) {
                component.removeComponentListener(this._componentListener);
            }
            this._componentListener = null;
        }
        if (this._keyListener != null) {
            this.getComponent().removeKeyListener(this._keyListener);
            this._keyListener = null;
        }
        if (this._focusListener != null) {
            this.getComponent().removeFocusListener(this._focusListener);
            this._focusListener = null;
        }
        if (this.\u0119 != null) {
            this.removeSearchableListener(this.\u0119);
            this.\u0119 = null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0109.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0109.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChangeEvent(String string) {
        if (!string.equals(this.\u011b)) {
            this.\u0109.firePropertyChange(PROPERTY_SEARCH_TEXT, this.\u011b, string);
            this.fireSearchableEvent(new SearchableEvent(this, 3004, string, this.getCurrentIndex(), this.\u011b));
            this.\u011b = string;
            if (string.length() == 0) {
                this.searchingTextEmpty();
            }
        }
    }

    protected void searchingTextEmpty() {
    }

    protected boolean compare(Object object, String string) {
        String string2 = this.convertElementToString(object);
        return string2 != null && this.compare(this.isCaseSensitive() ? string2 : string2.toLowerCase(), string);
    }

    protected boolean compare(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return true;
        }
        if (!this.isWildcardEnabled()) {
            return string2 != null && (string2.equals(string) || string2.length() > 0 && (this.isFromStart() ? string.startsWith(string2) : string.indexOf(string2) != -1));
        }
        if (this.\u010c != null && this.\u010c.equals(string2) && this.\u0113 != null) {
            return this.\u0113.matcher(string).find();
        }
        WildcardSupport wildcardSupport = this.getWildcardSupport();
        String string3 = wildcardSupport.convert(string2);
        if (string2.equals(string3)) {
            return this.isFromStart() ? string.startsWith(string2) : string.indexOf(string2) != -1;
        }
        this.\u010c = string2;
        try {
            this.\u0113 = Pattern.compile(this.isFromStart() ? "^" + string3 : string3, this.isCaseSensitive() ? 0 : 2);
            return this.\u0113.matcher(string).find();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public int getCursor() {
        return this.\u010f;
    }

    public void setCursor(int n2) {
        this.setCursor(n2, false);
    }

    public void setCursor(int n2, boolean bl) {
        if (!bl || this.\u010f < 0) {
            this.\u0101.clear();
        }
        if (this.\u010f >= 0) {
            this.\u0101.add(n2);
        }
        this.\u010f = n2;
    }

    protected void highlightAll() {
        int n2 = -1;
        int n3 = this.getSelectedIndex();
        String string = this.getSearchingText();
        while (n3 != -1) {
            int n4 = this.findNext(string);
            if ((n3 = n3 == n4 ? -1 : n4) == -1) continue;
            if (n2 == -1) {
                n2 = n3;
            }
            this.select(n3, string);
        }
        if (n2 != -1) {
            this.select(n2, string);
        }
    }

    protected void cancelHighlightAll() {
    }

    protected void select(int n2, String string) {
        if (n2 != -1) {
            this.setSelectedIndex(n2, true);
            this.setCursor(n2, true);
            Object object = this.getElementAt(n2);
            this.fireSearchableEvent(new SearchableEvent(this, 3002, string, object, this.convertElementToString(object)));
        } else {
            this.setSelectedIndex(-1, false);
            this.fireSearchableEvent(new SearchableEvent(this, 3003, string));
        }
    }

    public int findNext(String string) {
        Object object;
        int n2;
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n3 = this.getElementCount();
        if (n3 == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        int n4 = this.getCurrentIndex();
        for (n2 = n4 + 1; n2 < n3; ++n2) {
            object = this.getElementAt(n2);
            if (!this.compare(object, string2)) continue;
            return n2;
        }
        if (this.isRepeats()) {
            for (n2 = 0; n2 < n4; ++n2) {
                object = this.getElementAt(n2);
                if (!this.compare(object, string2)) continue;
                return n2;
            }
        }
        return n4 == -1 ? -1 : (this.compare(this.getElementAt(n4), string2) ? n4 : -1);
    }

    protected int getCurrentIndex() {
        if (this.\u0101.contains(this.getSelectedIndex())) {
            return this.\u010f != -1 ? this.\u010f : this.getSelectedIndex();
        }
        this.\u0101.clear();
        return this.getSelectedIndex();
    }

    public int findPrevious(String string) {
        Object object;
        int n2;
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n3 = this.getElementCount();
        if (n3 == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        int n4 = this.getCurrentIndex();
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            object = this.getElementAt(n2);
            if (!this.compare(object, string2)) continue;
            return n2;
        }
        if (this.isRepeats()) {
            for (n2 = n3 - 1; n2 >= n4; --n2) {
                object = this.getElementAt(n2);
                if (!this.compare(object, string2)) continue;
                return n2;
            }
        }
        return n4 == -1 ? -1 : (this.compare(this.getElementAt(n4), string2) ? n4 : -1);
    }

    public int findFromCursor(String string) {
        Object object;
        int n2;
        int n3;
        int n4;
        if (this.isCountMatch()) {
            boolean bl = this.isReverseOrder();
            this.setReverseOrder(false);
            n4 = this.getCurrentIndex();
            if (n4 < 0) {
                n4 = 0;
            }
            n3 = -1;
            this._matchCount = -1;
            do {
                this.setSelectedIndex(n3, false);
                n2 = n3;
                n3 = this.findNext(string);
                ++this._matchCount;
            } while (n3 > n2);
            this.setSelectedIndex(n4, false);
            this.setReverseOrder(bl);
        }
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(string);
        }
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        n4 = this.getCurrentIndex();
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n2 = this.getElementCount()) == 0) {
            return -1;
        }
        for (n3 = n4; n3 < n2; ++n3) {
            object = this.getElementAt(n3);
            if (!this.compare(object, string2)) continue;
            return n3;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            object = this.getElementAt(n3);
            if (!this.compare(object, string2)) continue;
            return n3;
        }
        return -1;
    }

    public int reverseFindFromCursor(String string) {
        Object object;
        int n2;
        int n3;
        if (!this.isReverseOrder()) {
            return this.findFromCursor(string);
        }
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n4 = this.getCurrentIndex();
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n3 = this.getElementCount()) == 0) {
            return -1;
        }
        for (n2 = n4; n2 >= 0; --n2) {
            object = this.getElementAt(n2);
            if (!this.compare(object, string2)) continue;
            return n2;
        }
        for (n2 = n3 - 1; n2 >= n4; --n2) {
            object = this.getElementAt(n2);
            if (!this.compare(object, string2)) continue;
            return n2;
        }
        return -1;
    }

    public int findFirst(String string) {
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n2 = this.getElementCount();
        if (n2 == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.\u0101(n2, i2);
            Object object = this.getElementAt(n3);
            if (!this.compare(object, string2)) continue;
            return n3;
        }
        return -1;
    }

    public int findLast(String string) {
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n2 = this.getElementCount();
        if (n2 == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            Object object = this.getElementAt(i2);
            if (!this.compare(object, string2)) continue;
            return i2;
        }
        return -1;
    }

    protected void keyTypedOrPressed(KeyEvent keyEvent) {
        if (this.\u010b != null && this.\u010b.isPassive()) {
            this.\u010b.processKeyEvent(keyEvent);
            return;
        }
        if (this.isActivateKey(keyEvent)) {
            String string = "";
            if (keyEvent.getID() == 400) {
                if (JideSwingUtilities.isMenuShortcutKeyDown(keyEvent)) {
                    return;
                }
                if (keyEvent.isAltDown()) {
                    return;
                }
                string = String.valueOf(keyEvent.getKeyChar());
            }
            this.showPopup(string);
            if (keyEvent.getKeyCode() != 10) {
                keyEvent.consume();
            }
        }
    }

    private int \u0101(int n2, int n3) {
        return this.isReverseOrder() ? n2 - n3 - 1 : n3;
    }

    public void showPopup(String string) {
        if (this.\u010b == null) {
            this.fireSearchableEvent(new SearchableEvent(this, 2999, string));
            this.\u0101(this.createSearchPopup(string));
            this.\u010b = new SearchableProvider(){

                @Override
                public String getSearchingText() {
                    return Searchable.this.\u0116 != null ? Searchable.this.\u0116.getSearchingText() : "";
                }

                @Override
                public boolean isPassive() {
                    return true;
                }

                @Override
                public void processKeyEvent(KeyEvent keyEvent) {
                    if (Searchable.this.\u0116 != null) {
                        Searchable.this.\u0116.processKeyEvent(keyEvent);
                    }
                }
            };
        }
    }

    protected SearchPopup createSearchPopup(String string) {
        return new DefaultSearchPopup(string);
    }

    public String getSearchingText() {
        return this.\u010b != null ? this.\u010b.getSearchingText() : "";
    }

    private void \u0101(SearchPopup searchPopup) {
        JRootPane jRootPane = this._component.getRootPane();
        this.\u0118 = jRootPane != null ? jRootPane.getLayeredPane() : null;
        if (this.\u0118 == null || this.isHeavyweightComponentEnabled()) {
            this.\u0116 = searchPopup;
            Point point = this.\u0101();
            if (point != null) {
                searchPopup.showPopup(point.x, point.y);
                this.\u0116.setVisible(true);
            } else {
                this.\u0116 = null;
            }
        } else {
            if (this.\u0116 != null && this.\u0118 != null) {
                this.\u0118.remove(this.\u0116);
                this.\u0118.validate();
                this.\u0118.repaint();
                this.\u0118 = null;
            } else {
                this.\u0116 = !this._component.isShowing() ? null : searchPopup;
            }
            if (this.\u0116 == null || !this._component.isDisplayable()) {
                return;
            }
            if (this.\u0118 == null) {
                System.err.println("Failed to find layeredPane.");
                return;
            }
            this.\u0118.add((Component)this.\u0116, JLayeredPane.POPUP_LAYER);
            this.\u0101();
            this.\u0116.setVisible(true);
            this.\u0116.validate();
        }
        if (this.\u0116 != null) {
            this.\u0116.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    Searchable.this.\u0116 = null;
                    Searchable.this.\u010b = null;
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
    }

    private Point \u0101() {
        Component component = this.getPopupLocationRelativeTo();
        if (component == null) {
            component = JideSwingUtilities.getScrollPane(this._component);
        }
        if (component == null) {
            component = this._component;
        }
        if (this.\u0116 != null) {
            Point point;
            Dimension dimension = this.\u0116.getPreferredSize();
            switch (this.getPopupLocation()) {
                case 3: {
                    try {
                        point = component.getLocationOnScreen();
                        point.y += component.getHeight();
                        if (this.isHeavyweightComponentEnabled()) break;
                        SwingUtilities.convertPointFromScreen(point, this.\u0118);
                        if (point.y + dimension.height <= this.\u0118.getHeight()) break;
                        point.y = this.\u0118.getHeight() - dimension.height;
                        break;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        return null;
                    }
                }
                default: {
                    try {
                        point = component.getLocationOnScreen();
                        if (!this.isHeavyweightComponentEnabled()) {
                            SwingUtilities.convertPointFromScreen(point, this.\u0118);
                        }
                        point.y -= dimension.height;
                        if (point.y >= 0) break;
                        point.y = 0;
                        break;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        return null;
                    }
                }
            }
            if (!this.isHeavyweightComponentEnabled()) {
                this.\u0116.setLocation(point);
                this.\u0116.setSize(dimension);
            } else {
                this.\u0116.packPopup();
            }
            return point;
        }
        return null;
    }

    protected boolean isFindFirstKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 36;
    }

    protected boolean isFindLastKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 35;
    }

    protected boolean isFindPreviousKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 38;
    }

    protected boolean isFindNextKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 40;
    }

    protected boolean isNavigationKey(KeyEvent keyEvent) {
        return this.isFindFirstKey(keyEvent) || this.isFindLastKey(keyEvent) || this.isFindNextKey(keyEvent) || this.isFindPreviousKey(keyEvent);
    }

    protected boolean isActivateKey(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        return keyEvent.getID() == 400 && c2 > ' ' && c2 != '\u007f';
    }

    protected boolean isDeactivateKey(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        return n2 == 10 || n2 == 27 || n2 == 33 || n2 == 34 || n2 == 36 || n2 == 35 || n2 == 37 || n2 == 39 || n2 == 38 || n2 == 40;
    }

    protected boolean isSelectAllKey(KeyEvent keyEvent) {
        return JideSwingUtilities.isMenuShortcutKeyDown(keyEvent) && keyEvent.getKeyCode() == 65;
    }

    protected boolean isIncrementalSelectKey(KeyEvent keyEvent) {
        return JideSwingUtilities.isMenuShortcutKeyDown(keyEvent);
    }

    public Color getMismatchForeground() {
        if (this.\u010e == null) {
            return Color.RED;
        }
        return this.\u010e;
    }

    public void setMismatchForeground(Color color) {
        this.\u010e = color;
    }

    public boolean isCaseSensitive() {
        return this.\u0106;
    }

    public void setCaseSensitive(boolean bl) {
        this.\u0106 = bl;
    }

    public int getSearchingDelay() {
        return this.\u011a;
    }

    public void setSearchingDelay(int n2) {
        this.\u011a = n2;
    }

    public boolean isRepeats() {
        return this.\u010d;
    }

    public void setRepeats(boolean bl) {
        this.\u010d = bl;
    }

    public Color getForeground() {
        if (this.\u0105 == null) {
            return UIDefaultsLookup.getColor("ToolTip.foreground");
        }
        return this.\u0105;
    }

    public void setForeground(Color color) {
        this.\u0105 = color;
    }

    public Color getBackground() {
        if (this.\u0107 == null) {
            return UIDefaultsLookup.getColor("ToolTip.background");
        }
        return this.\u0107;
    }

    public void setBackground(Color color) {
        this.\u0107 = color;
    }

    public boolean isWildcardEnabled() {
        return this.\u0104;
    }

    public void setWildcardEnabled(boolean bl) {
        this.\u0104 = bl;
    }

    public WildcardSupport getWildcardSupport() {
        if (this.\u0117 == null) {
            this.\u0117 = new DefaultWildcardSupport();
        }
        return this.\u0117;
    }

    public void setWildcardSupport(WildcardSupport wildcardSupport) {
        this.\u0117 = wildcardSupport;
    }

    public String getSearchLabel() {
        if (this.\u0103 == null) {
            return this.getResourceString("Searchable.searchFor");
        }
        return this.\u0103;
    }

    public void setSearchLabel(String string) {
        this.\u0103 = string;
    }

    public void addSearchableListener(SearchableListener searchableListener) {
        this.listenerList.add(SearchableListener.class, searchableListener);
    }

    public void removeSearchableListener(SearchableListener searchableListener) {
        this.listenerList.remove(SearchableListener.class, searchableListener);
    }

    public SearchableListener[] getSearchableListeners() {
        return (SearchableListener[])this.listenerList.getListeners(SearchableListener.class);
    }

    public boolean isSearchableListenerInstalled(SearchableListener searchableListener) {
        SearchableListener[] searchableListenerArray;
        for (SearchableListener searchableListener2 : searchableListenerArray = this.getSearchableListeners()) {
            if (searchableListener2 != searchableListener) continue;
            return true;
        }
        return false;
    }

    protected void fireSearchableEvent(SearchableEvent searchableEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != SearchableListener.class) continue;
            ((SearchableListener)objectArray[i2 + 1]).searchableEventFired(searchableEvent);
        }
    }

    public Component getComponent() {
        return this._component;
    }

    public int getPopupLocation() {
        return this.\u0110;
    }

    public void setPopupLocation(int n2) {
        this.\u0110 = n2;
    }

    public boolean isReverseOrder() {
        return this.\u0111;
    }

    public void setReverseOrder(boolean bl) {
        this.\u0111 = bl;
    }

    protected String getResourceString(String string) {
        return G.\u0101(this._component != null ? this._component.getLocale() : Locale.getDefault()).getString(string);
    }

    public boolean isPopupVisible() {
        return this.\u0116 != null;
    }

    public boolean isHeavyweightComponentEnabled() {
        return this.\u011c;
    }

    public void setHeavyweightComponentEnabled(boolean bl) {
        this.\u011c = bl;
    }

    public Component getPopupLocationRelativeTo() {
        return this.\u0114;
    }

    public void setPopupLocationRelativeTo(Component component) {
        this.\u0114 = component;
    }

    public boolean isFromStart() {
        return this.\u011d;
    }

    public void setFromStart(boolean bl) {
        this.hidePopup();
        this.\u011d = bl;
    }

    public static Searchable getSearchable(JComponent jComponent) {
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY_SEARCHABLE);
        if (object instanceof Searchable) {
            return (Searchable)object;
        }
        return null;
    }

    private void \u0101(JComponent jComponent, Searchable searchable) {
        if (jComponent != null) {
            Object object = this._component.getClientProperty(CLIENT_PROPERTY_SEARCHABLE);
            if (object instanceof Searchable) {
                ((Searchable)object).uninstallListeners();
            }
            jComponent.putClientProperty(CLIENT_PROPERTY_SEARCHABLE, searchable);
        }
    }

    public boolean isProcessModelChangeEvent() {
        return this.\u010a;
    }

    public void setProcessModelChangeEvent(boolean bl) {
        this.\u010a = bl;
    }

    public int getPopupTimeout() {
        return this.\u0102;
    }

    public void setPopupTimeout(int n2) {
        this.\u0102 = n2;
    }

    public boolean isCountMatch() {
        return this.\u0112;
    }

    public void setCountMatch(boolean bl) {
        this.\u0112 = bl;
    }

    int \u0102() {
        return this._matchCount;
    }

    public List<Integer> findAll(String string) {
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.getElementCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = this.getElementAt(i2);
            if (!this.compare(object, string2)) continue;
            arrayList.add(i2);
        }
        return arrayList;
    }

    public String getElementAtAsString(int n2) {
        return this.convertElementToString(this.getElementAt(n2));
    }

    protected void textChanged(String string) {
        if (string == null || string.length() == 0) {
            this.firePropertyChangeEvent("");
            return;
        }
        int n2 = this.findFromCursor(string);
        if (n2 == -1) {
            this.firePropertyChangeEvent(string);
            this.fireSearchableEvent(new SearchableEvent(this, 3003, string));
        } else {
            this.firePropertyChangeEvent(string);
            Object object = this.getElementAt(n2);
            this.fireSearchableEvent(new SearchableEvent(this, 3002, string, object, this.convertElementToString(object)));
        }
    }

    public int findFirstExactly(String string) {
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n2 = this.getElementCount();
        if (n2 == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.\u0101(n2, i2);
            Object object = this.getElementAt(n3);
            String string3 = this.convertElementToString(object);
            if (!JideSwingUtilities.equals(string3, string2)) continue;
            return n3;
        }
        return -1;
    }

    public abstract class SearchPopup
    extends JidePopup {
        protected SearchField _textField;

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            this._textField.processKeyEvent(keyEvent);
            if (keyEvent.isConsumed()) {
                String string = this.getSearchingText();
                if (string.length() == 0) {
                    return;
                }
                if (Searchable.this.isSelectAllKey(keyEvent)) {
                    this.\u0101(keyEvent, string);
                    return;
                }
                if (Searchable.this.isFindPreviousKey(keyEvent)) {
                    int n2 = Searchable.this.findPrevious(string);
                    this.select(n2, keyEvent, string);
                } else if (Searchable.this.isFindNextKey(keyEvent)) {
                    int n3 = Searchable.this.findNext(string);
                    this.select(n3, keyEvent, string);
                } else if (Searchable.this.isFindFirstKey(keyEvent)) {
                    int n4 = Searchable.this.findFirst(string);
                    this.select(n4, keyEvent, string);
                } else if (Searchable.this.isFindLastKey(keyEvent)) {
                    int n5 = Searchable.this.findLast(string);
                    this.select(n5, keyEvent, string);
                }
            }
            if (keyEvent.getKeyCode() != 10) {
                keyEvent.consume();
            }
        }

        private void \u0101(KeyEvent keyEvent, String string) {
            int n2;
            boolean bl;
            int n3;
            boolean bl2 = Searchable.this.isReverseOrder();
            if (bl2) {
                Searchable.this.setReverseOrder(false);
            }
            if ((n3 = Searchable.this.findFirst(string)) != -1) {
                Searchable.this.setSelectedIndex(n3, false);
                Searchable.this.setCursor(n3);
            }
            if (bl = Searchable.this.isRepeats()) {
                Searchable.this.setRepeats(false);
            }
            while (n3 != -1 && (n3 = n3 == (n2 = Searchable.this.findNext(string)) ? -1 : n2) != -1) {
                this.select(n3, keyEvent, string);
            }
            if (bl) {
                Searchable.this.setRepeats(bl);
            }
            if (bl2) {
                Searchable.this.setReverseOrder(bl2);
            }
        }

        public String getSearchingText() {
            return this._textField != null ? this._textField.getText() : "";
        }

        public JTextField getTextField() {
            return this._textField;
        }

        protected abstract void select(int var1, KeyEvent var2, String var3);
    }

    public class DefaultSearchPopup
    extends SearchPopup {
        private JLabel \u0128;
        private JLabel \u0127;

        public DefaultSearchPopup(String string) {
            this.\u0101(string);
        }

        private void \u0101(String string) {
            final Color color = Searchable.this.getForeground();
            Color color2 = Searchable.this.getBackground();
            this.\u0128 = new JLabel(Searchable.this.getSearchLabel());
            this.\u0128.setForeground(color);
            this.\u0128.setVerticalAlignment(3);
            this.\u0127 = new JLabel();
            this.\u0127.setForeground(Searchable.this.getMismatchForeground());
            this.\u0127.setVerticalAlignment(3);
            this._textField = new SearchField();
            this._textField.setFocusable(false);
            this._textField.setBorder(BorderFactory.createEmptyBorder());
            this._textField.setForeground(color);
            this._textField.setCursor(this.getCursor());
            this._textField.getDocument().addDocumentListener(new DocumentListener(){
                private Timer \u0103 = new Timer(200, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.\u0101();
                    }
                });

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.\u0102();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.\u0102();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.\u0102();
                }

                protected void \u0101() {
                    String string = DefaultSearchPopup.this._textField.getText();
                    Searchable.this.firePropertyChangeEvent(string);
                    if (string.length() != 0) {
                        int n2 = Searchable.this.findFromCursor(string);
                        if (n2 == -1) {
                            DefaultSearchPopup.this._textField.setForeground(Searchable.this.getMismatchForeground());
                        } else {
                            DefaultSearchPopup.this._textField.setForeground(color);
                        }
                        DefaultSearchPopup.this.select(n2, null, string);
                    } else {
                        DefaultSearchPopup.this._textField.setForeground(color);
                        DefaultSearchPopup.this.\u0127.setText("");
                        DefaultSearchPopup.this.\u0107();
                        DefaultSearchPopup.this.hidePopup();
                    }
                }

                void \u0102() {
                    DefaultSearchPopup.this.\u0107();
                    if (Searchable.this.getSearchingDelay() > 0) {
                        this.\u0103.setInitialDelay(Searchable.this.getSearchingDelay());
                        if (this.\u0103.isRunning()) {
                            this.\u0103.restart();
                        } else {
                            this.\u0103.setRepeats(false);
                            this.\u0103.start();
                        }
                    } else {
                        this.\u0101();
                    }
                }
            });
            this._textField.setText(string);
            this.setBackground(color2);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIDefaultsLookup.getColor("controlShadow"), 1), BorderFactory.createEmptyBorder(0, 6, 1, 8)));
            this.setLayout(new BorderLayout(2, 0));
            Dimension dimension = this.\u0128.getPreferredSize();
            dimension.height = this._textField.getPreferredSize().height;
            this.\u0128.setPreferredSize(dimension);
            this.add((Component)this.\u0128, "Before");
            this.add((Component)this._textField, "Center");
            this.add((Component)this.\u0127, "After");
            this.setPopupBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        protected void select(int n2, KeyEvent keyEvent, String string) {
            if (n2 != -1) {
                boolean bl = keyEvent != null && Searchable.this.isIncrementalSelectKey(keyEvent);
                Searchable.this.setSelectedIndex(n2, bl);
                Searchable.this.setCursor(n2, bl);
                this._textField.setForeground(Searchable.this.getForeground());
                this.\u0127.setText("");
            } else {
                this._textField.setForeground(Searchable.this.getMismatchForeground());
                this.\u0127.setText(Searchable.this.getResourceString("Searchable.noMatch"));
            }
            this.\u0107();
            if (n2 != -1) {
                Object object = Searchable.this.getElementAt(n2);
                Searchable.this.fireSearchableEvent(new SearchableEvent(Searchable.this, 3002, string, object, Searchable.this.convertElementToString(object)));
            } else {
                Searchable.this.fireSearchableEvent(new SearchableEvent(Searchable.this, 3003, string));
            }
        }

        private void \u0107() {
            if (Searchable.this.\u0116 != null) {
                this._textField.invalidate();
                try {
                    if (!Searchable.this.isHeavyweightComponentEnabled()) {
                        Dimension dimension = this.\u0127.getPreferredSize();
                        dimension.width += this.\u0128.getPreferredSize().width;
                        dimension.width += new JLabel((String)this._textField.getText()).getPreferredSize().width + 24;
                        dimension.height = ((Searchable)Searchable.this).\u0116.getSize().height;
                        Searchable.this.\u0116.setSize(dimension);
                        Searchable.this.\u0116.validate();
                    } else {
                        Searchable.this.\u0116.packPopup();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected class SearchField
    extends JTextField {
        SearchField() {
            JideSwingUtilities.setComponentTransparent(this);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + 4;
            return dimension;
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            int n2 = keyEvent.getKeyCode();
            if (n2 == 8 && this.getDocument().getLength() == 0) {
                keyEvent.consume();
                return;
            }
            boolean bl = Searchable.this.isNavigationKey(keyEvent);
            if (Searchable.this.isDeactivateKey(keyEvent) && !bl) {
                Searchable.this.hidePopup();
                if (n2 == 27) {
                    keyEvent.consume();
                }
                return;
            }
            super.processKeyEvent(keyEvent);
            if (n2 == 8 || bl) {
                keyEvent.consume();
            }
            if (Searchable.this.isSelectAllKey(keyEvent)) {
                keyEvent.consume();
            }
        }
    }
}

