/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Calculator
extends JPanel
implements ActionListener {
    private double \u0113;
    private StringBuffer \u0103 = new StringBuffer();
    private StringBuffer \u0102 = new StringBuffer();
    private int \u0109 = -1;
    private String \u0101;
    private boolean \u0107 = false;
    private boolean \u0116 = true;
    private boolean \u010c = false;
    private boolean \u010a = false;
    private boolean \u011a = false;
    private boolean \u0119 = false;
    private boolean \u0104 = false;
    public static final int OPERATOR_NONE = -1;
    public static final int OPERATOR_ADD = 0;
    public static final int OPERATOR_MINUS = 1;
    public static final int OPERATOR_MULTIPLY = 2;
    public static final int OPERATOR_DIVIDE = 3;
    private AbstractButton \u011b;
    private AbstractButton \u0117;
    private AbstractButton \u0112;
    private AbstractButton \u010d;
    private AbstractButton \u0114;
    private AbstractButton \u0108;
    private AbstractButton \u0115;
    private AbstractButton \u0111;
    private AbstractButton \u0106;
    private AbstractButton[] \u0118;
    private char \u0105;
    private NumberFormat \u010b = NumberFormat.getNumberInstance();
    public static final char CHAR_CLEAR = 'c';
    public static final char CHAR_POINT = '.';
    public static final char CHAR_ADD = '+';
    public static final char CHAR_MINUS = '-';
    public static final char CHAR_MULTIPLY = '*';
    public static final char CHAR_DIVIDE = '/';
    public static final char CHAR_EQUAL = '=';
    public static final char CHAR_NEGATIVE = '!';
    public static final char CHAR_BACKSPACE = '<';
    public static final char CHAR_0 = '0';
    public static final char CHAR_1 = '1';
    public static final char CHAR_2 = '2';
    public static final char CHAR_3 = '3';
    public static final char CHAR_4 = '4';
    public static final char CHAR_5 = '5';
    public static final char CHAR_6 = '6';
    public static final char CHAR_7 = '7';
    public static final char CHAR_8 = '8';
    public static final char CHAR_9 = '9';
    public static final String PROPERTY_DISPLAY_TEXT = "displayText";
    public static final String PROPERTY_OPERATOR = "operator";
    private int \u0110 = 24;
    private int \u010e = 24;
    private int \u010f = 2;

    public Calculator() {
        this.configureNumberFormat();
        this.initComponents();
        this.registerKeyboardActions(this, 1);
    }

    @Override
    public void setLocale(Locale locale) {
        this.unregisterKeyboardActions(this);
        super.setLocale(locale);
        this.\u0103 = new StringBuffer();
        this.\u0102 = new StringBuffer();
        this.\u010b = NumberFormat.getNumberInstance(this.getLocale());
        this.configureNumberFormat();
        this.\u0105 = this.getDisplayFormat().format(2.01).charAt(1);
        this.\u0114.setText("" + this.\u0105);
        this.registerKeyboardActions(this, 1);
    }

    protected void configureNumberFormat() {
        this.\u010b.setMaximumFractionDigits(20);
        this.\u010b.setMinimumFractionDigits(0);
        this.\u010b.setGroupingUsed(false);
    }

    public static boolean isValidKeyEvent(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        return (keyEvent.getModifiers() & 0xFFFFFFFE) != 0 || Character.isDigit(c2) || Calculator.isOperator(keyEvent) || Calculator.isEnterOrEqual(keyEvent) || c2 == '.' || c2 == ',' || c2 == 'c' || Character.toLowerCase(c2) == 'c' || c2 == '\u001b' || c2 == '\b';
    }

    public static boolean isOperator(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        return c2 == '+' || c2 == '-' || c2 == '*' || c2 == '/';
    }

    public static boolean isEnterOrEqual(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        return c2 == '\n' || c2 == '=';
    }

    public void registerKeyboardActions(JComponent jComponent, int n2) {
        boolean bl = this.isCellEditor();
        jComponent.registerKeyboardAction(this, "+", KeyStroke.getKeyStroke('+'), n2);
        jComponent.registerKeyboardAction(this, "-", KeyStroke.getKeyStroke('-'), n2);
        jComponent.registerKeyboardAction(this, "*", KeyStroke.getKeyStroke('*'), n2);
        jComponent.registerKeyboardAction(this, "/", KeyStroke.getKeyStroke('/'), n2);
        jComponent.registerKeyboardAction(this, "=", KeyStroke.getKeyStroke('='), n2);
        if (!bl) {
            jComponent.registerKeyboardAction(this, "=", KeyStroke.getKeyStroke(10, 0), n2);
        }
        jComponent.registerKeyboardAction(this, "0", KeyStroke.getKeyStroke('0'), n2);
        jComponent.registerKeyboardAction(this, "1", KeyStroke.getKeyStroke('1'), n2);
        jComponent.registerKeyboardAction(this, "2", KeyStroke.getKeyStroke('2'), n2);
        jComponent.registerKeyboardAction(this, "3", KeyStroke.getKeyStroke('3'), n2);
        jComponent.registerKeyboardAction(this, "4", KeyStroke.getKeyStroke('4'), n2);
        jComponent.registerKeyboardAction(this, "5", KeyStroke.getKeyStroke('5'), n2);
        jComponent.registerKeyboardAction(this, "6", KeyStroke.getKeyStroke('6'), n2);
        jComponent.registerKeyboardAction(this, "7", KeyStroke.getKeyStroke('7'), n2);
        jComponent.registerKeyboardAction(this, "8", KeyStroke.getKeyStroke('8'), n2);
        jComponent.registerKeyboardAction(this, "9", KeyStroke.getKeyStroke('9'), n2);
        jComponent.registerKeyboardAction(this, "" + this.\u0105, KeyStroke.getKeyStroke(this.\u0105), n2);
        jComponent.registerKeyboardAction(this, "<", KeyStroke.getKeyStroke(8, 0), n2);
        if (!bl) {
            jComponent.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(27, 0), n2);
        }
        if (!bl) {
            jComponent.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(27, 0), 1);
        }
        jComponent.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(Character.toUpperCase('c')), n2);
        jComponent.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(Character.toLowerCase('c')), n2);
    }

    public void unregisterKeyboardActions(JComponent jComponent) {
        boolean bl = this.isCellEditor();
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('+'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('-'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('*'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('/'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('='));
        if (!bl) {
            jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        }
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('0'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('1'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('2'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('3'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('4'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('5'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('6'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('7'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('8'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('9'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(this.\u0105));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(8, 0));
        if (!bl) {
            jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        }
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(Character.toUpperCase('c')));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(Character.toLowerCase('c')));
    }

    protected void initComponents() {
        this.setLayout(new B());
        this.\u011b = this.createButton("+");
        this.add(this.\u011b);
        this.\u0117 = this.createButton("-");
        this.add(this.\u0117);
        this.\u0112 = this.createButton("*");
        this.add(this.\u0112);
        this.\u010d = this.createButton("/");
        this.add(this.\u010d);
        this.\u0118 = new AbstractButton[10];
        for (int i2 = 0; i2 <= 9; ++i2) {
            this.\u0118[i2] = this.createButton("" + i2);
            this.add(this.\u0118[i2]);
        }
        this.\u0105 = this.getDisplayFormat().format(2.01).charAt(1);
        this.\u0114 = this.createButton("" + this.\u0105);
        this.add(this.\u0114);
        this.\u0108 = this.createButton("=");
        this.add(this.\u0108);
        this.\u0115 = this.createButton(null, new C());
        this.add(this.\u0115);
        this.\u0106 = this.createButton(null, new A());
        this.add(this.\u0106);
        this.\u0111 = this.createButton("C");
        this.add(this.\u0111);
    }

    public boolean isResultCalculated() {
        return this.\u0104;
    }

    public void setResultCalculated(boolean bl) {
        this.\u0104 = bl;
    }

    protected AbstractButton createButton(String string) {
        return this.createButton(string, null);
    }

    protected AbstractButton createButton(String string, Icon icon) {
        JideButton jideButton = new JideButton(string, icon);
        jideButton.setOpaque(true);
        jideButton.setContentAreaFilled(true);
        jideButton.setRequestFocusEnabled(false);
        jideButton.setFocusable(false);
        jideButton.addActionListener(this);
        return jideButton;
    }

    public boolean isOverflow() {
        return this.\u0107;
    }

    public void setOverflow(boolean bl) {
        this.\u0107 = bl;
    }

    public void input(char c2) {
        if ('c' == Character.toLowerCase(c2) || 'c' == Character.toUpperCase(c2)) {
            this.clear();
            return;
        }
        if (this.\u0107) {
            this.beep();
            return;
        }
        if (Character.isDigit(c2) || this.\u0105 == c2) {
            if (this.\u011a) {
                this.setOperator(-1);
                this.\u0103.setLength(0);
                this.\u011a = false;
            }
            if (this.getOperator() == -1) {
                if (this.\u0105 != c2 || this.\u0103.indexOf("" + this.\u0105) == -1) {
                    this.\u0103.append(c2);
                    this.\u010c = true;
                    this.\u010a = false;
                    this.setDisplayText(this.\u0103.toString());
                } else {
                    this.beep();
                }
            } else if (this.\u0105 != c2 || this.\u0102.indexOf("" + this.\u0105) == -1) {
                this.\u0102.append(c2);
                this.\u010a = true;
                this.\u010c = false;
                this.setDisplayText(this.\u0102.toString());
            } else {
                this.beep();
            }
        } else {
            switch (c2) {
                case '+': {
                    this.\u0101(0);
                    break;
                }
                case '-': {
                    this.\u0101(1);
                    break;
                }
                case '*': {
                    this.\u0101(2);
                    break;
                }
                case '/': {
                    this.\u0101(3);
                    break;
                }
                case '=': {
                    this.\u0101(true);
                    this.\u011a = true;
                    break;
                }
                case '!': {
                    if (this.\u0116) {
                        this.\u0102(this.\u0103);
                        this.setDisplayText(this.\u0103.toString());
                        break;
                    }
                    this.\u0102(this.\u0102);
                    this.setDisplayText(this.\u0102.toString());
                    break;
                }
                case '<': {
                    if (this.\u010c) {
                        this.\u0101(this.\u0103);
                        this.setDisplayText(this.\u0103.toString());
                        break;
                    }
                    if (this.\u010a) {
                        this.\u0101(this.\u0102);
                        this.setDisplayText(this.\u0102.toString());
                        break;
                    }
                    this.beep();
                }
            }
        }
    }

    private void \u0101(int n2) {
        if (this.\u0103.length() == 0) {
            this.\u0103.append("0");
        } else if (this.getOperator() == -1 || this.\u011a) {
            this.\u0102.setLength(0);
            this.\u0101(false);
        } else {
            if (this.\u0102.length() == 0) {
                this.beep();
                return;
            }
            this.\u0119 = false;
            this.\u0101(true);
            this.\u0103.setLength(0);
            this.\u0103.append(this.getDisplayFormat().format((Object)this.\u0113));
            this.\u0102.setLength(0);
        }
        this.setOperator(n2);
        this.\u0116 = false;
        this.\u011a = false;
    }

    protected void beep() {
        PortingUtils.notifyUser();
    }

    private void \u0102(StringBuffer stringBuffer) {
        if (stringBuffer.length() == 0) {
            return;
        }
        if (stringBuffer.charAt(0) == '-') {
            stringBuffer.deleteCharAt(0);
        } else {
            stringBuffer.insert(0, '-');
        }
    }

    private void \u0101(StringBuffer stringBuffer) {
        if (stringBuffer.length() == 0) {
            return;
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
    }

    public void updateResult() {
        this.\u0119 = false;
        this.\u0101(true);
    }

    private void \u0101(boolean bl) {
        Double d2;
        Double d3;
        if (this.getOperator() == -1) {
            return;
        }
        if (this.\u0103.length() == 0) {
            this.beep();
            return;
        }
        if (bl) {
            if (this.\u0102.length() == 0) {
                this.\u0102.append(this.\u0103);
            }
        } else if (this.\u0102.length() == 0) {
            return;
        }
        try {
            d3 = this.getDisplayFormat().parse(this.\u0103.toString()).doubleValue();
            d2 = this.getDisplayFormat().parse(this.\u0102.toString()).doubleValue();
        }
        catch (ParseException parseException) {
            d3 = 0.0;
            d2 = 0.0;
        }
        if (!this.\u0119) {
            try {
                switch (this.getOperator()) {
                    case 0: {
                        this.\u0113 = d3 + d2;
                        break;
                    }
                    case 1: {
                        this.\u0113 = d3 - d2;
                        break;
                    }
                    case 2: {
                        this.\u0113 = d3 * d2;
                        break;
                    }
                    case 3: {
                        if (d2 == 0.0) {
                            this.\u0113 = Double.NaN;
                            this.\u0107 = true;
                            break;
                        }
                        this.\u0113 = d3 / d2;
                    }
                }
            }
            catch (Exception exception) {
                this.\u0107 = true;
            }
        }
        if (this.\u0107) {
            this.setDisplayText("E");
        } else {
            this.setResultCalculated(true);
            this.\u0103.setLength(0);
            if (this.\u010b != null) {
                String string = this.\u010b.format(this.\u0113);
                this.setDisplayText(string);
            } else {
                this.setDisplayText("" + this.\u0113);
            }
            this.\u0103.append(this.getDisplayText());
            this.\u0116 = true;
            this.\u010c = true;
            this.\u010a = false;
        }
    }

    private void \u0101() {
        this.setOperator(-1);
        this.\u0103.setLength(0);
        this.\u0102.setLength(0);
    }

    public void clear() {
        this.\u0101();
        this.\u0107 = false;
        this.\u011a = false;
        this.setDisplayText("0");
    }

    public double getResult() {
        return this.\u0113;
    }

    public String getDisplayText() {
        return this.\u0101;
    }

    public void setDisplayText(String string) {
        String string2 = this.\u0101;
        this.\u0101 = string;
        this.firePropertyChange(PROPERTY_DISPLAY_TEXT, string2, this.\u0101);
    }

    public int getOperator() {
        return this.\u0109;
    }

    public void setOperator(int n2) {
        int n3 = this.\u0109;
        if (n3 != n2) {
            this.\u0109 = n2;
            this.firePropertyChange(PROPERTY_OPERATOR, new Integer(n3), new Integer(n2));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.\u011b == object) {
            this.input('+');
        } else if (this.\u0117 == object) {
            this.input('-');
        } else if (this.\u0112 == object) {
            this.input('*');
        } else if (this.\u010d == object) {
            this.input('/');
        } else if (this.\u0108 == object) {
            this.\u0119 = actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equals("Faked");
            this.input('=');
        } else if (this.\u0114 == object) {
            this.input(this.\u0105);
        } else if (this.\u0106 == object) {
            this.input('!');
        } else if (this.\u0115 == object) {
            this.input('<');
        } else if (this.\u0111 == object) {
            this.input('c');
        } else {
            boolean bl = false;
            for (int i2 = 0; i2 <= 9; ++i2) {
                if (this.\u0118[i2] != object) continue;
                this.input(("" + i2).charAt(0));
                bl = true;
                break;
            }
            if (!bl) {
                if (actionEvent.getActionCommand() != null && actionEvent.getActionCommand().length() > 0) {
                    this.\u0101(actionEvent.getActionCommand().charAt(0));
                } else {
                    this.\u0101('=');
                }
            }
        }
    }

    protected void fakePressButton(AbstractButton abstractButton) {
        this.actionPerformed(new ActionEvent(abstractButton, 0, null));
    }

    private void \u0101(char c2) {
        if (c2 == this.\u0105) {
            this.fakePressButton(this.\u0114);
            return;
        }
        switch (c2) {
            case 'c': {
                this.fakePressButton(this.\u0111);
                break;
            }
            case '<': {
                this.fakePressButton(this.\u0115);
                break;
            }
            case '=': {
                this.fakePressButton(this.\u0108);
                break;
            }
            case '!': {
                this.fakePressButton(this.\u0106);
                break;
            }
            case '+': {
                this.fakePressButton(this.\u011b);
                break;
            }
            case '-': {
                this.fakePressButton(this.\u0117);
                break;
            }
            case '*': {
                this.fakePressButton(this.\u0112);
                break;
            }
            case '/': {
                this.fakePressButton(this.\u010d);
                break;
            }
            case '0': {
                this.fakePressButton(this.\u0118[0]);
                break;
            }
            case '1': {
                this.fakePressButton(this.\u0118[1]);
                break;
            }
            case '2': {
                this.fakePressButton(this.\u0118[2]);
                break;
            }
            case '3': {
                this.fakePressButton(this.\u0118[3]);
                break;
            }
            case '4': {
                this.fakePressButton(this.\u0118[4]);
                break;
            }
            case '5': {
                this.fakePressButton(this.\u0118[5]);
                break;
            }
            case '6': {
                this.fakePressButton(this.\u0118[6]);
                break;
            }
            case '7': {
                this.fakePressButton(this.\u0118[7]);
                break;
            }
            case '8': {
                this.fakePressButton(this.\u0118[8]);
                break;
            }
            case '9': {
                this.fakePressButton(this.\u0118[9]);
            }
        }
    }

    public NumberFormat getDisplayFormat() {
        return this.\u010b;
    }

    public void setDisplayFormat(NumberFormat numberFormat) {
        this.\u010b = numberFormat;
    }

    public void commit() {
        if (!this.\u011a) {
            this.actionPerformed(new ActionEvent(this.\u0108, 0, "Faked"));
        }
    }

    public int getButtonWidth() {
        return this.\u0110;
    }

    public void setButtonWidth(int n2) {
        this.\u0110 = n2;
    }

    public int getButtonHeight() {
        return this.\u010e;
    }

    public void setButtonHeight(int n2) {
        this.\u010e = n2;
    }

    public int getButtonGap() {
        return this.\u010f;
    }

    public void setButtonGap(int n2) {
        this.\u010f = n2;
    }

    protected boolean isCellEditor() {
        return false;
    }

    public void setInitialValue(String string) {
        this.\u0103.setLength(0);
        this.\u0103.append(string);
        this.\u010c = true;
        this.\u010a = false;
        this.setDisplayText(this.\u0103.toString());
    }

    public static void main(String[] stringArray) {
        Calculator calculator = new Calculator();
        calculator.input('1');
        calculator.input('0');
        calculator.input('*');
        calculator.input('2');
        calculator.input('4');
        calculator.input('=');
    }

    private class B
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(Calculator.this.getButtonWidth() * 4 + Calculator.this.getButtonGap() * 3, Calculator.this.getButtonHeight() * 5 + Calculator.this.getButtonGap() * 4);
        }

        @Override
        public void layoutContainer(Container container) {
            int n2 = 0;
            int n3 = 0;
            int n4 = Calculator.this.getButtonWidth();
            int n5 = Calculator.this.getButtonHeight();
            int n6 = Calculator.this.getButtonGap();
            Calculator.this.\u0118[7].setBounds(n2, n3, n4, n5);
            Calculator.this.\u0118[8].setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.\u0118[9].setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.\u010d.setBounds(n2 += n4 + n6, n3, n4, n5);
            n2 = 0;
            Calculator.this.\u0118[4].setBounds(n2, n3 += n5 + n6, n4, n5);
            Calculator.this.\u0118[5].setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.\u0118[6].setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.\u0112.setBounds(n2 += n4 + n6, n3, n4, n5);
            n2 = 0;
            Calculator.this.\u0118[1].setBounds(n2, n3 += n5 + n6, n4, n5);
            Calculator.this.\u0118[2].setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.\u0118[3].setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.\u0117.setBounds(n2 += n4 + n6, n3, n4, n5);
            n2 = 0;
            Calculator.this.\u0118[0].setBounds(n2, n3 += n5 + n6, n4, n5);
            Calculator.this.\u0114.setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.\u0106.setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.\u011b.setBounds(n2 += n4 + n6, n3, n4, n5);
            n2 = 0;
            Calculator.this.\u0111.setBounds(n2, n3 += n5 + n6, n4, n5);
            Calculator.this.\u0115.setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.\u0108.setBounds(n2 += n4 + n6, n3, n4 * 2 + n6, n5);
        }
    }

    class A
    implements Icon {
        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Color color = graphics.getColor();
            Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
            graphics.setColor(component.getForeground());
            graphics.drawLine(n2, n3 + 2, n2 + 6, n3 + 2);
            graphics.drawLine(n2, n3 + 7, n2 + 6, n3 + 7);
            graphics.drawLine(n2 + 3, n3, n2 + 3, n3 + 5);
            graphics.setColor(color);
            JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
        }

        @Override
        public int getIconWidth() {
            return 7;
        }

        @Override
        public int getIconHeight() {
            return 7;
        }
    }

    class C
    implements Icon {
        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
            Color color = graphics.getColor();
            graphics.setColor(component.getForeground());
            graphics.drawLine(n2, n3 + 3, n2 + 3, n3);
            graphics.drawLine(n2, n3 + 3, n2 + 3, n3 + 6);
            graphics.drawLine(n2 + 3, n3 + 3, n2 + 7, n3 + 3);
            graphics.setColor(color);
            JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
        }

        @Override
        public int getIconWidth() {
            return 7;
        }

        @Override
        public int getIconHeight() {
            return 7;
        }
    }
}

