/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.dialog.JideOptionPane;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.PaintPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class BasicJideOptionPaneUI
extends BasicOptionPaneUI {
    private Container \u0105;
    private JButton \u0103;
    private Container \u0101;
    private Container \u0108;
    private Component \u0106;
    private ThemePainter \u0104;
    private PropertyChangeListener \u0109;
    private int \u0102 = -1;
    private boolean \u0107 = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJideOptionPaneUI();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new JideBoxLayout(this.optionPane, 1);
    }

    public boolean isDetailsVisible() {
        return this.\u0107;
    }

    public void setDetailsVisible(boolean bl) {
        if (this.\u0107 != bl) {
            this.\u0107 = bl;
            this.\u0101();
        }
    }

    @Override
    protected void installComponents() {
        boolean bl;
        boolean bl2 = bl = UIDefaultsLookup.get("OptionPane.showBanner") == null || UIDefaultsLookup.getBoolean("OptionPane.showBanner");
        if (bl) {
            this.\u0108 = this.createBannerArea();
            this.optionPane.add((Component)this.\u0108, "fix");
        }
        Container container = this.createMessageArea();
        if (!bl) {
            this.addIcon(container);
        }
        LookAndFeel.installBorder((JComponent)container, "OptionPane.border");
        this.optionPane.add(container);
        Container container2 = this.createSeparator();
        if (container2 != null) {
            this.optionPane.add(container2);
        }
        this.\u0101 = this.createButtonArea();
        this.optionPane.add((Component)this.\u0101, "fix");
        this.optionPane.applyComponentOrientation(this.optionPane.getComponentOrientation());
        if (this.\u0102()) {
            this.updateDetailsComponent();
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.\u0109 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("details".equals(propertyChangeEvent.getPropertyName())) {
                    Component component;
                    BasicJideOptionPaneUI.this.updateDetailsComponent();
                    if (BasicJideOptionPaneUI.this.\u0101 instanceof ButtonPanel && (component = ((ButtonPanel)BasicJideOptionPaneUI.this.\u0101).getButtonByName("DETAILS")) != null) {
                        component.setVisible(propertyChangeEvent.getNewValue() != null);
                    }
                } else if ("title".equals(propertyChangeEvent.getPropertyName())) {
                    BasicJideOptionPaneUI.this.\u0101(BasicJideOptionPaneUI.this.\u0108);
                }
            }
        };
        this.optionPane.addPropertyChangeListener(this.\u0109);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.optionPane.removePropertyChangeListener(this.\u0109);
    }

    protected void updateDetailsComponent() {
        if (this.\u0105 != null) {
            this.optionPane.remove(this.\u0105);
            this.\u0105 = null;
        }
        this.\u0105 = this.createDetailsComponent();
        if (this.\u0105 != null) {
            this.optionPane.add((Component)this.\u0105, "vary");
            this.\u0105.setVisible(this.isDetailsVisible());
        }
    }

    @Override
    protected Container createMessageArea() {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        Border border = (Border)UIDefaultsLookup.get("OptionPane.messageAreaBorder");
        if (border != null) {
            jPanel.setBorder(border);
        }
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.setName("OptionPane.body");
        jPanel3.setName("OptionPane.realBody");
        if (this.getIcon() != null) {
            serializable = new JPanel();
            serializable.setName("OptionPane.separator");
            serializable.setPreferredSize(new Dimension(15, 1));
            jPanel3.add((Component)serializable, "Before");
        }
        jPanel3.add((Component)jPanel2, "Center");
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).gridheight = 1;
        int n2 = UIDefaultsLookup.getInt("OptionPane.messageAnchor");
        ((GridBagConstraints)serializable).anchor = n2 == 0 ? 10 : n2;
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 3, 0);
        Object object = this.getMessage();
        this.addMessageComponents(jPanel2, (GridBagConstraints)serializable, object, this.getMaxCharactersPerLineCount(), false);
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    @Override
    protected Container createSeparator() {
        return new JSeparator();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.optionPane.setBorder(BorderFactory.createEmptyBorder());
        this.\u0104 = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.\u0104 = null;
    }

    protected Container createDetailsComponent() {
        if (!(this.optionPane instanceof JideOptionPane)) {
            return null;
        }
        JideOptionPane jideOptionPane = (JideOptionPane)this.optionPane;
        Object object = jideOptionPane.getDetails();
        if (object instanceof Container) {
            this.\u0102 = ((Container)object).getPreferredSize().width;
            return (Container)object;
        }
        if (object instanceof Component) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)object);
            this.\u0102 = jPanel.getPreferredSize().width;
            return jPanel;
        }
        if (object instanceof String) {
            JTextArea jTextArea = new JTextArea((String)object);
            jTextArea.setEditable(false);
            jTextArea.setRows(20);
            jTextArea.setColumns(60);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(new JScrollPane(jTextArea));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 6, 10, 6));
            this.\u0102 = jPanel.getPreferredSize().width;
            return jPanel;
        }
        return null;
    }

    @Override
    protected Container createButtonArea() {
        boolean bl;
        int n2 = UIDefaultsLookup.getInt("OptionPane.buttonOrientation");
        n2 = n2 == 0 ? 0 : n2;
        ButtonPanel buttonPanel = new ButtonPanel(n2);
        Border border = (Border)UIDefaultsLookup.get("OptionPane.buttonAreaBorder");
        buttonPanel.setName("OptionPane.buttonArea");
        if (border != null) {
            buttonPanel.setBorder(border);
        }
        buttonPanel.setSizeConstraint((bl = UIDefaultsLookup.getBoolean("OptionPane.sameSizeButtons")) ? 0 : 1);
        int n3 = UIDefaultsLookup.getInt("OptionPane.buttonPadding");
        n3 = n3 == 0 ? 6 : n3;
        buttonPanel.setButtonGap(n3);
        this.addButtonComponents(buttonPanel, this.getButtons(), this.getInitialValueIndex());
        return buttonPanel;
    }

    @Override
    protected void addButtonComponents(Container container, Object[] objectArray, int n2) {
        if (objectArray != null && objectArray.length > 0) {
            int n3 = objectArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                JButton jButton;
                Component component;
                Object object = objectArray[i2];
                if (object instanceof Component) {
                    component = (Component)object;
                    container.add(component, "ALTERNATIVE");
                    this.hasCustomComponents = true;
                } else {
                    jButton = object instanceof ButtonFactory ? ((ButtonFactory)object).\u0101() : (object instanceof Icon ? new JButton((Icon)object) : new JButton(object.toString()));
                    jButton.setMultiClickThreshhold(UIDefaultsLookup.getInt("OptionPane.buttonClickThreshhold"));
                    this.configureButton(jButton);
                    if ("YES".equals(jButton.getName()) || "NO".equals(jButton.getName()) || "OK".equals(jButton.getName()) || "CLOSE".equals(jButton.getName()) || "FINISH".equals(jButton.getName())) {
                        container.add((Component)jButton, "AFFIRMATIVE");
                    } else if ("CANCEL".equals(jButton.getName())) {
                        container.add((Component)jButton, "CANCEL");
                    } else if ("HELP".equals(jButton.getName())) {
                        container.add((Component)jButton, "HELP");
                    } else {
                        container.add((Component)jButton, "ALTERNATIVE");
                    }
                    if ("DETAILS".equals(jButton.getName())) {
                        jButton.addActionListener(new AbstractAction(){
                            private static final long \u0102 = -6121325145433592319L;

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                JButton jButton = (JButton)actionEvent.getSource();
                                BasicJideOptionPaneUI.this.\u0101();
                                Container container = jButton.getTopLevelAncestor();
                                if (container instanceof Window) {
                                    ((Window)container).pack();
                                }
                            }
                        });
                        jButton.setVisible(this.\u0102());
                        this.\u0103 = jButton;
                    } else {
                        ActionListener actionListener = this.createButtonActionListener(i2);
                        if (actionListener != null) {
                            jButton.addActionListener(actionListener);
                        }
                    }
                    component = jButton;
                }
                if (i2 != n2) continue;
                this.initialFocusComponent = component;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                jButton = (JButton)this.initialFocusComponent;
                jButton.addAncestorListener(new AncestorListener(){

                    @Override
                    public void ancestorAdded(AncestorEvent ancestorEvent) {
                        JButton jButton = (JButton)ancestorEvent.getComponent();
                        JRootPane jRootPane = SwingUtilities.getRootPane(jButton);
                        if (jRootPane != null) {
                            jRootPane.setDefaultButton(jButton);
                        }
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent ancestorEvent) {
                    }
                });
            }
        }
    }

    private void \u0101() {
        ResourceBundle resourceBundle = ButtonResources.getResourceBundle(this.optionPane.getLocale());
        if (this.\u0105.isVisible()) {
            this.setDetailsVisible(false);
            this.\u0105.setVisible(false);
            this.\u0103.setText(this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.showDetails") : resourceBundle.getString("Button.showDetails"));
            this.\u0103.setMnemonic(this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.showDetails.mnemonic").charAt(0) : resourceBundle.getString("Button.showDetails.mnemonic").charAt(0));
        } else {
            this.setDetailsVisible(true);
            this.\u0105.setVisible(true);
            this.\u0103.setText(this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.hideDetails") : resourceBundle.getString("Button.hideDetails"));
            this.\u0103.setMnemonic(this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.hideDetails.mnemonic").charAt(0) : resourceBundle.getString("Button.hideDetails.mnemonic").charAt(0));
        }
    }

    @Override
    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                Object[] objectArray2;
                int n2 = this.optionPane.getOptionType();
                Locale locale = this.optionPane.getLocale();
                if (n2 == 0) {
                    objectArray2 = new ButtonFactory[]{new ButtonFactory("YES", UIDefaultsLookup.getString("OptionPane.yesButtonText", locale), this.getMnemonic("OptionPane.yesButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.yesIcon")), new ButtonFactory("NO", UIDefaultsLookup.getString("OptionPane.noButtonText", locale), this.getMnemonic("OptionPane.noButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.noIcon"))};
                } else if (n2 == 1) {
                    objectArray2 = new ButtonFactory[]{new ButtonFactory("YES", UIDefaultsLookup.getString("OptionPane.yesButtonText", locale), this.getMnemonic("OptionPane.yesButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.yesIcon")), new ButtonFactory("NO", UIDefaultsLookup.getString("OptionPane.noButtonText", locale), this.getMnemonic("OptionPane.noButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.noIcon")), new ButtonFactory("CANCEL", UIDefaultsLookup.getString("OptionPane.cancelButtonText", locale), this.getMnemonic("OptionPane.cancelButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.cancelIcon"))};
                } else if (n2 == 2) {
                    objectArray2 = new ButtonFactory[]{new ButtonFactory("OK", JideSwingUtilities.getOKString(locale), this.getMnemonic("OptionPane.okButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.okIcon")), new ButtonFactory("CANCEL", JideSwingUtilities.getCancelString(locale), this.getMnemonic("OptionPane.cancelButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.cancelIcon"))};
                } else if (n2 == 3) {
                    objectArray2 = new ButtonFactory[1];
                    ResourceBundle resourceBundle = ButtonResources.getResourceBundle(this.optionPane.getLocale());
                    objectArray2[0] = new ButtonFactory("CLOSE", this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.close") : resourceBundle.getString("Button.close"), this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.close.mnemonic").charAt(0) : resourceBundle.getString("Button.close.mnemonic").charAt(0), null);
                } else {
                    objectArray2 = new ButtonFactory[]{new ButtonFactory("OK", JideSwingUtilities.getOKString(locale), this.getMnemonic("OptionPane.okButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.okIcon"))};
                }
                return this.addDetailsButton(objectArray2, true);
            }
            return this.addDetailsButton(objectArray, true);
        }
        return null;
    }

    protected Object[] addDetailsButton(Object[] objectArray, boolean bl) {
        if (bl) {
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            ResourceBundle resourceBundle = ButtonResources.getResourceBundle(this.optionPane.getLocale());
            objectArray2[objectArray2.length - 1] = this.isDetailsVisible() ? new ButtonFactory("DETAILS", this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.hideDetails") : resourceBundle.getString("Button.hideDetails"), this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.hideDetails.mnemonic").charAt(0) : resourceBundle.getString("Button.hideDetails.mnemonic").charAt(0), null) : new ButtonFactory("DETAILS", this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.showDetails") : resourceBundle.getString("Button.showDetails"), this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.showDetails.mnemonic").charAt(0) : resourceBundle.getString("Button.showDetails.mnemonic").charAt(0), null);
            return objectArray2;
        }
        return objectArray;
    }

    private boolean \u0102() {
        return this.optionPane instanceof JideOptionPane && ((JideOptionPane)this.optionPane).getDetails() != null;
    }

    protected void configureButton(JButton jButton) {
        Font font = (Font)UIDefaultsLookup.get("OptionPane.buttonFont");
        if (font != null) {
            jButton.setFont(font);
        }
    }

    protected int getMnemonic(String string, Locale locale) {
        String string2 = (String)UIDefaultsLookup.get(string, locale);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    protected void addIcon(Container container) {
        Icon icon = this.getIcon();
        if (icon != null) {
            JLabel jLabel = new JLabel(icon);
            jLabel.setName("OptionPane.iconLabel");
            container.add((Component)jLabel, "Before");
        }
    }

    protected Container createBannerArea() {
        PaintPanel paintPanel = new PaintPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.width < BasicJideOptionPaneUI.this.\u0102) {
                    dimension.width = BasicJideOptionPaneUI.this.\u0102;
                }
                return dimension;
            }
        };
        this.customizeBannerArea(paintPanel);
        paintPanel.setLayout(new BorderLayout(10, 10));
        this.addIcon(paintPanel);
        this.\u0101(paintPanel);
        paintPanel.add((Component)new JLabel(UIDefaultsLookup.getIcon("OptionPane.bannerIcon")), "After");
        return paintPanel;
    }

    protected void customizeBannerArea(PaintPanel paintPanel) {
        Object object;
        Paint paint = (Paint)UIDefaultsLookup.get("OptionPane.bannerBackgroundPaint");
        if (paint != null) {
            paintPanel.setBackgroundPaint(paint);
        } else {
            boolean bl;
            object = UIDefaultsLookup.getColor("OptionPane.bannerBackgroundDk");
            Object object2 = UIDefaultsLookup.getColor("OptionPane.bannerBackgroundLt");
            boolean bl2 = bl = UIDefaultsLookup.get("OptionPane.bannerBackgroundDirection") == null || UIDefaultsLookup.getBoolean("OptionPane.bannerBackgroundDirection");
            if (object == null && object2 != null) {
                object = object2;
                paintPanel.setGradientPaint((Color)(object != null ? object : this.getPainter().getOptionPaneBannerLt()), (Color)(object2 != null ? object2 : this.getPainter().getOptionPaneBannerDk()), bl);
            } else if (object != null && object2 == null) {
                object2 = object;
                paintPanel.setGradientPaint((Color)(object != null ? object : this.getPainter().getOptionPaneBannerLt()), (Color)(object2 != null ? object2 : this.getPainter().getOptionPaneBannerDk()), bl);
            } else if (object != null && object2 != null) {
                paintPanel.setGradientPaint((Color)(object != null ? object : this.getPainter().getOptionPaneBannerLt()), (Color)(object2 != null ? object2 : this.getPainter().getOptionPaneBannerDk()), bl);
            }
        }
        object = UIDefaultsLookup.getBorder("OptionPane.bannerBorder");
        paintPanel.setBorder((Border)(object != null ? object : BorderFactory.createEmptyBorder(0, 10, 0, 0)));
    }

    private void \u0101(Container container) {
        Object object;
        if (container == null) {
            return;
        }
        if (this.\u0106 != null) {
            container.remove(this.\u0106);
            this.\u0106 = null;
        }
        Object object2 = object = this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getTitle() : null;
        if (object instanceof String) {
            if (((String)object).startsWith("<html>") || ((String)object).startsWith("<HTML>")) {
                this.\u0106 = new JLabel((String)object);
            } else {
                String[] stringArray = BasicJideOptionPaneUI.\u0101((String)object, UIDefaultsLookup.getInt("OptionPane.bannerMaxCharsPerLine"));
                NullPanel nullPanel = new NullPanel();
                nullPanel.setLayout(new BoxLayout(nullPanel, 1));
                nullPanel.setOpaque(false);
                nullPanel.add(Box.createGlue());
                for (String string : stringArray) {
                    JLabel jLabel = new JLabel(string);
                    jLabel.setFont(jLabel.getFont().deriveFont(UIDefaultsLookup.getInt("OptionPane.bannerFontStyle"), UIDefaultsLookup.getInt("OptionPane.bannerFontSize")));
                    Color color = UIDefaultsLookup.getColor("OptionPane.bannerForeground");
                    jLabel.setForeground(color != null ? color : this.getPainter().getOptionPaneBannerForeground());
                    nullPanel.add(jLabel);
                }
                nullPanel.add(Box.createGlue());
                this.\u0106 = nullPanel;
            }
        } else if (object instanceof Component) {
            this.\u0106 = (Component)object;
        }
        if (this.\u0106 != null) {
            container.add(this.\u0106, "Center");
        }
    }

    private static String[] \u0101(String string, int n2) {
        if (string == null) {
            string = "";
        }
        String string2 = BasicJideOptionPaneUI.\u0101(n2, (byte)32);
        string = BasicJideOptionPaneUI.\u0101(string, "\n", string2);
        string = BasicJideOptionPaneUI.\u0101(string, "\t", "    ");
        ArrayList<String> arrayList = new ArrayList<String>();
        string = string.trim();
        while (string.length() > n2) {
            String string3;
            int n3 = n2;
            if (Character.isLetterOrDigit(string.charAt(n2))) {
                char c2 = string.charAt(--n3);
                while (Character.isLetterOrDigit(c2) && n3 > 0) {
                    c2 = string.charAt(--n3);
                }
                n3 = n3 == 0 && Character.isLetterOrDigit(c2) ? n2 : ++n3;
            }
            if ((string3 = string.substring(0, n3)).length() < n2) {
                string3 = string3 + BasicJideOptionPaneUI.\u0101(n2 - string3.length(), (byte)32);
            }
            arrayList.add(string3);
            string = string.substring(n3).trim();
        }
        if (string.length() < n2) {
            string = string + BasicJideOptionPaneUI.\u0101(n2 - string.length(), (byte)32);
        }
        arrayList.add(string);
        if (arrayList.size() == 1) {
            return new String[]{((String)arrayList.get(0)).trim()};
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String \u0101(int n2, byte by) {
        byte[] byArray = new byte[n2];
        Arrays.fill(byArray, by);
        return new String(byArray);
    }

    private static String \u0101(String string, String string2, String string3) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = 0;
        while ((n2 = BasicJideOptionPaneUI.\u0101(stringBuffer, string2, n3)) >= 0) {
            stringBuffer.replace(n2, n2 + string2.length(), string3);
            n3 = n2 + string3.length();
        }
        return stringBuffer.toString();
    }

    private static int \u0101(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
        if (n6 >= n3) {
            return n5 == 0 ? n3 : -1;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 == 0) {
            return n6;
        }
        char c2 = cArray2[n4];
        int n7 = n2 + n6;
        int n8 = n2 + (n3 - n5);
        block0: while (true) {
            if (n7 <= n8 && cArray[n7] != c2) {
                ++n7;
                continue;
            }
            if (n7 > n8) {
                return -1;
            }
            int n9 = n7 + 1;
            int n10 = n9 + n5 - 1;
            int n11 = n4 + 1;
            while (n9 < n10) {
                if (cArray[n9++] == cArray2[n11++]) continue;
                ++n7;
                continue block0;
            }
            break;
        }
        return n7 - n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int \u0101(StringBuffer stringBuffer, String string, int n2) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int n3 = stringBuffer.length();
            char[] cArray = new char[n3];
            stringBuffer.getChars(0, n3, cArray, 0);
            return BasicJideOptionPaneUI.\u0101(cArray, 0, n3, string.toCharArray(), 0, string.length(), n2);
        }
    }

    public ThemePainter getPainter() {
        return this.\u0104;
    }

    protected static class ButtonFactory {
        private String \u0101;
        private String \u0104;
        private int \u0103;
        private Icon \u0102;

        ButtonFactory(String string, String string2, int n2, Icon icon) {
            this.\u0101 = string;
            this.\u0104 = string2;
            this.\u0103 = n2;
            this.\u0102 = icon;
        }

        JButton \u0101() {
            JButton jButton = new JButton(this.\u0104);
            if (this.\u0101 != null) {
                jButton.setName(this.\u0101);
            }
            if (this.\u0102 != null) {
                jButton.setIcon(this.\u0102);
            }
            if (this.\u0103 != 0) {
                jButton.setMnemonic(this.\u0103);
            }
            return jButton;
        }
    }
}

