/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.list.GroupList;
import com.jidesoft.list.GroupListModel;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.UIAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicListUI;

public class BasicGroupListUI
extends BasicListUI {
    private int \u010a;
    private int \u0109;
    protected Map<Integer, Rectangle> _headerBounds;
    private int \u0111;
    private int \u0110;
    private boolean \u010e = true;
    private Dimension \u010c;
    private List<B> \u0103;
    private List<A> \u0102;
    private int \u010b;
    private boolean \u0112;
    private static final int \u0108 = 128;
    private static final int \u0105 = 256;
    private static final int \u0107 = 512;
    private static final int \u0104 = 1024;
    private static final int \u010f = 0;
    private static final int \u0101 = 1;
    private static final int \u0106 = 2;

    public static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new C("selectPreviousColumn"));
        lazyActionMap.put(new C("selectPreviousColumnExtendSelection"));
        lazyActionMap.put(new C("selectPreviousColumnChangeLead"));
        lazyActionMap.put(new C("selectNextColumn"));
        lazyActionMap.put(new C("selectNextColumnExtendSelection"));
        lazyActionMap.put(new C("selectNextColumnChangeLead"));
        lazyActionMap.put(new C("selectPreviousRow"));
        lazyActionMap.put(new C("selectPreviousRowExtendSelection"));
        lazyActionMap.put(new C("selectPreviousRowChangeLead"));
        lazyActionMap.put(new C("selectNextRow"));
        lazyActionMap.put(new C("selectNextRowExtendSelection"));
        lazyActionMap.put(new C("selectNextRowChangeLead"));
        lazyActionMap.put(new C("selectPreviousGroup"));
        lazyActionMap.put(new C("selectPreviousGroupExtendSelection"));
        lazyActionMap.put(new C("selectPreviousGroupChangeLead"));
        lazyActionMap.put(new C("selectNextGroup"));
        lazyActionMap.put(new C("selectNextGroupExtendSelection"));
        lazyActionMap.put(new C("selectNextGroupChangeLead"));
        lazyActionMap.put(new C("selectFirstRow"));
        lazyActionMap.put(new C("selectFirstRowExtendSelection"));
        lazyActionMap.put(new C("selectFirstRowChangeLead"));
        lazyActionMap.put(new C("selectLastRow"));
        lazyActionMap.put(new C("selectLastRowExtendSelection"));
        lazyActionMap.put(new C("selectLastRowChangeLead"));
        lazyActionMap.put(new C("scrollUp"));
        lazyActionMap.put(new C("scrollUpExtendSelection"));
        lazyActionMap.put(new C("scrollUpChangeLead"));
        lazyActionMap.put(new C("scrollDown"));
        lazyActionMap.put(new C("scrollDownExtendSelection"));
        lazyActionMap.put(new C("scrollDownChangeLead"));
        lazyActionMap.put(new C("selectAll"));
        lazyActionMap.put(new C("clearSelection"));
        lazyActionMap.put(new C("addToSelection"));
        lazyActionMap.put(new C("toggleAndAnchor"));
        lazyActionMap.put(new C("extendTo"));
        lazyActionMap.put(new C("moveSelectionTo"));
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.\u010a = -1;
        this.\u0109 = -1;
        this.\u0103 = null;
        this.\u0102 = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        GroupList groupList = (GroupList)this.list;
        if (groupList.getGroupCellRenderer() == null) {
            ListCellRenderer listCellRenderer = groupList.getCellRenderer();
            if (listCellRenderer == null) {
                groupList.setGroupCellRenderer((ListCellRenderer)UIManager.get("GroupableList.cellRenderer"));
            } else {
                groupList.setGroupCellRenderer(new D(listCellRenderer));
            }
        }
        this.\u0111 = groupList.getLayoutOrientation();
        this.\u010e = groupList.getComponentOrientation().isLeftToRight();
    }

    @Override
    protected void uninstallDefaults() {
        GroupList groupList = (GroupList)this.list;
        if (groupList.getGroupCellRenderer() instanceof UIResource) {
            groupList.setGroupCellRenderer(null);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.list.removePropertyChangeListener(this.propertyChangeListener);
        this.list.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
        this.propertyChangeListener = new PropertyChangeHandler();
        this.listSelectionListener = new ListSelectionHandler();
        this.list.addPropertyChangeListener(this.propertyChangeListener);
        this.list.getSelectionModel().addListSelectionListener(this.listSelectionListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.list.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        switch (this.\u0111) {
            case 1: {
                if (this.list.getHeight() == this.\u010a) break;
                this.updateLayoutStateNeeded |= 0x100;
                this.\u0102();
                break;
            }
            case 2: {
                if (this.list.getWidth() == this.\u0109) break;
                this.updateLayoutStateNeeded |= 0x200;
                this.\u0102();
                break;
            }
        }
        this.maybeUpdateLayoutState();
        GroupList groupList = (GroupList)this.list;
        ListCellRenderer<Object> listCellRenderer = groupList.getCellRenderer();
        ListCellRenderer<Object> listCellRenderer2 = groupList.getGroupCellRenderer();
        GroupListModel groupListModel = groupList.getModel();
        ListSelectionModel listSelectionModel = groupList.getSelectionModel();
        int n2 = groupList.getLeadSelectionIndex();
        int n3 = groupListModel.getSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            ListCellRenderer<Object> listCellRenderer3;
            Rectangle rectangle = this.getCellBounds(groupList, i2);
            ListCellRenderer<Object> listCellRenderer4 = listCellRenderer3 = groupListModel.isGroupRow(i2) ? listCellRenderer2 : listCellRenderer;
            if (listCellRenderer3 == null) continue;
            this.paintCell(graphics, i2, rectangle, listCellRenderer3, groupListModel, listSelectionModel, n2);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        this.maybeUpdateLayoutState();
        return this.\u010c;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicGroupListUI();
    }

    public int locationToIndex(JList jList, Point point) {
        this.maybeUpdateLayoutState();
        return this.\u0103(point.x, point.y);
    }

    public int locationToRow(JList jList, Point point) {
        return this.\u0101(this.locationToIndex(jList, point));
    }

    public Point indexToLocation(JList jList, int n2) {
        this.maybeUpdateLayoutState();
        Rectangle rectangle = this.getCellBounds(jList, n2);
        if (rectangle != null) {
            return new Point(rectangle.x, rectangle.y);
        }
        return null;
    }

    public Rectangle getCellBounds(JList jList, int n2, int n3) {
        this.maybeUpdateLayoutState();
        int n4 = Math.min(jList.getModel().getSize() - 1, Math.min(n2, n3));
        int n5 = Math.min(jList.getModel().getSize() - 1, Math.max(n2, n3));
        if (n4 >= jList.getModel().getSize()) {
            return null;
        }
        Rectangle rectangle = this.getCellBounds(jList, n4);
        if (rectangle == null) {
            return null;
        }
        if (n4 == n5) {
            return rectangle;
        }
        Rectangle rectangle2 = this.getCellBounds(jList, n5);
        if (rectangle2 != null) {
            if (this.\u0111 == 2 || this.\u0111 == 3) {
                int n6;
                int n7 = this.\u0101(n4);
                if (n7 != (n6 = this.\u0101(n5))) {
                    rectangle.x = 0;
                    rectangle.width = jList.getWidth();
                }
            } else if (this.\u0111 == 1) {
                rectangle.setBounds(0, 0, jList.getWidth(), jList.getHeight());
            } else if (rectangle.x != rectangle2.x) {
                rectangle.y = 0;
                rectangle.height = jList.getHeight();
            }
            rectangle.add(rectangle2);
        }
        return rectangle;
    }

    public Rectangle getCellBounds(JList jList, int n2) {
        this.maybeUpdateLayoutState();
        Rectangle rectangle = new Rectangle();
        if (n2 == -1) {
            return new Rectangle();
        }
        Insets insets = jList.getInsets();
        GroupListModel groupListModel = ((GroupList)jList).getModel();
        if (groupListModel.isGroupRow(n2)) {
            rectangle.setBounds(this._headerBounds.get(n2));
            rectangle.x = insets.left;
            rectangle.width = jList.getWidth() - insets.left - insets.right;
            return rectangle;
        }
        int n3 = groupListModel.getGroupRowIndex(n2);
        assert (n3 == -1 || groupListModel.isGroupRow(n3));
        Rectangle rectangle2 = this._headerBounds.get(n3);
        if (rectangle2 == null) {
            assert (n3 == -1);
            rectangle2 = new Rectangle();
        }
        rectangle.y = rectangle2.y + rectangle2.height;
        ++n3;
        switch (this.\u0111) {
            case 0: {
                for (int i2 = n3; i2 < n2; ++i2) {
                    rectangle.y = rectangle.y + (this.cellHeights != null ? this.cellHeights[i2] : this.cellHeight);
                }
                rectangle.y += insets.top;
                rectangle.x = insets.left;
                rectangle.width = jList.getWidth() - insets.left - insets.right;
                rectangle.height = this.cellHeights != null ? this.cellHeights[n2] : this.cellHeight;
                break;
            }
            case 1: 
            case 2: {
                int n4;
                int n5 = n2 - n3;
                int n6 = 0;
                if (this.\u0111 == 1) {
                    n4 = groupListModel.getNextGroupRowIndex(n2) - n3;
                    n6 = (n4 + this.\u0110 - 1) / this.\u0110;
                }
                n4 = this.\u0111 == 1 ? n5 / n6 : n5 % this.\u0110;
                int n7 = this.\u0111 == 1 ? n5 % n6 : n5 / this.\u0110;
                rectangle.x = this.\u010e ? insets.left : jList.getWidth() - insets.right - this.cellWidth;
                rectangle.y += insets.top;
                rectangle.x = this.\u010e ? (rectangle.x += n4 * this.cellWidth) : (rectangle.x -= n4 * this.cellWidth);
                rectangle.y += n7 * this.cellHeight;
                rectangle.width = this.cellWidth;
                rectangle.height = this.cellHeight;
                break;
            }
            case 3: {
                int n8 = n2 - n3;
                rectangle.x = this.\u010e ? insets.left : jList.getWidth() - insets.right - this.cellWidth;
                rectangle.y += insets.top;
                rectangle.x = this.\u010e ? (rectangle.x += n8 * this.cellWidth) : (rectangle.x -= n8 * this.cellWidth);
                rectangle.width = this.cellWidth;
                rectangle.height = this.cellHeight;
            }
        }
        return rectangle;
    }

    private int \u0101(int n2, int n3, boolean bl) {
        Insets insets = this.list.getInsets();
        for (int i2 = this.\u0103.size() - 1; i2 >= 0; --i2) {
            int n4;
            B b2 = this.\u0103.get(i2);
            int n5 = b2.\u0101.y + insets.top;
            int n6 = n4 = this.cellHeights != null ? this.cellHeights[b2.\u0102] : this.cellHeight;
            if (n3 < n5) continue;
            if (bl || n3 < n5 + n4) {
                return i2;
            }
            return -1;
        }
        return bl ? 0 : -1;
    }

    private int \u0101(int n2, int n3) {
        Insets insets = this.list.getInsets();
        if (n3 >= 0 && n3 < this.\u0103.size()) {
            B b2 = this.\u0103.get(n3);
            for (int i2 = b2.\u0103 - 1; i2 >= 0; --i2) {
                if (!(this.\u010e ? n2 >= insets.left + i2 * this.cellWidth : n2 <= this.list.getWidth() - insets.right - i2 * this.cellWidth)) continue;
                return i2;
            }
            return 0;
        }
        return -1;
    }

    private int \u0103(int n2, int n3) {
        int n4 = this.\u0101(n2, n3, true);
        int n5 = this.\u0101(n2, n4);
        if (n4 >= 0 && n5 >= 0) {
            return this.\u0102(n5, n4);
        }
        return -1;
    }

    public int getRowCount() {
        if (this.\u0111 == 0) {
            return this.list.getModel().getSize();
        }
        return this.\u0103 != null ? this.\u0103.size() : 0;
    }

    public int getColumnCount(int n2) {
        if (this.\u0111 == 0) {
            return 1;
        }
        return this.\u0103 != null ? this.\u0103.get((int)n2).\u0103 : 0;
    }

    private int \u0102(int n2, int n3) {
        switch (this.\u0111) {
            case 1: {
                B b2 = this.\u0103.get(n3);
                int n4 = b2.\u0102;
                GroupListModel groupListModel = (GroupListModel)this.list.getModel();
                if (groupListModel.isGroupRow(n4)) {
                    assert (n2 == 0);
                    return n4;
                }
                int n5 = groupListModel.getGroupRowIndex(n4);
                int n6 = groupListModel.getNextGroupRowIndex(n4) - n5;
                int n7 = n6 - 1;
                int n8 = (n7 + this.\u0110 - 1) / this.\u0110;
                return n4 + n8 * n2;
            }
            case 2: 
            case 3: {
                B b3 = this.\u0103.get(n3);
                return b3.\u0102 + Math.min(n2, b3.\u0103 - 1);
            }
        }
        return n3;
    }

    private int \u0101(int n2) {
        GroupListModel groupListModel = (GroupListModel)this.list.getModel();
        int n3 = groupListModel.getSize();
        if (n2 < 0 || n2 >= n3) {
            return -1;
        }
        if (this.\u0111 == 2 || this.\u0111 == 3) {
            for (int i2 = this.\u0103.size() - 1; i2 >= 0; --i2) {
                if (this.\u0103.get((int)i2).\u0102 > n2) continue;
                return i2;
            }
        } else if (this.\u0111 == 1) {
            int n4;
            int n5 = groupListModel.getGroupRowIndex(n2);
            int n6 = -1;
            for (n4 = 0; n4 < this.\u0103.size(); ++n4) {
                B b2 = this.\u0103.get(n4);
                if (b2.\u0102 != n5) continue;
                assert (b2.\u0103 == 1);
                n6 = n4;
                break;
            }
            assert (n6 != -1);
            n4 = n2 - (n5 + 1);
            int n7 = groupListModel.getNextGroupRowIndex(n2) - (n5 + 1);
            int n8 = (n7 + this.\u0110 - 1) / this.\u0110;
            return n6 + 1 + n4 % n8;
        }
        return n2;
    }

    private int \u0102(int n2) {
        GroupListModel groupListModel = (GroupListModel)this.list.getModel();
        int n3 = groupListModel.getSize();
        if (n2 < 0 || n2 >= n3) {
            return -1;
        }
        if (this.\u0111 == 2 || this.\u0111 == 3) {
            for (int i2 = this.\u0103.size() - 1; i2 >= 0; --i2) {
                int n4 = this.\u0103.get((int)i2).\u0102;
                if (n4 > n2) continue;
                return n2 - n4;
            }
        } else if (this.\u0111 == 1) {
            int n5 = groupListModel.getGroupRowIndex(n2);
            int n6 = n2 - (n5 + 1);
            int n7 = groupListModel.getNextGroupRowIndex(n2) - (n5 + 1);
            int n8 = (n7 + this.\u0110 - 1) / this.\u0110;
            return n6 / n8;
        }
        return 0;
    }

    @Override
    protected void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    @Override
    protected void updateLayoutState() {
        int n2 = this.list.getFixedCellHeight();
        int n3 = this.list.getFixedCellWidth();
        int n4 = this.cellWidth = n3 != -1 ? n3 : -1;
        if (n2 != -1) {
            this.cellHeight = n2;
            this.cellHeights = null;
        } else {
            this.cellHeight = -1;
            this.cellHeights = new int[this.list.getModel().getSize()];
        }
        if (n3 == -1 || n2 == -1) {
            GroupListModel groupListModel = (GroupListModel)this.list.getModel();
            int n5 = groupListModel.getSize();
            ListCellRenderer listCellRenderer = this.list.getCellRenderer();
            ListCellRenderer listCellRenderer2 = ((GroupList)this.list).getGroupCellRenderer();
            for (int i2 = 0; i2 < n5; ++i2) {
                Object e2 = groupListModel.getElementAt(i2);
                Component component = new JPanel();
                if (!groupListModel.isGroupRow(i2)) {
                    component = listCellRenderer.getListCellRendererComponent(this.list, e2, i2, false, false);
                    Dimension dimension = component.getPreferredSize();
                    if (n3 == -1) {
                        this.cellWidth = Math.max(dimension.width, this.cellWidth);
                    }
                    if (n2 == -1) {
                        this.cellHeights[i2] = dimension.height;
                    }
                } else {
                    component = listCellRenderer2.getListCellRendererComponent(this.list, e2, i2, false, false);
                }
                this.rendererPane.add(component);
            }
        }
        this.updateCellLayoutState(n3, n2);
        this.updateGroupLayoutState(n3, n2);
        this.\u010b = this.\u0102(this.list.getSelectedIndex());
    }

    protected void updateGroupLayoutState(int n2, int n3) {
        Object object;
        this.\u0101();
        ListCellRenderer listCellRenderer = ((GroupList)this.list).getGroupCellRenderer();
        int n4 = 0;
        int n5 = 0;
        GroupListModel groupListModel = ((GroupList)this.list).getModel();
        int n6 = groupListModel.getSize();
        while (n5 < n6) {
            Object object2;
            if (groupListModel.isGroupRow(n5)) {
                object = new B(n5);
                ((B)object).\u0101 = new Point(0, n4);
                this.\u0103.add((B)object);
                this.\u0102.add((A)object);
                object2 = listCellRenderer.getListCellRendererComponent(this.list, groupListModel.getElementAt(n5), n5, false, false);
                Dimension dimension = ((Component)object2).getPreferredSize();
                Rectangle rectangle = new Rectangle(0, n4, dimension.width, dimension.height);
                this._headerBounds.put(n5, rectangle);
                n4 += dimension.height;
                this.\u010c.width = Math.max(this.\u010c.width, dimension.width);
                this.\u010c.height += dimension.height;
            }
            ++n5;
            switch (this.\u0111) {
                case 0: {
                    int n7 = 0;
                    while (n5 < n6 && !groupListModel.isGroupRow(n5)) {
                        object2 = new B(n5);
                        ((B)object2).\u0101 = new Point(0, n4 + n7);
                        this.\u0103.add((B)object2);
                        n7 += this.cellHeights != null ? this.cellHeights[n5] : this.cellHeight;
                        ++n5;
                    }
                    n4 += n7;
                    this.\u010c.height += n7;
                    break;
                }
                case 1: 
                case 2: {
                    int n8;
                    int n9;
                    int n10 = 0;
                    int n11 = n5;
                    while (n5 < n6 && !groupListModel.isGroupRow(n5)) {
                        ++n5;
                    }
                    int n12 = n5 - n11;
                    int n13 = (n12 + this.\u0110 - 1) / this.\u0110;
                    if (this.\u0111 == 2) {
                        B b2;
                        n9 = 0;
                        n8 = n11;
                        while (n8 + this.\u0110 < n5) {
                            b2 = new B(n8, this.\u0110);
                            b2.\u0101 = new Point(0, n4 + n9 * this.cellHeight);
                            this.\u0103.add(b2);
                            n8 += this.\u0110;
                            ++n9;
                        }
                        b2 = new B(n8, n5 - n8);
                        assert (n9 == n13 - 1);
                        b2.\u0101 = new Point(0, n4 + n9 * this.cellHeight);
                        this.\u0103.add(b2);
                    } else {
                        assert (this.\u0111 == 1);
                        n8 = n12 % n13;
                        n9 = (n12 + n13 - 1) / n13;
                        for (int i2 = 0; i2 < n13; ++i2) {
                            int n14 = n8 == 0 || i2 < n8 ? n9 : n9 - 1;
                            B b3 = new B(n11 + i2, n14);
                            b3.\u0101 = new Point(0, n4 + i2 * this.cellHeight);
                            this.\u0103.add(b3);
                        }
                    }
                    n4 += (n10 += n13 * this.cellHeight);
                    this.\u010c.height += n10;
                    this.\u010c.width = Math.max(this.\u010c.width, this.\u0110 * this.cellWidth);
                    break;
                }
                case 3: {
                    int n15 = 0;
                    int n16 = n5;
                    while (n5 < n6 && !groupListModel.isGroupRow(n5)) {
                        ++n5;
                    }
                    int n17 = n5 - n16;
                    int n18 = 1;
                    B b4 = new B(n16, n17);
                    b4.\u0101 = new Point(0, n4);
                    this.\u0103.add(b4);
                    n15 = n18 * this.cellHeight;
                    n4 += n15;
                    this.\u010c.height += n15;
                    this.\u010c.width = Math.max(this.\u010c.width, n17 * this.cellWidth);
                }
            }
        }
        object = this.list.getInsets();
        this.\u010c.width += ((Insets)object).left + ((Insets)object).right;
        this.\u010c.height += ((Insets)object).top + ((Insets)object).bottom;
    }

    protected void updateCellLayoutState(int n2, int n3) {
        GroupListModel groupListModel = (GroupListModel)this.list.getModel();
        int n4 = groupListModel.getSize();
        this.\u010a = this.list.getHeight();
        this.\u0109 = this.list.getWidth();
        if (n4 == 0) {
            this.\u0110 = 0;
            return;
        }
        if (this.\u0111 != 0) {
            if (n3 > 0) {
                this.cellHeight = n3;
            } else {
                this.cellHeight = 0;
                for (int i2 = 0; i2 < this.cellHeights.length; ++i2) {
                    this.cellHeight = Math.max(this.cellHeight, this.cellHeights[i2]);
                }
                this.cellHeights = null;
            }
        }
        switch (this.\u0111) {
            case 0: {
                this.\u0110 = 1;
                break;
            }
            case 1: 
            case 2: {
                this.\u0110 = ((GroupList)this.list).getPreferredColumnCount();
                break;
            }
            case 3: {
                this.\u0110 = Integer.MAX_VALUE;
            }
        }
    }

    private void \u0102() {
        this.list.revalidate();
        this.list.repaint();
    }

    private void \u0101() {
        if (this.\u010c == null) {
            this.\u010c = new Dimension();
        } else {
            this.\u010c.setSize(0, 0);
        }
        if (this._headerBounds == null) {
            this._headerBounds = new LinkedHashMap<Integer, Rectangle>();
        } else {
            this._headerBounds.clear();
        }
        if (this.\u0103 == null) {
            this.\u0103 = new ArrayList<B>();
        } else {
            this.\u0103.clear();
        }
        if (this.\u0102 == null) {
            this.\u0102 = new ArrayList<A>();
        } else {
            this.\u0102.clear();
        }
    }

    @Override
    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.list, 0, inputMap);
        InputMap inputMap2 = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.list, 1, inputMap2);
        LazyActionMap.installLazyActionMap(this.list, BasicGroupListUI.class, "GroupList.actionMap");
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)UIManager.get("GroupList.ancestorInputMap");
            if (inputMap2 == null) {
                inputMap2 = new InputMap();
            }
            inputMap2.setParent((InputMap)UIManager.get("List.focusInputMap"));
            if (this.list.getComponentOrientation().isLeftToRight()) {
                return inputMap2;
            }
            InputMap inputMap3 = (InputMap)UIManager.get("GroupList.ancestorInputMap.RightToLeft");
            if (inputMap3 == null) {
                inputMap3 = new InputMap();
            }
            if ((inputMap = (InputMap)UIManager.get("List.focusInputMap.RightToLeft")) == null) {
                inputMap = new InputMap();
            }
            inputMap3.setParent(inputMap);
            inputMap.setParent(inputMap2);
            return inputMap3;
        }
        if (n2 == 0) {
            InputMap inputMap;
            InputMap inputMap4 = (InputMap)UIManager.get("List.focusInputMap");
            if (this.\u010e || (inputMap = (InputMap)UIManager.get("List.focusInputMap.RightToLeft")) == null) {
                return inputMap4;
            }
            inputMap.setParent(inputMap4);
            return inputMap;
        }
        return null;
    }

    @Override
    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.list, null);
        SwingUtilities.replaceUIInputMap(this.list, 0, null);
        SwingUtilities.replaceUIInputMap(this.list, 1, null);
    }

    static /* synthetic */ int \u010c(BasicGroupListUI basicGroupListUI) {
        return basicGroupListUI.updateLayoutStateNeeded;
    }

    static /* synthetic */ int \u0106(BasicGroupListUI basicGroupListUI) {
        return basicGroupListUI.updateLayoutStateNeeded;
    }

    static /* synthetic */ int \u0103(BasicGroupListUI basicGroupListUI) {
        return basicGroupListUI.updateLayoutStateNeeded;
    }

    static {
        UIManager.put("GroupableList.headerRenderer", new D());
    }

    private static class C
    extends UIAction {
        private static final String \u0119 = "selectPreviousColumn";
        private static final String \u011f = "selectPreviousColumnExtendSelection";
        private static final String \u010f = "selectPreviousColumnChangeLead";
        private static final String \u0125 = "selectNextColumn";
        private static final String \u011b = "selectNextColumnExtendSelection";
        private static final String \u0107 = "selectNextColumnChangeLead";
        private static final String \u0123 = "selectPreviousRow";
        private static final String \u0120 = "selectPreviousRowExtendSelection";
        private static final String \u0113 = "selectPreviousRowChangeLead";
        private static final String \u0106 = "selectNextRow";
        private static final String \u011a = "selectNextRowExtendSelection";
        private static final String \u0115 = "selectNextRowChangeLead";
        private static final String \u011d = "selectFirstRow";
        private static final String \u0121 = "selectFirstRowExtendSelection";
        private static final String \u011e = "selectFirstRowChangeLead";
        private static final String \u0112 = "selectLastRow";
        private static final String \u0124 = "selectLastRowExtendSelection";
        private static final String \u0104 = "selectLastRowChangeLead";
        private static final String \u0114 = "selectPreviousGroup";
        private static final String \u0102 = "selectPreviousGroupExtendSelection";
        private static final String \u0110 = "selectPreviousGroupChangeLead";
        private static final String \u0111 = "selectNextGroup";
        private static final String \u0118 = "selectNextGroupExtendSelection";
        private static final String \u0122 = "selectNextGroupChangeLead";
        private static final String \u010b = "scrollUp";
        private static final String \u0109 = "scrollUpExtendSelection";
        private static final String \u0117 = "scrollUpChangeLead";
        private static final String \u0105 = "scrollDown";
        private static final String \u0116 = "scrollDownExtendSelection";
        private static final String \u010c = "scrollDownChangeLead";
        private static final String \u0103 = "selectAll";
        private static final String \u0126 = "clearSelection";
        private static final String \u010a = "addToSelection";
        private static final String \u0108 = "toggleAndAnchor";
        private static final String \u010d = "extendTo";
        private static final String \u010e = "moveSelectionTo";

        C(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            GroupList groupList = (GroupList)actionEvent.getSource();
            BasicGroupListUI basicGroupListUI = (BasicGroupListUI)groupList.getUI();
            if (string == \u0119) {
                this.\u0101(groupList, 1, this.\u0102(groupList, basicGroupListUI, -1), true);
            } else if (string == \u011f) {
                this.\u0101(groupList, 2, this.\u0102(groupList, basicGroupListUI, -1), true);
            } else if (string == \u010f) {
                this.\u0101(groupList, 0, this.\u0102(groupList, basicGroupListUI, -1), true);
            } else if (string == \u0125) {
                this.\u0101(groupList, 1, this.\u0102(groupList, basicGroupListUI, 1), true);
            } else if (string == \u011b) {
                this.\u0101(groupList, 2, this.\u0102(groupList, basicGroupListUI, 1), true);
            } else if (string == \u0107) {
                this.\u0101(groupList, 0, this.\u0102(groupList, basicGroupListUI, 1), true);
            } else if (string == \u0123) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 1, this.\u0103(groupList, basicGroupListUI, -1), true);
            } else if (string == \u0120) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 2, this.\u0103(groupList, basicGroupListUI, -1), true);
            } else if (string == \u0113) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 0, this.\u0103(groupList, basicGroupListUI, -1), true);
            } else if (string == \u0106) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 1, this.\u0103(groupList, basicGroupListUI, 1), true);
            } else if (string == \u011a) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 2, this.\u0103(groupList, basicGroupListUI, 1), true);
            } else if (string == \u0115) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 0, this.\u0103(groupList, basicGroupListUI, 1), true);
            } else if (string == \u011d) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 1, 0, true);
            } else if (string == \u0121) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 2, 0, true);
            } else if (string == \u011e) {
                this.\u0101(groupList, 0, 0, true);
            } else if (string == \u0112) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 1, groupList.getModel().getSize() - 1, true);
            } else if (string == \u0124) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 2, groupList.getModel().getSize() - 1, true);
            } else if (string == \u0104) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 0, groupList.getModel().getSize() - 1, true);
            } else if (string == \u0114) {
                this.\u0101(groupList, 1, this.\u0101(groupList, basicGroupListUI, -1), true);
            } else if (string == \u0111) {
                this.\u0101(groupList, 1, this.\u0101(groupList, basicGroupListUI, 1), true);
            } else if (string == \u010b) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 1, true);
            } else if (string == \u0109) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 2, true);
            } else if (string == \u0117) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 0, true);
            } else if (string == \u0105) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 1, false);
            } else if (string == \u0116) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 2, false);
            } else if (string == \u010c) {
                basicGroupListUI.\u0112 = true;
                this.\u0101(groupList, 0, false);
            } else if (string == \u0103) {
                this.\u0101(groupList);
            } else if (string == \u0126) {
                this.\u0102(groupList);
            } else if (string == \u010a) {
                int n2 = groupList.getSelectionModel().getLeadSelectionIndex();
                if (!groupList.isSelectedIndex(n2)) {
                    int n3 = groupList.getSelectionModel().getAnchorSelectionIndex();
                    groupList.setValueIsAdjusting(true);
                    groupList.addSelectionInterval(n2, n2);
                    groupList.getSelectionModel().setAnchorSelectionIndex(n3);
                    groupList.setValueIsAdjusting(false);
                }
            } else if (string == \u0108) {
                int n4 = groupList.getSelectionModel().getLeadSelectionIndex();
                if (groupList.isSelectedIndex(n4)) {
                    groupList.removeSelectionInterval(n4, n4);
                } else {
                    groupList.addSelectionInterval(n4, n4);
                }
            } else if (string == \u010d) {
                this.\u0101(groupList, 2, groupList.getSelectionModel().getLeadSelectionIndex(), false);
            } else if (string == \u010e) {
                this.\u0101(groupList, 1, groupList.getSelectionModel().getLeadSelectionIndex(), false);
            }
            basicGroupListUI.\u0112 = false;
        }

        @Override
        public boolean isEnabled(Object object) {
            String string = this.getName();
            if (string == \u010f || string == \u0107 || string == \u0113 || string == \u0115 || string == \u011e || string == \u0104 || string == \u0117 || string == \u010c) {
                return object != null && ((JList)object).getSelectionModel() instanceof DefaultListSelectionModel;
            }
            return true;
        }

        private void \u0102(JList jList) {
            jList.clearSelection();
        }

        private void \u0101(JList jList) {
            int n2 = jList.getModel().getSize();
            if (n2 > 0) {
                ListSelectionModel listSelectionModel = jList.getSelectionModel();
                if (listSelectionModel.getSelectionMode() == 0) {
                    int n3 = jList.getLeadSelectionIndex();
                    if (n3 != -1) {
                        jList.setSelectionInterval(n3, n3);
                    } else if (jList.getMinSelectionIndex() == -1) {
                        jList.setSelectionInterval(0, 0);
                        jList.ensureIndexIsVisible(0);
                    }
                } else {
                    jList.setValueIsAdjusting(true);
                    int n4 = listSelectionModel.getAnchorSelectionIndex();
                    int n5 = listSelectionModel.getLeadSelectionIndex();
                    jList.setSelectionInterval(0, n2 - 1);
                    jList.addSelectionInterval(n4, n5);
                    jList.setValueIsAdjusting(false);
                }
            }
        }

        private void \u0101(GroupList groupList, int n2, boolean bl) {
            int n3 = this.\u0101(groupList, bl);
            if (n3 != -1) {
                this.\u0101(groupList, n2, n3, true);
            }
        }

        private int \u0101(GroupList groupList, int n2, int n3) {
            BasicGroupListUI basicGroupListUI = (BasicGroupListUI)groupList.getUI();
            GroupListModel groupListModel = groupList.getModel();
            int n4 = n3 - n2 > 0 ? 1 : -1;
            int n5 = basicGroupListUI.\u0101(n2);
            int n6 = basicGroupListUI.\u0101(n3);
            int n7 = n3;
            switch (groupList.getLayoutOrientation()) {
                default: 
            }
            int n8 = basicGroupListUI.\u0101(n7);
            if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n7)) {
                n8 -= n4;
            }
            if (0 <= n8 && n8 < basicGroupListUI.\u0103.size()) {
                B b2 = (B)basicGroupListUI.\u0103.get(n8);
                n7 = basicGroupListUI.\u0102(Math.min(b2.\u0103 - 1, basicGroupListUI.\u010b), n8);
                if (n5 <= n8 && n8 <= n6 || n6 <= n8 && n8 <= n5) {
                    return n7;
                }
            }
            n7 = n3;
            n8 = groupListModel.getSize();
            switch (groupList.getLayoutOrientation()) {
                default: 
            }
            int n9 = basicGroupListUI.\u0101(n7);
            if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n7)) {
                n9 += n4;
            }
            if (0 <= n9 && n9 < basicGroupListUI.\u0103.size()) {
                B b3 = (B)basicGroupListUI.\u0103.get(n5);
                n7 = basicGroupListUI.\u0102(Math.min(b3.\u0103 - 1, basicGroupListUI.\u010b), n5);
                if (0 <= n9 && n9 <= n6 || n6 <= n9 && n9 < basicGroupListUI.\u0103.size()) {
                    return n7;
                }
            }
            return n3;
        }

        private int \u0101(GroupList groupList, boolean bl) {
            BasicGroupListUI basicGroupListUI = (BasicGroupListUI)groupList.getUI();
            if (bl) {
                int n2 = groupList.getFirstVisibleIndex();
                int n3 = basicGroupListUI.\u0101(n2);
                ListSelectionModel listSelectionModel = groupList.getSelectionModel();
                int n4 = listSelectionModel.getLeadSelectionIndex();
                int n5 = basicGroupListUI.\u0101(n4);
                if (n5 == n3) {
                    Rectangle rectangle = groupList.getVisibleRect();
                    rectangle.y = Math.max(0, rectangle.y - rectangle.height);
                    int n6 = groupList.locationToIndex(rectangle.getLocation());
                    n2 = this.\u0101(groupList, n2, n6);
                } else {
                    n2 = this.\u0101(groupList, n4, n2);
                }
                return n2;
            }
            int n7 = groupList.getLastVisibleIndex();
            ListSelectionModel listSelectionModel = groupList.getSelectionModel();
            if (n7 == -1) {
                n7 = groupList.getModel().getSize() - 1;
            }
            int n8 = basicGroupListUI.\u0101(n7);
            int n9 = listSelectionModel.getLeadSelectionIndex();
            int n10 = basicGroupListUI.\u0101(n9);
            if (n10 == n8) {
                Rectangle rectangle = groupList.getVisibleRect();
                rectangle.y += rectangle.height + rectangle.height - 1;
                int n11 = groupList.locationToIndex(rectangle.getLocation());
                if (n11 == -1) {
                    n11 = groupList.getModel().getSize() - 1;
                }
                n7 = this.\u0101(groupList, n7, n11);
            } else {
                n7 = this.\u0101(groupList, n9, n7);
            }
            return n7;
        }

        private void \u0101(JList jList, int n2, int n3, boolean bl) {
            if (n3 >= 0 && n3 < jList.getModel().getSize()) {
                int n4;
                ListSelectionModel listSelectionModel = jList.getSelectionModel();
                if (n2 == 0 && jList.getSelectionMode() != 2) {
                    n2 = 1;
                }
                if (n2 == 2) {
                    int n5 = jList.getSelectedIndex();
                    int n6 = listSelectionModel.getAnchorSelectionIndex();
                    if (n6 == -1) {
                        n6 = n3;
                    }
                    jList.setSelectionInterval(n6, n3);
                    n4 = this.\u0101(jList, n5, n3);
                } else if (n2 == 1) {
                    int n7 = jList.getSelectedIndex();
                    jList.setSelectedIndex(n3);
                    n4 = this.\u0101(jList, n7, n3);
                } else {
                    int n8 = jList.getSelectedIndex();
                    ((DefaultListSelectionModel)listSelectionModel).moveLeadSelectionIndex(n3);
                    n4 = this.\u0101(jList, n8, n3);
                }
                if (bl) {
                    jList.ensureIndexIsVisible(n4);
                }
            }
        }

        private int \u0102(GroupList groupList, BasicGroupListUI basicGroupListUI, int n2) {
            int n3;
            int n4 = groupList.getLeadSelectionIndex();
            GroupListModel groupListModel = groupList.getModel();
            int n5 = groupListModel.getSize();
            int n6 = basicGroupListUI.\u0103.size();
            int n7 = n3 = n2 > 0 ? 1 : -1;
            if (basicGroupListUI == null || n5 == 0) {
                return -1;
            }
            if (n5 == 1) {
                return 0;
            }
            if (n4 == -1) {
                return 0;
            }
            int n8 = basicGroupListUI.\u0102(n4);
            int n9 = basicGroupListUI.\u0101(n4);
            B b2 = (B)basicGroupListUI.\u0103.get(n9);
            int n10 = -2;
            while (n2 != 0) {
                B b3 = b2;
                int n11 = n8 + n2;
                if (0 <= n11 && n11 < b3.\u0103) {
                    n8 = n11;
                    n4 = basicGroupListUI.\u0102(n8, n9);
                    break;
                }
                if (0 > (n9 += n3) || n9 >= n6) break;
                b2 = (B)basicGroupListUI.\u0103.get(n9);
                int n12 = n8;
                n8 = n3 > 0 ? 0 : b2.\u0103 - 1;
                n10 = basicGroupListUI.\u0102(n8, n9);
                if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n10)) continue;
                assert (n10 != -2);
                n4 = n10;
                if (n3 > 0) {
                    n2 -= b3.\u0103 - n12;
                    continue;
                }
                n2 += n12 + 1;
            }
            return n4;
        }

        private int \u0103(GroupList groupList, BasicGroupListUI basicGroupListUI, int n2) {
            int n3;
            block3: {
                int n4;
                int n5;
                GroupListModel groupListModel;
                block5: {
                    int n6;
                    block4: {
                        groupListModel = groupList.getModel();
                        n5 = groupListModel.getSize();
                        n4 = n2 > 0 ? 1 : -1;
                        n6 = groupList.getLayoutOrientation();
                        if (n3 != -1) break block4;
                        if (n5 <= 0 || groupList.isGroupCellSelectable()) break block3;
                        for (n3 = groupList.getLeadSelectionIndex(); 0 <= n3 && n3 < n5 && groupListModel.isGroupRow(n3); n3 += n4) {
                        }
                        if (n3 < n5) break block3;
                        n3 = -1;
                        break block3;
                    }
                    if (n6 != 2 && n6 != 3) break block5;
                    if (basicGroupListUI == null) break block3;
                    int n7 = basicGroupListUI.\u0101(n3);
                    int n8 = basicGroupListUI.\u0103.size();
                    while (0 <= (n7 += n4) && n7 < n8) {
                        int n9 = ((B)((BasicGroupListUI)basicGroupListUI).\u0103.get((int)n7)).\u0103;
                        int n10 = Math.min(basicGroupListUI.\u010b, n9 - 1);
                        int n11 = basicGroupListUI.\u0102(n10, n7);
                        if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n11)) continue;
                        n3 = n11;
                        if ((n2 -= n4) != 0) continue;
                        break block3;
                    }
                    break block3;
                }
                int n12 = n3;
                while (0 <= (n12 += n4) && n12 < n5) {
                    if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n12)) continue;
                    n3 = n12;
                    if ((n2 -= n4) != 0) continue;
                    break;
                }
            }
            return n3;
        }

        private int \u0101(GroupList groupList, BasicGroupListUI basicGroupListUI, int n2) {
            int n3;
            int n4 = groupList.getLeadSelectionIndex();
            GroupListModel groupListModel = groupList.getModel();
            int n5 = groupListModel.getSize();
            boolean bl = groupList.isGroupCellSelectable();
            int n6 = n3 = n2 > 0 ? 1 : -1;
            while (n2 != 0) {
                int n7;
                int n8 = n7 = n3 > 0 ? groupListModel.getNextGroupRowIndex(n4) : groupListModel.getGroupRowIndex(n4);
                boolean bl2 = false;
                if (n3 > 0 && n8 == n5 || n3 < 0 && n8 == 0) {
                    bl2 = true;
                }
                if (!bl) {
                    int n9;
                    int n10 = n9 = n3 > 0 ? n5 - 1 : n4;
                    while (++n8 < n9 && groupListModel.isGroupRow(n8)) {
                    }
                }
                if (bl2) {
                    n4 = n8;
                    break;
                }
                if (n4 == n8) {
                    assert (n3 == -1);
                    if (n7 > 0) {
                        n7 = groupListModel.getGroupRowIndex(n7 - 1);
                    }
                    n8 = n7;
                    if (!bl) {
                        while (++n8 < n4 && groupListModel.isGroupRow(n8)) {
                        }
                    }
                }
                n4 = n8;
                n2 -= n3;
            }
            return n4;
        }

        private int \u0101(JList jList, int n2, int n3) {
            int n4 = n3;
            if (n2 == n3) {
                if (jList.getLayoutOrientation() == 0) {
                    n4 = Math.max(0, n3 - 1);
                } else {
                    BasicGroupListUI basicGroupListUI = (BasicGroupListUI)jList.getUI();
                    int n5 = basicGroupListUI.\u0101(n3);
                    if (n5 > 0) {
                        --n5;
                    }
                    n4 = basicGroupListUI.\u0102(0, n5);
                }
            }
            return n4;
        }
    }

    private static class A {
        int \u0103;
        int \u0102;
        Point \u0101;

        A(int n2, int n3) {
            this.\u0102 = n2;
            this.\u0103 = n3;
        }

        A(int n2) {
            this(n2, 1);
        }

        public String toString() {
            return String.format("%s(start: %d, size: %d)", this.getClass().getSimpleName(), this.\u0102, this.\u0103);
        }
    }

    private static class B
    extends A {
        B(int n2, int n3) {
            super(n2, n3);
        }

        B(int n2) {
            this(n2, 1);
        }
    }

    private static class D
    implements ListCellRenderer,
    UIResource {
        private ListCellRenderer \u0101;

        public D(ListCellRenderer listCellRenderer) {
            this.\u0101 = listCellRenderer;
        }

        public D() {
            this(new DefaultListCellRenderer());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            Component component = this.\u0101.getListCellRendererComponent(jList, object, n2, true, true);
            if (object != null) {
                ((JComponent)component).setToolTipText(String.valueOf(object));
            }
            return component;
        }
    }

    public class PropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        public PropertyChangeHandler() {
            super(BasicGroupListUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("layoutOrientation".equals(propertyChangeEvent.getPropertyName())) {
                BasicGroupListUI.this.updateLayoutStateNeeded = BasicGroupListUI.this.updateLayoutStateNeeded | 0x80;
                BasicGroupListUI.this.\u0111 = BasicGroupListUI.this.list.getLayoutOrientation();
                BasicGroupListUI.this.\u0102();
            } else if ("visibleRowCount".equals(string) || "preferredColumnCount".equals(string)) {
                if (BasicGroupListUI.this.\u0111 != 0) {
                    BasicGroupListUI.this.updateLayoutStateNeeded = BasicGroupListUI.this.updateLayoutStateNeeded | 0x80;
                    BasicGroupListUI.this.\u0102();
                }
            } else if ("componentOrientation".equals(string)) {
                BasicGroupListUI.this.updateLayoutStateNeeded = BasicGroupListUI.this.updateLayoutStateNeeded | 0x400;
                BasicGroupListUI.this.\u010e = BasicGroupListUI.this.list.getComponentOrientation().isLeftToRight();
                BasicGroupListUI.this.\u0102();
                InputMap inputMap = BasicGroupListUI.this.getInputMap(0);
                SwingUtilities.replaceUIInputMap(BasicGroupListUI.this.list, 0, inputMap);
            } else if ("groupCellSelectable".equals(string)) {
                BasicGroupListUI.this.\u0102();
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        }
    }

    public class ListSelectionHandler
    extends BasicListUI.ListSelectionHandler {
        public ListSelectionHandler() {
            super(BasicGroupListUI.this);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BasicGroupListUI.this.maybeUpdateLayoutState();
            if (!BasicGroupListUI.this.\u0112) {
                BasicGroupListUI.this.\u010b = BasicGroupListUI.this.\u0102(BasicGroupListUI.this.list.getSelectedIndex());
            }
            super.valueChanged(listSelectionEvent);
        }
    }
}

