/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.hssf;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.converter.PercentConverter;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellSpanTable;
import com.jidesoft.grid.CellStyleTable;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.ITreeTableModel;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.grid.TreeTableUtils;
import com.jidesoft.grid.ValueConverter;
import com.jidesoft.grid.ValueStringAdjustProvider;
import com.jidesoft.hssf.HssfTableFormat;
import com.jidesoft.hssf.HssfUtils;
import com.jidesoft.swing.StringConverter;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder;
import com.jidesoft.utils.ReflectionUtils;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class HssfTableUtils {
    private static final Logger \u0103 = Logger.getLogger(HssfTableUtils.class.getName());
    public static final String CLIENT_PROPERTY_EXCEL_OUTPUT_FORMAT = "ExcelOutputFormat:";
    public static final String CLIENT_PROPERTY_USE_SXSSF_WORKBOOK = "UseSXSSFWorkbook";
    public static final String CLIENT_PROPERTY_FLUSH_ROWS = "FlushRows";
    public static final String EXCEL_OUTPUT_FORMAT_2003 = "2003";
    public static final String EXCEL_OUTPUT_FORMAT_2007 = "2007";
    private static final int \u0101 = 65280;
    static com.jidesoft.grid.CellStyle \u0102 = new com.jidesoft.grid.CellStyle();
    static int \u0104 = 0;

    @Deprecated
    public static boolean isHssfInstalled() {
        try {
            Class.forName("org.apache.poi.hssf.usermodel.HSSFWorkbook");
            return true;
        }
        catch (Throwable throwable) {
            System.err.println("Error loading org.apache.poi.hssf.usermodel.HSSFWorkbook. The reason is that: " + throwable.getMessage());
            System.err.println("You must have POI-HSSF related jars in the classpath in order to use Excel HSSF exporting feature. Please download from http://poi.apache.org/spreadsheet/index.html and include the all the dependency jar files in the classpath.");
            return false;
        }
    }

    @Deprecated
    public static boolean isXssfInstalled() {
        try {
            Class.forName("org.apache.poi.xssf.usermodel.XSSFWorkbook");
            Class.forName("org.apache.poi.xssf.streaming.SXSSFWorkbook");
            return true;
        }
        catch (Throwable throwable) {
            System.err.println("Error loading org.apache.poi.xssf.usermodel.XSSFWorkbook or org.apache.poi.xssf.streaming.SXSSFWorkbook. The reason is that: " + throwable.getMessage());
            System.err.println("You must have POI-XSSF related jars (version 3.5 and after) in the classpath in order to use Excel XSSF exporting feature. Please download from http://poi.apache.org/spreadsheet/index.html and include the all the dependency jar files in the classpath.");
            return false;
        }
    }

    public static boolean export(JTable jTable, String string, String string2, boolean bl) throws IOException {
        return HssfTableUtils.export(jTable, string, string2, bl, true, null);
    }

    public static boolean export(JTable jTable, String string, String string2, boolean bl, boolean bl2) throws IOException {
        return HssfTableUtils.export(jTable, string, string2, bl, bl2, null);
    }

    public static boolean export(JTable jTable, String string, String string2, boolean bl, boolean bl2, CellValueConverter cellValueConverter) throws IOException {
        return HssfTableUtils.export(jTable, 0, 0, -1, -1, string, string2, bl, bl2, cellValueConverter);
    }

    public static boolean export(JTable jTable, int n2, int n3, int n4, int n5, String string, String string2, boolean bl, boolean bl2, CellValueConverter cellValueConverter) throws IOException {
        return HssfTableUtils.export(jTable, n2, n3, n4, n5, string, string2, bl, bl2, cellValueConverter, null);
    }

    public static boolean export(JTable jTable, int n2, int n3, int n4, int n5, String string, String string2, boolean bl, boolean bl2, CellValueConverter cellValueConverter, StringConverter stringConverter) throws IOException {
        return HssfTableUtils.export(jTable, n2, n3, n4, n5, string, string2, bl, bl2, cellValueConverter, stringConverter, null);
    }

    public static boolean export(JTable jTable, int n2, int n3, int n4, int n5, String string, String string2, boolean bl, boolean bl2, CellValueConverter cellValueConverter, StringConverter stringConverter, POICustomizer pOICustomizer) throws IOException {
        Object object;
        XSSFWorkbook xSSFWorkbook;
        if (!HssfUtils.isHssfInstalled()) {
            return false;
        }
        if (!new File(string).exists()) {
            bl = false;
        }
        if (EXCEL_OUTPUT_FORMAT_2007.equals(jTable.getClientProperty(CLIENT_PROPERTY_EXCEL_OUTPUT_FORMAT))) {
            xSSFWorkbook = bl ? new XSSFWorkbook((InputStream)new FileInputStream(string)) : new XSSFWorkbook();
            Object object2 = jTable.getClientProperty(CLIENT_PROPERTY_USE_SXSSF_WORKBOOK);
            if (object2 instanceof Boolean && ((Boolean)object2).booleanValue()) {
                object = jTable.getClientProperty(CLIENT_PROPERTY_FLUSH_ROWS);
                int n6 = 100;
                if (object instanceof Number) {
                    n6 = ((Number)object).intValue();
                }
                xSSFWorkbook = new SXSSFWorkbook(n6);
            }
        } else {
            xSSFWorkbook = bl ? new HSSFWorkbook((InputStream)new FileInputStream(string)) : new HSSFWorkbook();
        }
        boolean bl3 = xSSFWorkbook.getSheet(string2) != null;
        object = bl3 ? xSSFWorkbook.getSheet(string2) : xSSFWorkbook.createSheet(string2);
        HssfTableUtils.exportToSheet(jTable, n2, n3, n4, n5, (Workbook)xSSFWorkbook, object, 0, 0, bl2, cellValueConverter, stringConverter, pOICustomizer);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        xSSFWorkbook.write((OutputStream)fileOutputStream);
        fileOutputStream.close();
        return true;
    }

    public static boolean export(JTable jTable, OutputStream outputStream, String string) throws IOException {
        return HssfTableUtils.export(jTable, outputStream, string, true, null);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, String string, boolean bl) throws IOException {
        return HssfTableUtils.export(jTable, outputStream, string, bl, null);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, String string, boolean bl, CellValueConverter cellValueConverter) throws IOException {
        return HssfTableUtils.export(jTable, outputStream, 0, 0, -1, -1, string, bl, cellValueConverter);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, int n2, int n3, int n4, int n5, String string, boolean bl, CellValueConverter cellValueConverter) throws IOException {
        return HssfTableUtils.export(jTable, outputStream, n2, n3, n4, n5, string, bl, cellValueConverter, null);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, int n2, int n3, int n4, int n5, String string, boolean bl, CellValueConverter cellValueConverter, StringConverter stringConverter) throws IOException {
        return HssfTableUtils.export(jTable, outputStream, n2, n3, n4, n5, string, bl, cellValueConverter, stringConverter, null);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, int n2, int n3, int n4, int n5, String string, boolean bl, CellValueConverter cellValueConverter, StringConverter stringConverter, POICustomizer pOICustomizer) throws IOException {
        Object object;
        XSSFWorkbook xSSFWorkbook;
        if (!HssfUtils.isHssfInstalled()) {
            return false;
        }
        if (EXCEL_OUTPUT_FORMAT_2007.equals(jTable.getClientProperty(CLIENT_PROPERTY_EXCEL_OUTPUT_FORMAT))) {
            xSSFWorkbook = new XSSFWorkbook();
            Object object2 = jTable.getClientProperty(CLIENT_PROPERTY_USE_SXSSF_WORKBOOK);
            if (object2 instanceof Boolean && ((Boolean)object2).booleanValue()) {
                object = jTable.getClientProperty(CLIENT_PROPERTY_FLUSH_ROWS);
                int n6 = 100;
                if (object instanceof Number) {
                    n6 = ((Number)object).intValue();
                }
                xSSFWorkbook = new SXSSFWorkbook(n6);
            }
        } else {
            xSSFWorkbook = new HSSFWorkbook();
        }
        boolean bl2 = xSSFWorkbook.getSheet(string) != null;
        object = bl2 ? xSSFWorkbook.getSheet(string) : xSSFWorkbook.createSheet(string);
        HssfTableUtils.exportToSheet(jTable, n2, n3, n4, n5, (Workbook)xSSFWorkbook, object, 0, 0, bl, cellValueConverter, stringConverter, pOICustomizer);
        xSSFWorkbook.write(outputStream);
        outputStream.close();
        return true;
    }

    public static void exportToSheet(JTable jTable, Workbook workbook, Sheet sheet, int n2, int n3) {
        HssfTableUtils.exportToSheet(jTable, workbook, sheet, n2, n3, null);
    }

    public static void exportToSheet(JTable jTable, Workbook workbook, Sheet sheet, int n2, int n3, CellValueConverter cellValueConverter) {
        HssfTableUtils.exportToSheet(jTable, workbook, sheet, n2, n3, true, cellValueConverter);
    }

    public static void exportToSheet(JTable jTable, Workbook workbook, Sheet sheet, int n2, int n3, boolean bl) {
        HssfTableUtils.exportToSheet(jTable, workbook, sheet, n2, n3, bl, null);
    }

    public static void exportToSheet(JTable jTable, Workbook workbook, Sheet sheet, int n2, int n3, boolean bl, CellValueConverter cellValueConverter) {
        HssfTableUtils.exportToSheet(jTable, 0, 0, -1, -1, workbook, sheet, n2, n3, bl, cellValueConverter);
    }

    public static void exportToSheet(JTable jTable, Workbook workbook, Sheet sheet, int n2, int n3, boolean bl, CellValueConverter cellValueConverter, StringConverter stringConverter) {
        HssfTableUtils.exportToSheet(jTable, 0, 0, -1, -1, workbook, sheet, n2, n3, bl, cellValueConverter, stringConverter, null);
    }

    public static void exportToSheet(JTable jTable, int n2, int n3, int n4, int n5, Workbook workbook, Sheet sheet, int n6, int n7, boolean bl, CellValueConverter cellValueConverter) {
        HssfTableUtils.exportToSheet(jTable, n2, n3, n4, n5, workbook, sheet, n6, n7, bl, cellValueConverter, null, null);
    }

    public static void exportToSheet(JTable jTable, int n2, int n3, int n4, int n5, Workbook workbook, Sheet sheet, int n6, int n7, boolean bl, CellValueConverter cellValueConverter, StringConverter stringConverter, POICustomizer pOICustomizer) {
        HssfTableFormat hssfTableFormat = new HssfTableFormat();
        hssfTableFormat.setFirstRow(n2);
        hssfTableFormat.setFirstColumn(n3);
        hssfTableFormat.setNumberOfRows(n4);
        hssfTableFormat.setNumberOfColumns(n5);
        hssfTableFormat.setStartRow(n6);
        hssfTableFormat.setStartColumn(n7);
        hssfTableFormat.setIncludeTableHeader(bl);
        hssfTableFormat.setCellValueConverter(cellValueConverter);
        hssfTableFormat.setColumnNameConverter(stringConverter);
        hssfTableFormat.setPOICustomizer(pOICustomizer);
        HssfTableUtils.exportToSheet(jTable, workbook, sheet, hssfTableFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportToSheet(JTable jTable, Workbook workbook, Sheet sheet, HssfTableFormat hssfTableFormat) {
        if (hssfTableFormat == null) {
            return;
        }
        IExpandableTreeTableModel iExpandableTreeTableModel = null;
        Map<Object, Boolean> map = null;
        try {
            if (jTable instanceof TreeTable && (iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)TableModelWrapperUtils.getActualTableModel(jTable.getModel(), IExpandableTreeTableModel.class))) != null) {
                map = iExpandableTreeTableModel.getExpansionState();
            }
            Vector<Integer> vector = HssfTableUtils.\u0101(jTable, sheet, hssfTableFormat);
            HssfTableUtils.\u0101(jTable, false, vector, workbook, sheet, hssfTableFormat);
        }
        finally {
            if (iExpandableTreeTableModel != null && map != null) {
                iExpandableTreeTableModel.setExpansionState(map);
            }
        }
    }

    private static Vector<Integer> \u0101(JTable jTable, Sheet sheet, HssfTableFormat hssfTableFormat) {
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = hssfTableFormat.getNumberOfColumns();
        int n3 = hssfTableFormat.getNumberOfRows();
        int n4 = hssfTableFormat.getStartRow();
        int n5 = hssfTableFormat.getStartColumn();
        int n6 = hssfTableFormat.getFirstColumn();
        int n7 = hssfTableFormat.getFirstRow();
        CellValueConverter cellValueConverter = hssfTableFormat.getCellValueConverter();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i2 = jTable.getColumnCount() - 1; i2 >= 0; --i2) {
            if (tableColumnModel.getColumn(i2).getWidth() != 0) continue;
            hashSet.add(i2);
        }
        sheet.setRowSumsBelow(false);
        IExpandableTreeTableModel iExpandableTreeTableModel = null;
        if (jTable instanceof TreeTable && ((TreeTable)jTable).isExportCollapsedRowsToExcel()) {
            iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)TableModelWrapperUtils.getActualTableModel(jTable.getModel(), IExpandableTreeTableModel.class));
            if (jTable.getModel() instanceof ITreeTableModel && iExpandableTreeTableModel instanceof IExpandableTreeTableModel) {
                int n8;
                if (n7 < 0) {
                    n7 = 0;
                }
                com.jidesoft.grid.Row row = ((TreeTable)jTable).getRowAt(n7);
                com.jidesoft.grid.Row row2 = null;
                if (n3 > 0) {
                    n8 = Math.min(n7 + n3 - 1, jTable.getModel().getRowCount() - 1);
                    row2 = ((TreeTable)jTable).getRowAt(n8);
                }
                iExpandableTreeTableModel.expandAll();
                if (row != null) {
                    n7 = ((ITreeTableModel)((Object)jTable.getModel())).getRowIndex(row);
                }
                if (n7 < 0) {
                    n7 = 0;
                }
                n8 = -1;
                if (row2 != null) {
                    n8 = ((ITreeTableModel)((Object)jTable.getModel())).getRowIndex(row2);
                    int n9 = TreeTableUtils.getDescendantCount(jTable.getModel(), row2, false, true);
                    n8 += n9;
                }
                if (n8 < 0) {
                    n8 = jTable.getModel().getRowCount() - 1;
                }
                if (n7 <= n8) {
                    n3 = n8 - n7 + 1;
                }
            }
        }
        if (n2 == -1) {
            n2 = jTable.getColumnCount() - n6;
        }
        if (n3 == -1) {
            n3 = jTable.getRowCount() - n7;
        }
        for (int i3 = 0; i3 < n3 && n7 + i3 < jTable.getRowCount(); ++i3) {
            vector.add(i3);
        }
        hssfTableFormat.setStartRow(n4);
        hssfTableFormat.setFirstRow(n7);
        hssfTableFormat.setStartColumn(n5);
        hssfTableFormat.setFirstColumn(n6);
        hssfTableFormat.setNumberOfColumns(n2);
        hssfTableFormat.setNumberOfRows(n3);
        hssfTableFormat.setCellValueConverter(cellValueConverter);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void \u0101(JTable jTable, boolean bl, Vector<Integer> vector, Workbook workbook, Sheet sheet, HssfTableFormat hssfTableFormat) {
        int n2 = hssfTableFormat.getNumberOfColumns();
        int n3 = hssfTableFormat.getNumberOfRows();
        boolean bl2 = hssfTableFormat.isIncludeTableHeader();
        int n4 = hssfTableFormat.getStartRow();
        int n5 = hssfTableFormat.getStartColumn();
        int n6 = hssfTableFormat.getFirstColumn();
        int n7 = hssfTableFormat.getFirstRow();
        StringConverter stringConverter = hssfTableFormat.getColumnNameConverter();
        CellValueConverter cellValueConverter = hssfTableFormat.getCellValueConverter();
        POICustomizer pOICustomizer = hssfTableFormat.getPOICustomizer();
        IExpandableTreeTableModel iExpandableTreeTableModel = null;
        Map<Object, Boolean> map = null;
        HashMap<com.jidesoft.grid.CellStyle, Map<Integer, CellStyle>> hashMap = new HashMap<com.jidesoft.grid.CellStyle, Map<Integer, CellStyle>>();
        HashMap<String, Font> hashMap2 = new HashMap<String, Font>();
        HashMap<CellStyle, List<CellStyle>> hashMap3 = new HashMap<CellStyle, List<CellStyle>>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i2 = jTable.getColumnCount() - 1; i2 >= 0; --i2) {
            if (tableColumnModel.getColumn(i2).getWidth() != 0) continue;
            hashSet.add(i2);
        }
        TableModel tableModel = jTable.getModel();
        HashMap<Expandable, Integer> hashMap4 = null;
        jTable.putClientProperty("HssfTableUtils.HSSFWorkbook", workbook);
        sheet.setRowSumsBelow(false);
        try {
            int n8;
            NestedTableHeader nestedTableHeader;
            Object object;
            if (jTable instanceof TreeTable && ((TreeTable)jTable).isExportCollapsedRowsToExcel() && bl) {
                iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)TableModelWrapperUtils.getActualTableModel(jTable.getModel(), IExpandableTreeTableModel.class));
                if (jTable.getModel() instanceof ITreeTableModel && iExpandableTreeTableModel instanceof IExpandableTreeTableModel) {
                    map = iExpandableTreeTableModel.getExpansionState();
                    iExpandableTreeTableModel.expandAll();
                }
            }
            if (bl2) {
                Object object2;
                int n9 = HssfTableUtils.\u0102(jTable);
                object = HssfTableUtils.\u0101(jTable);
                if (object instanceof NestedTableHeader) {
                    int n10;
                    int n11;
                    nestedTableHeader = (NestedTableHeader)object;
                    n8 = nestedTableHeader.getRowCount();
                    for (int i3 = 0; i3 < n8; ++i3) {
                        Row row = sheet.getRow(n4 + i3);
                        if (row == null) {
                            row = sheet.createRow(n4 + i3);
                        }
                        n11 = -1;
                        for (n10 = 0; n10 < n2 && n6 + n10 < jTable.getColumnCount(); ++n10) {
                            StyledLabel styledLabel;
                            if (hashSet.contains(n10)) continue;
                            if ((object2 = row.getCell((int)((short)(++n11 + n5)))) == null) {
                                object2 = row.createCell((int)((short)(n11 + n5)));
                            }
                            String string = i3 == n8 - 1 ? jTable.getColumnName(n6 + n10) : "" + nestedTableHeader.getHeaderValueAt(n7 + i3, n6 + n10);
                            StyledLabel styledLabel2 = styledLabel = string == null ? null : StyledLabelBuilder.createStyledLabel(string);
                            if (styledLabel != null) {
                                string = styledLabel.getText();
                            }
                            object2.setCellValue(stringConverter != null ? stringConverter.convert(string) : string);
                            if (pOICustomizer == null) continue;
                            pOICustomizer.customizeHeaderCell((Cell)object2, (JTableHeader)object, i3, n10);
                        }
                    }
                    HashSet<Object> hashSet2 = new HashSet<Object>();
                    for (int i4 = 0; i4 < n8; ++i4) {
                        n11 = -1;
                        for (n10 = 0; n10 < n2 && n6 + n10 < jTable.getColumnCount(); ++n10) {
                            if (hashSet.contains(n10)) continue;
                            ++n11;
                            object2 = nestedTableHeader.getCellSpanAt(i4, n6 + n10);
                            if (i4 == n8 - 1 && i4 < n9 - 1) {
                                ((CellSpan)object2).setRowSpan(((CellSpan)object2).getRowSpan() + n9 - n8);
                            }
                            if (object2 == null || hashSet2.contains(object2) || ((CellSpan)object2).getRowSpan() == 1 && ((CellSpan)object2).getColumnSpan() == 1) continue;
                            int n12 = 0;
                            int n13 = ((CellSpan)object2).getColumn();
                            for (int i5 = ((CellSpan)object2).getColumnSpan() - 1; i5 >= 0; --i5) {
                                if (!hashSet.contains(i5 + n13)) continue;
                                ++n12;
                            }
                            hashSet2.add(object2);
                            HssfTableUtils.\u0101(sheet, (CellSpan)object2, 0, n6, ((CellSpan)object2).getRow(), ((CellSpan)object2).getColumn(), n8, n2, n4, n5, n11, n12);
                        }
                    }
                } else {
                    nestedTableHeader = sheet.getRow(n4);
                    if (nestedTableHeader == null) {
                        nestedTableHeader = sheet.createRow(n4);
                    }
                    int n14 = -1;
                    for (n8 = 0; n8 < n2 && n6 + n8 < jTable.getColumnCount(); ++n8) {
                        String string;
                        StyledLabel styledLabel;
                        Cell cell;
                        if (hashSet.contains(n8)) continue;
                        if ((cell = nestedTableHeader.getCell((short)(++n14 + n5))) == null) {
                            cell = nestedTableHeader.createCell((short)(n14 + n5));
                        }
                        StyledLabel styledLabel3 = styledLabel = (string = jTable.getColumnName(n6 + n8)) == null ? null : StyledLabelBuilder.createStyledLabel(string);
                        if (styledLabel != null) {
                            string = styledLabel.getText();
                        }
                        cell.setCellValue(stringConverter != null ? stringConverter.convert(string) : string);
                        if (pOICustomizer != null) {
                            pOICustomizer.customizeHeaderCell(cell, (JTableHeader)object, 0, n8);
                        }
                        if (n9 <= 1) continue;
                        object2 = new CellSpan(0, n8, n9, 1);
                        HssfTableUtils.\u0101(sheet, (CellSpan)object2, n7, n6, 0, n8, n9, n2, n4, n5, -1, -1);
                    }
                }
                n4 += n9;
            }
            Object object3 = vector.iterator();
            while (object3.hasNext()) {
                int n15 = object3.next();
                try {
                    nestedTableHeader = sheet.getRow(n15 + n4);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    \u0103.warning("Please try use XssfTableutils.export() to export to excel 2007 format if you have more than 65536 rows per sheet.");
                    break;
                }
                if (nestedTableHeader == null) {
                    nestedTableHeader = sheet.createRow(n15 + n4);
                }
                int n16 = -1;
                for (n8 = 0; n8 < n2 && n6 + n8 < jTable.getColumnCount(); ++n8) {
                    Object object4;
                    Cell cell;
                    int n17 = jTable.convertColumnIndexToModel(n6 + n8);
                    if (n17 == -1 || hashSet.contains(n8)) continue;
                    if ((cell = nestedTableHeader.getCell((short)(++n16 + n5))) == null) {
                        cell = nestedTableHeader.createCell((short)(n16 + n5));
                    }
                    if (jTable instanceof ValueStringAdjustProvider && ((ValueStringAdjustProvider)((Object)jTable)).needAdjustCellValueString(n7 + n15, n6 + n8)) {
                        object4 = ((ValueStringAdjustProvider)((Object)jTable)).getValueAtInString(n7 + n15, n6 + n8, cellValueConverter);
                    } else {
                        object4 = tableModel.getValueAt(n7 + n15, n17);
                        if (cellValueConverter != null && cellValueConverter.getDataFormat(jTable, object4 = cellValueConverter.convert(jTable, object4, n7 + n15, n6 + n8), n7 + n15, n6 + n8) == -1) {
                            object4 = jTable.getModel() instanceof ContextSensitiveTableModel ? ObjectConverterManager.toString(object4, ((ContextSensitiveTableModel)jTable.getModel()).getCellClassAt(n7 + n15, n17), ((ContextSensitiveTableModel)jTable.getModel()).getConverterContextAt(n7 + n15, n17)) : (object4 == null ? "" : object4.toString());
                        }
                    }
                    HssfTableUtils.\u0101(cell, object4);
                    cell.setCellStyle(HssfTableUtils.\u0101(workbook, jTable, n7 + n15, n6 + n8, object4, cellValueConverter, hashMap, hashMap3, hashMap2, hssfTableFormat));
                    if (pOICustomizer == null) continue;
                    pOICustomizer.customizeTableCell(cell, jTable, n7 + n15, n6 + n8);
                }
            }
            if (jTable instanceof CellSpanTable && ((CellSpanTable)jTable).isCellSpanOn()) {
                object3 = new HashSet();
                block16: for (int i6 = 0; i6 < n3 && n7 + i6 < jTable.getRowCount(); ++i6) {
                    int n18 = -1;
                    for (int i7 = 0; i7 < n2 && n6 + i7 < jTable.getColumnCount(); ++i7) {
                        Object object5;
                        Row row;
                        if (hashSet.contains(i7)) continue;
                        ++n18;
                        CellSpan cellSpan = ((CellSpanTable)jTable).getCellSpanAt(n7 + i6, i7);
                        if (cellSpan == null || object3.contains(cellSpan) || cellSpan.getRowSpan() == 1 && cellSpan.getColumnSpan() == 1) continue;
                        object3.add(cellSpan);
                        int n19 = 0;
                        int n20 = cellSpan.getColumn();
                        for (int i8 = cellSpan.getColumnSpan() - 1; i8 >= 0; --i8) {
                            if (!hashSet.contains(i8 + n20)) continue;
                            ++n19;
                        }
                        try {
                            row = sheet.getRow(i6 + n4);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            \u0103.warning("Please try use XssfTableUtils.export() to export to excel 2007 format if you have more than 65536 rows per sheet.");
                            continue block16;
                        }
                        Cell cell = row.getCell((int)((short)(n18 + n5)));
                        int n21 = jTable.convertColumnIndexToModel(cellSpan.getColumn());
                        if (n21 == -1) continue;
                        if (jTable instanceof ValueStringAdjustProvider && ((ValueStringAdjustProvider)((Object)jTable)).needAdjustCellValueString(n7 + i6, cellSpan.getColumn())) {
                            object5 = ((ValueStringAdjustProvider)((Object)jTable)).getValueAtInString(cellSpan.getRow(), cellSpan.getColumn(), cellValueConverter);
                        } else {
                            object5 = tableModel.getValueAt(cellSpan.getRow(), n21);
                            if (cellValueConverter != null && cellValueConverter.getDataFormat(jTable, object5 = cellValueConverter.convert(jTable, object5, cellSpan.getRow(), cellSpan.getColumn()), cellSpan.getRow(), cellSpan.getColumn()) == -1 && !(object5 instanceof String)) {
                                object5 = jTable.getModel() instanceof ContextSensitiveTableModel ? ObjectConverterManager.toString(object5, ((ContextSensitiveTableModel)jTable.getModel()).getCellClassAt(cellSpan.getRow(), n21), ((ContextSensitiveTableModel)jTable.getModel()).getConverterContextAt(cellSpan.getRow(), n21)) : (object5 == null ? "" : object5.toString());
                            }
                        }
                        HssfTableUtils.\u0101(cell, object5);
                        cell.setCellStyle(HssfTableUtils.\u0101(workbook, jTable, cellSpan.getRow(), cellSpan.getColumn(), object5, cellValueConverter, hashMap, hashMap3, hashMap2, hssfTableFormat));
                        HssfTableUtils.\u0101(sheet, cellSpan, n7, n6, i6, i7, n3, n2, n4, n5, n18, n19);
                        if (pOICustomizer == null) continue;
                        pOICustomizer.customizeTableCell(cell, jTable, cellSpan.getRow(), cellSpan.getColumn());
                    }
                }
            }
            if (jTable instanceof TreeTable && hssfTableFormat.isGroupExpandable()) {
                hashMap4 = new HashMap<Expandable, Integer>();
                for (int i9 = 0; i9 < n3 && n7 + i9 < jTable.getRowCount(); ++i9) {
                    int n22;
                    int n23;
                    object = ((TreeTable)jTable).getRowAt(n7 + i9);
                    if (!(object instanceof Expandable) || !((Expandable)object).hasChildren() || n4 + i9 + 1 > n4 + (n23 = Math.min(n7 + i9 + (n22 = TreeTableUtils.getDescendantCount(jTable.getModel(), object, false, false)), n7 + n3 - 1)) - n7) continue;
                    sheet.groupRow(n4 + i9 + 1, n4 + n23 - n7);
                    hashMap4.put((Expandable)object, n4 + i9 + 1);
                }
            }
            if (hssfTableFormat.isAutoSizeColumns()) {
                for (int n24 = 0; n24 < n2; n24 = (int)((short)(n24 + 1))) {
                    sheet.autoSizeColumn((int)((short)(n24 + n5)));
                }
            } else {
                TableColumnModel tableColumnModel2 = jTable.getColumnModel();
                int n25 = -1;
                for (int i10 = 0; i10 < n2 && n6 + i10 < jTable.getColumnCount(); ++i10) {
                    if (hashSet.contains(i10)) continue;
                    int n26 = tableColumnModel2.getColumn(n6 + i10).getWidth();
                    sheet.setColumnWidth(++n25 + n5, Math.min(n26 * 40, 65280));
                }
            }
            if (pOICustomizer != null) {
                pOICustomizer.customizeSheet(sheet, jTable);
            }
        }
        finally {
            hashMap.clear();
            hashMap2.clear();
            jTable.putClientProperty("HssfTableUtils.HSSFWorkbook", null);
            if (iExpandableTreeTableModel != null && map != null) {
                iExpandableTreeTableModel.setExpansionState(map);
            }
            if (hashMap4 != null) {
                Set set = hashMap4.keySet();
                for (Expandable expandable : set) {
                    if (!expandable.isExpandable() || expandable.isExpanded()) continue;
                    int n27 = (Integer)hashMap4.get(expandable);
                    sheet.setRowGroupCollapsed(n27, true);
                }
            }
        }
    }

    static JTableHeader \u0101(JTable jTable) {
        if (jTable == null) {
            return null;
        }
        Object object = jTable.getClientProperty("TableScrollPane.Parent");
        if (!(object instanceof TableScrollPane)) {
            return jTable.getTableHeader();
        }
        TableScrollPane tableScrollPane = (TableScrollPane)object;
        if (tableScrollPane.getRowHeaderTable() == jTable || tableScrollPane.getMainTable() == jTable || tableScrollPane.getRowFooterTable() == jTable) {
            return jTable.getTableHeader();
        }
        if (tableScrollPane.getRowHeaderColumnHeaderTable() == jTable) {
            return tableScrollPane.getRowHeaderTable().getTableHeader();
        }
        if (tableScrollPane.getColumnHeaderTable() == jTable) {
            return tableScrollPane.getMainTable().getTableHeader();
        }
        if (tableScrollPane.getRowFooterColumnHeaderTable() == jTable) {
            return tableScrollPane.getRowFooterTable().getTableHeader();
        }
        return jTable.getTableHeader();
    }

    static int \u0102(JTable jTable) {
        Object object;
        int n2 = 1;
        if (jTable.getTableHeader() instanceof NestedTableHeader) {
            n2 = ((NestedTableHeader)jTable.getTableHeader()).getRowCount();
        }
        if ((object = jTable.getClientProperty("TableScrollPane.Parent")) instanceof TableScrollPane) {
            int n3;
            TableScrollPane tableScrollPane = (TableScrollPane)object;
            if (tableScrollPane.getRowHeaderTable() != null && tableScrollPane.getRowHeaderTable().getTableHeader() instanceof NestedTableHeader && (n3 = ((NestedTableHeader)tableScrollPane.getRowHeaderTable().getTableHeader()).getRowCount()) >= n2) {
                n2 = n3;
            }
            if (tableScrollPane.getMainTable() != null && tableScrollPane.getMainTable().getTableHeader() instanceof NestedTableHeader && (n3 = ((NestedTableHeader)tableScrollPane.getMainTable().getTableHeader()).getRowCount()) >= n2) {
                n2 = n3;
            }
            if (tableScrollPane.getRowFooterTable() != null && tableScrollPane.getRowFooterTable().getTableHeader() instanceof NestedTableHeader && (n3 = ((NestedTableHeader)tableScrollPane.getRowFooterTable().getTableHeader()).getRowCount()) >= n2) {
                n2 = n3;
            }
        }
        return n2;
    }

    static void \u0101(Cell cell, Object object) {
        if (object instanceof Double) {
            cell.setCellValue(((Double)object).doubleValue());
        } else if (object instanceof Integer) {
            cell.setCellValue((double)((Integer)object).intValue());
        } else if (object instanceof Float) {
            cell.setCellValue((double)((Float)object).floatValue());
        } else if (object instanceof Long) {
            cell.setCellValue((double)((Long)object).longValue());
        } else if (object instanceof Short) {
            cell.setCellValue((double)((Short)object).shortValue());
        } else if (object instanceof Date) {
            cell.setCellValue((Date)object);
        } else if (object instanceof Calendar) {
            cell.setCellValue((Calendar)object);
        } else if (object instanceof Boolean) {
            cell.setCellValue(((Boolean)object).booleanValue());
        } else if (object instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)object).doubleValue());
        } else if (object != null) {
            cell.setCellValue(object.toString());
        } else {
            cell.setCellValue("");
        }
    }

    static void \u0101(Sheet sheet, CellSpan cellSpan, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        CellRangeAddress cellRangeAddress;
        n10 = n10 < 0 ? n5 : n10;
        int n12 = n8 + n4 + cellSpan.getRowSpan() - 1;
        if (cellSpan.getRow() < n2 + n4) {
            n12 -= n2 + n4 - cellSpan.getRow();
        }
        if (cellSpan.getRow() + cellSpan.getRowSpan() >= n2 + n6) {
            n12 -= cellSpan.getRow() + cellSpan.getRowSpan() - (n2 + n6);
        }
        int n13 = n9 + n10 + cellSpan.getColumnSpan() - 1;
        if (cellSpan.getColumn() < n3 + n5) {
            n13 -= n3 + n5 - cellSpan.getColumn();
        }
        if (cellSpan.getColumn() + cellSpan.getColumnSpan() >= n3 + n7) {
            n13 -= cellSpan.getColumn() + cellSpan.getColumnSpan() - (n3 + n7);
        }
        if (n11 > 0) {
            n13 -= n11;
        }
        if (n13 < n9 + n10) {
            n13 = n9 + n10;
        }
        if ((cellRangeAddress = new CellRangeAddress(n8 + n4, n12, n9 + n10, n13)).getNumberOfCells() > 1) {
            sheet.addMergedRegion(cellRangeAddress);
        }
    }

    public static void exportToCell(Sheet sheet, int n2, int n3, Object object) {
        Cell cell;
        Row row = sheet.getRow(n2);
        if (row == null) {
            row = sheet.createRow(n2);
        }
        if ((cell = row.getCell((int)((short)n3))) == null) {
            cell = row.createCell((int)((short)n3));
        }
        HssfTableUtils.\u0101(cell, object);
    }

    static CellStyle \u0101(Workbook workbook, JTable jTable, int n2, int n3, Object object, CellValueConverter cellValueConverter, Map<com.jidesoft.grid.CellStyle, Map<Integer, CellStyle>> map, Map<CellStyle, List<CellStyle>> map2, Map<String, Font> map3, HssfTableFormat hssfTableFormat) {
        short s2;
        Object object2;
        CellStyle cellStyle;
        Map<Integer, CellStyle> map4;
        int n4 = -1;
        if (cellValueConverter != null) {
            n4 = cellValueConverter.getDataFormat(jTable, object, n2, n3);
        }
        if ((map4 = map.get(\u0102)) == null) {
            map4 = new HashMap<Integer, CellStyle>();
            map.put(\u0102, map4);
        }
        if ((cellStyle = map4.get(n4)) == null) {
            cellStyle = HssfTableUtils.\u0101(workbook);
            cellStyle.setDataFormat((short)n4);
            map4.put(n4, cellStyle);
        }
        if (jTable instanceof CellStyleTable && ((CellStyleTable)jTable).getCellStyles(n2, n3).length > 0 && (object2 = ((CellStyleTable)jTable).getCellStyleAt(n2, n3)) != null) {
            try {
                object2 = ((com.jidesoft.grid.CellStyle)object2).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            Map<Integer, CellStyle> map5 = HssfTableUtils.\u0101(map, (com.jidesoft.grid.CellStyle)object2);
            if (map5 == null) {
                map5 = new HashMap<Integer, CellStyle>();
                map.put((com.jidesoft.grid.CellStyle)object2, map5);
            }
            if ((cellStyle = map5.get(n4)) == null) {
                cellStyle = HssfTableUtils.\u0101(workbook);
                cellStyle = HssfTableUtils.\u0101(workbook, cellStyle, (com.jidesoft.grid.CellStyle)object2, null, map3, hssfTableFormat);
                cellStyle.setDataFormat((short)n4);
                map5.put(n4, cellStyle);
            }
        }
        if (jTable instanceof TreeTable && ((TreeTable)jTable).getExpandableColumnViewIndex() == n3 && (object2 = ((TreeTable)jTable).getRowAt(n2)) != null && (s2 = (short)object2.getLevel()) > 0) {
            List<CellStyle> list = map2.get(cellStyle);
            if (list == null) {
                list = new ArrayList<CellStyle>();
                map2.put(cellStyle, list);
            }
            boolean bl = false;
            for (CellStyle cellStyle2 : list) {
                if (cellStyle2.getIndention() != s2) continue;
                cellStyle = cellStyle2;
                bl = true;
                break;
            }
            if (!bl) {
                CellStyle cellStyle3 = HssfTableUtils.\u0101(workbook);
                cellStyle3.cloneStyleFrom(cellStyle);
                cellStyle3.setIndention(s2);
                list.add(cellStyle3);
                cellStyle = cellStyle3;
            }
        }
        return cellStyle;
    }

    private static Map<Integer, CellStyle> \u0101(Map<com.jidesoft.grid.CellStyle, Map<Integer, CellStyle>> map, com.jidesoft.grid.CellStyle cellStyle) {
        Map<Integer, CellStyle> map2 = map.get(cellStyle);
        if (map2 == null) {
            for (com.jidesoft.grid.CellStyle cellStyle2 : map.keySet()) {
                if (cellStyle2 == null || !cellStyle2.equalsForExporting(cellStyle)) continue;
                map2 = map.get(cellStyle2);
                break;
            }
        }
        return map2;
    }

    static CellStyle \u0101(Workbook workbook, CellStyle cellStyle, com.jidesoft.grid.CellStyle cellStyle2, String string, Map<String, Font> map, HssfTableFormat hssfTableFormat) {
        Color color;
        Font font = map.get(string);
        boolean bl = false;
        if (cellStyle2.getFont() != null) {
            if (font == null) {
                font = HssfTableUtils.\u0102(workbook);
                map.put("" + font.hashCode(), font);
            }
            font.setFontName(cellStyle2.getFont().getFontName());
            if (cellStyle2.getFont().getStyle() == 1) {
                font.setBold(true);
            }
            font.setItalic(cellStyle2.getFont().getStyle() == 2);
            bl = true;
        }
        if ((color = cellStyle2.getForeground()) != null) {
            if (font == null) {
                font = HssfTableUtils.\u0102(workbook);
                map.put("" + font.hashCode(), font);
            }
            if (workbook.getClass().getName().contains("XSSF")) {
                if (Color.BLACK.equals(color)) {
                    color = Color.WHITE;
                } else if (Color.WHITE.equals(color)) {
                    color = Color.BLACK;
                }
                try {
                    ReflectionUtils.callSet(font, "setColor", ReflectionUtils.callConstructor(Class.forName("org.apache.poi.xssf.usermodel.XSSFColor"), new Class[]{Color.class}, new Object[]{color}));
                }
                catch (Exception exception) {}
            } else {
                font.setColor(HssfTableUtils.\u0101(workbook, color));
            }
            bl = true;
        }
        if (cellStyle2.getFontStyle() != -1) {
            int n2;
            if (font == null) {
                font = HssfTableUtils.\u0102(workbook);
                map.put("" + font.hashCode(), font);
            }
            font.setItalic(((n2 = cellStyle2.getFontStyle()) & 2) != 0);
            font.setBold((n2 & 1) != 0);
            bl = true;
        }
        if (bl) {
            cellStyle.setFont(font);
        }
        if (cellStyle2.getBackground() != null) {
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            if (workbook.getClass().getName().contains("XSSF")) {
                try {
                    ReflectionUtils.callSet(cellStyle, "setFillForegroundColor", ReflectionUtils.callConstructor(Class.forName("org.apache.poi.xssf.usermodel.XSSFColor"), new Class[]{Color.class}, new Object[]{cellStyle2.getBackground()}));
                }
                catch (Exception exception) {}
            } else {
                cellStyle.setFillForegroundColor(HssfTableUtils.\u0101(workbook, cellStyle2.getBackground()));
            }
        }
        if (cellStyle2.getHorizontalAlignment() != -1) {
            cellStyle.setAlignment(HssfTableUtils.\u0102(cellStyle2.getHorizontalAlignment()));
        }
        if (cellStyle2.getVerticalAlignment() != -1) {
            cellStyle.setVerticalAlignment(HssfTableUtils.\u0101(cellStyle2.getVerticalAlignment()));
        }
        BorderStyle[] borderStyleArray = BorderStyle.values();
        cellStyle.setBorderBottom(borderStyleArray[hssfTableFormat.getBottomBorder()]);
        cellStyle.setBorderTop(borderStyleArray[hssfTableFormat.getTopBorder()]);
        cellStyle.setBorderLeft(borderStyleArray[hssfTableFormat.getLeftBorder()]);
        cellStyle.setBorderRight(borderStyleArray[hssfTableFormat.getRightBorder()]);
        return cellStyle;
    }

    static HorizontalAlignment \u0102(int n2) {
        switch (n2) {
            case 0: {
                return HorizontalAlignment.CENTER;
            }
            case 2: 
            case 10: {
                return HorizontalAlignment.LEFT;
            }
            case 4: 
            case 11: {
                return HorizontalAlignment.RIGHT;
            }
        }
        return HorizontalAlignment.GENERAL;
    }

    static VerticalAlignment \u0101(int n2) {
        switch (n2) {
            case 0: {
                return VerticalAlignment.CENTER;
            }
            case 1: {
                return VerticalAlignment.TOP;
            }
            case 3: {
                return VerticalAlignment.BOTTOM;
            }
        }
        return VerticalAlignment.JUSTIFY;
    }

    static Font \u0102(Workbook workbook) {
        return workbook.createFont();
    }

    static CellStyle \u0101(Workbook workbook) {
        ++\u0104;
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.GENERAL);
        cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
        return cellStyle;
    }

    private static short \u0101(Workbook workbook, Color color) {
        Map map = HSSFColor.getIndexHash();
        Set set = map.keySet();
        double d2 = Double.MAX_VALUE;
        short s2 = -1;
        for (Object k2 : set) {
            HSSFColor hSSFColor;
            short[] sArray;
            double d3;
            if (!(k2 instanceof Integer) || !((d3 = Math.sqrt((sArray = (hSSFColor = (HSSFColor)map.get(k2)).getTriplet())[0] - color.getRed()) + Math.sqrt(sArray[1] - color.getGreen()) + Math.sqrt(sArray[2] - color.getBlue())) < d2)) continue;
            d2 = d3;
            s2 = ((Integer)k2).shortValue();
        }
        if (s2 != -1) {
            return s2;
        }
        return HSSFColor.AUTOMATIC.index;
    }

    public static class ContextSensitiveCellValueConverter
    implements CellValueConverter {
        @Override
        public Object convert(JTable jTable, Object object, int n2, int n3) {
            ObjectConverter objectConverter;
            ContextSensitiveTableModel contextSensitiveTableModel = (ContextSensitiveTableModel)TableModelWrapperUtils.getActualTableModel(jTable.getModel(), ContextSensitiveTableModel.class);
            if (contextSensitiveTableModel == null) {
                return object;
            }
            ConverterContext converterContext = contextSensitiveTableModel.getConverterContextAt(n2, jTable.convertColumnIndexToModel(n3));
            if (converterContext != null && object != null && (objectConverter = ObjectConverterManager.getConverter(object.getClass(), converterContext)) != null && objectConverter.supportToString(object, converterContext)) {
                return objectConverter.toString(object, converterContext);
            }
            return object;
        }

        @Override
        public int getDataFormat(JTable jTable, Object object, int n2, int n3) {
            ConverterContext converterContext;
            ContextSensitiveTableModel contextSensitiveTableModel = (ContextSensitiveTableModel)TableModelWrapperUtils.getActualTableModel(jTable.getModel(), ContextSensitiveTableModel.class);
            if (contextSensitiveTableModel != null && (converterContext = contextSensitiveTableModel.getConverterContextAt(n2, jTable.convertColumnIndexToModel(n3))) != null && object != null) {
                if (PercentConverter.CONTEXT.equals(converterContext)) {
                    return 9;
                }
                if (PercentConverter.CONTEXT_FRACTION_NUMBER.equals(converterContext)) {
                    return 10;
                }
            }
            if (object instanceof Double) {
                return 2;
            }
            if (object instanceof Date) {
                return 14;
            }
            return -1;
        }
    }

    public static class DefaultCellValueConverter
    implements CellValueConverter {
        @Override
        public Object convert(JTable jTable, Object object, int n2, int n3) {
            return object;
        }

        @Override
        public int getDataFormat(JTable jTable, Object object, int n2, int n3) {
            return -1;
        }
    }

    public static interface CellValueConverter
    extends ValueConverter {
        public int getDataFormat(JTable var1, Object var2, int var3, int var4);
    }

    public static interface POICustomizer {
        public void customizeTableCell(Cell var1, JTable var2, int var3, int var4);

        public void customizeHeaderCell(Cell var1, JTableHeader var2, int var3, int var4);

        public void customizeSheet(Sheet var1, JTable var2);
    }
}

