/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.SummaryCalculator;
import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.BooleanRange;
import com.jidesoft.range.IntegerRange;
import com.jidesoft.range.LongRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.StringRange;
import com.jidesoft.range.TimeRange;
import com.jidesoft.utils.BigDecimalMathUtils;
import com.jidesoft.utils.BooleanUtils;
import com.jidesoft.utils.DateUtils;
import com.jidesoft.utils.MathUtils;
import com.jidesoft.utils.StringUtils;
import com.jidesoft.utils.TypeUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class DefaultSummaryCalculator
implements SummaryCalculator,
Cloneable {
    private List<Number> \u0105 = new Vector<Number>();
    private List<Date> \u0101 = new Vector<Date>();
    private List<Calendar> \u0103 = new Vector<Calendar>();
    private List<BigDecimal> \u0109 = new Vector<BigDecimal>();
    private List<String> \u0107 = new Vector<String>();
    private List<Boolean> \u0104 = new Vector<Boolean>();
    private MathContext \u0102;
    private Class<?> \u0108;
    protected long _count = 0L;
    private boolean \u0106 = true;

    public Object clone() throws CloneNotSupportedException {
        DefaultSummaryCalculator defaultSummaryCalculator = (DefaultSummaryCalculator)super.clone();
        defaultSummaryCalculator.\u0105 = new Vector<Number>();
        defaultSummaryCalculator.\u0101 = new Vector<Date>();
        defaultSummaryCalculator.\u0103 = new Vector<Calendar>();
        defaultSummaryCalculator.\u0109 = new Vector<BigDecimal>();
        defaultSummaryCalculator.\u0107 = new Vector<String>();
        defaultSummaryCalculator.\u0104 = new Vector<Boolean>();
        defaultSummaryCalculator.\u0102 = new MathContext(8);
        return defaultSummaryCalculator;
    }

    @Override
    public void addValue(Object object) {
        if (object instanceof BigDecimal) {
            if (this.\u0102 == null) {
                this.\u0102 = new MathContext(8);
            }
            this.\u0109.add((BigDecimal)object);
            ++this._count;
        } else if (object instanceof Number) {
            this.\u0105.add(((Number)object).doubleValue());
            this.\u0108 = object.getClass();
            ++this._count;
        } else if (object instanceof Date) {
            this.\u0101.add((Date)object);
            ++this._count;
        } else if (object instanceof Calendar) {
            this.\u0103.add((Calendar)object);
            ++this._count;
        } else if (object instanceof String) {
            this.\u0107.add((String)object);
            ++this._count;
        } else if (object instanceof Boolean) {
            this.\u0104.add((Boolean)object);
            ++this._count;
        } else if (object instanceof AbstractNumericRange) {
            this.\u0105.add(((AbstractNumericRange)object).minimum());
            this.\u0105.add(((AbstractNumericRange)object).maximum());
            if (object instanceof IntegerRange) {
                this.\u0108 = Integer.class;
            }
            if (object instanceof LongRange) {
                this.\u0108 = Long.class;
            } else if (object instanceof NumericRange) {
                this.\u0108 = Double.class;
            }
            ++this._count;
        } else if (object instanceof TimeRange) {
            this.\u0101.add(((TimeRange)object).lower());
            this.\u0101.add(((TimeRange)object).upper());
            this.\u0108 = Date.class;
            ++this._count;
        } else if (object instanceof StringRange) {
            this.\u0107.add(((StringRange)object).lower());
            this.\u0107.add(((StringRange)object).upper());
            this.\u0108 = String.class;
            ++this._count;
        } else if (object instanceof BooleanRange) {
            this.\u0104.add(((BooleanRange)object).lower());
            this.\u0104.add(((BooleanRange)object).upper());
            this.\u0108 = Boolean.class;
            ++this._count;
        }
    }

    @Override
    public void clear() {
        if (this.\u0105 != null) {
            this.\u0105.clear();
        }
        if (this.\u0101 != null) {
            this.\u0101.clear();
        }
        if (this.\u0103 != null) {
            this.\u0103.clear();
        }
        if (this.\u0109 != null) {
            this.\u0109.clear();
        }
        if (this.\u0107 != null) {
            this.\u0107.clear();
        }
        if (this.\u0104 != null) {
            this.\u0104.clear();
        }
        this._count = 0L;
    }

    @Override
    public long getCount() {
        return this._count;
    }

    @Override
    public int getNumberOfSummaries() {
        return 7;
    }

    @Override
    public String getSummaryName(Locale locale, int n2) {
        switch (n2) {
            case 0: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Sum");
            }
            case 1: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Max");
            }
            case 2: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Min");
            }
            case 3: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Mean");
            }
            case 4: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Var");
            }
            case 5: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.StdDev");
            }
            case 6: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Count");
            }
            case 7: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Constant");
            }
            case -2: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.None");
            }
        }
        return "";
    }

    @Override
    public Object getSummaryResult(int n2) {
        if (n2 == 6) {
            return this.getCount();
        }
        if (n2 == -2) {
            return null;
        }
        if (this.\u0105 != null && this.\u0105.size() > 0) {
            switch (n2) {
                case 3: {
                    int n3 = this.\u0105.size();
                    while ((long)n3 < this._count) {
                        this.\u0105.add(0);
                        ++n3;
                    }
                    return MathUtils.mean(this.\u0105);
                }
                case 2: {
                    double d2 = MathUtils.min(this.\u0105);
                    if (this.\u0108 == Integer.TYPE || this.\u0108 == Integer.class) {
                        return (int)d2;
                    }
                    if (this.\u0108 == Long.TYPE || this.\u0108 == Long.class) {
                        return (long)d2;
                    }
                    if (this.\u0108 == Short.TYPE || this.\u0108 == Short.class) {
                        return (short)d2;
                    }
                    if (this.\u0108 == Byte.TYPE || this.\u0108 == Byte.class) {
                        return (byte)d2;
                    }
                    if (this.\u0108 == Float.TYPE || this.\u0108 == Float.class) {
                        return Float.valueOf((float)d2);
                    }
                    return d2;
                }
                case 1: {
                    double d3 = MathUtils.max(this.\u0105);
                    if (this.\u0108 == Integer.TYPE || this.\u0108 == Integer.class) {
                        return (int)d3;
                    }
                    if (this.\u0108 == Long.TYPE || this.\u0108 == Long.class) {
                        return (long)d3;
                    }
                    if (this.\u0108 == Short.TYPE || this.\u0108 == Short.class) {
                        return (short)d3;
                    }
                    if (this.\u0108 == Byte.TYPE || this.\u0108 == Byte.class) {
                        return (byte)d3;
                    }
                    if (this.\u0108 == Float.TYPE || this.\u0108 == Float.class) {
                        return Float.valueOf((float)d3);
                    }
                    return d3;
                }
                case 0: {
                    return MathUtils.sum(this.\u0105);
                }
                case 5: {
                    return MathUtils.stddev(this.\u0105, this.isBiasCorrected());
                }
                case 4: {
                    return MathUtils.var(this.\u0105, this.isBiasCorrected());
                }
                case 7: {
                    if (this.\u0108 == Integer.TYPE || this.\u0108 == Integer.class) {
                        return MathUtils.rangeInteger(this.\u0105);
                    }
                    if (this.\u0108 == Long.TYPE || this.\u0108 == Long.class) {
                        return MathUtils.rangeLong(this.\u0105);
                    }
                    return MathUtils.range(this.\u0105);
                }
            }
            return MathUtils.sum(this.\u0105);
        }
        if (this.\u0101 != null && this.\u0101.size() > 0) {
            switch (n2) {
                case 2: {
                    return DateUtils.minDates(this.\u0101);
                }
                case 1: {
                    return DateUtils.maxDates(this.\u0101);
                }
                case 7: {
                    return DateUtils.rangeDates(this.\u0101);
                }
            }
            return null;
        }
        if (this.\u0103 != null && this.\u0103.size() > 0) {
            switch (n2) {
                case 2: {
                    return DateUtils.minCalendars(this.\u0103);
                }
                case 1: {
                    return DateUtils.maxCalendars(this.\u0103);
                }
                case 7: {
                    return DateUtils.rangeCalendars(this.\u0103);
                }
            }
            return null;
        }
        if (this.\u0109 != null && this.\u0109.size() > 0) {
            switch (n2) {
                case 3: {
                    int n4 = this.\u0109.size();
                    while ((long)n4 < this._count) {
                        this.\u0109.add(new BigDecimal(0));
                        ++n4;
                    }
                    return BigDecimalMathUtils.mean(this.\u0109, this.getMathContext());
                }
                case 2: {
                    return BigDecimalMathUtils.min(this.\u0109);
                }
                case 1: {
                    return BigDecimalMathUtils.max(this.\u0109);
                }
                case 0: {
                    return BigDecimalMathUtils.sum(this.\u0109);
                }
                case 5: {
                    return BigDecimalMathUtils.stddev(this.\u0109, this.isBiasCorrected(), this.getMathContext());
                }
                case 4: {
                    return BigDecimalMathUtils.var(this.\u0109, this.isBiasCorrected(), this.getMathContext());
                }
                case 7: {
                    return BigDecimalMathUtils.range(this.\u0109);
                }
            }
            return BigDecimalMathUtils.sum(this.\u0109);
        }
        if (this.\u0107 != null && this.\u0107.size() > 0) {
            switch (n2) {
                case 2: {
                    return StringUtils.min(this.\u0107);
                }
                case 1: {
                    return StringUtils.max(this.\u0107);
                }
                case 7: {
                    return StringUtils.range(this.\u0107);
                }
            }
            return null;
        }
        if (this.\u0104 != null && this.\u0104.size() > 0) {
            switch (n2) {
                case 2: {
                    return BooleanUtils.min(this.\u0104);
                }
                case 1: {
                    return BooleanUtils.max(this.\u0104);
                }
                case 7: {
                    return BooleanUtils.range(this.\u0104);
                }
            }
            return null;
        }
        return null;
    }

    public boolean isBiasCorrected() {
        return this.\u0106;
    }

    public void setBiasCorrected(boolean bl) {
        this.\u0106 = bl;
    }

    public MathContext getMathContext() {
        return this.\u0102;
    }

    public void setMathContext(MathContext mathContext) {
        this.\u0102 = mathContext;
    }

    @Override
    public int[] getAllowedSummaries(Class<?> clazz) {
        return this.getAllowedSummaries(clazz, null);
    }

    @Override
    public int[] getAllowedSummaries(Class<?> clazz, ConverterContext converterContext) {
        if (clazz == null) {
            return new int[0];
        }
        if (TypeUtils.isNumericType(clazz)) {
            return ALLOWED_SUMMARIES_ALL;
        }
        if (TypeUtils.isStringType(clazz)) {
            return ALLOWED_SUMMARIES_MAX_MIN_COUNT;
        }
        if (TypeUtils.isBooleanType(clazz)) {
            return ALLOWED_SUMMARIES_MAX_MIN_COUNT;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return ALLOWED_SUMMARIES_MAX_MIN_COUNT;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return ALLOWED_SUMMARIES_MAX_MIN_COUNT;
        }
        return ALLOWED_SUMMARIES_COUNT;
    }
}

