/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.gauge.AbstractGauge;
import com.jidesoft.gauge.NeedleEndShape;
import com.jidesoft.gauge.NeedleFillFactory;
import com.jidesoft.gauge.NeedleRenderer;
import com.jidesoft.gauge.NeedleStyle;
import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.swing.ShadowRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public class DefaultNeedleRenderer
implements NeedleRenderer {
    private ShadowRenderer \u0103 = new ShadowFactory();
    private NeedleFillFactory \u0102 = new A();
    private BufferedImage \u0101 = null;

    public DefaultNeedleRenderer() {
        ShadowFactory shadowFactory = new ShadowFactory();
        shadowFactory.setRenderingHint("blur_quality", "fast");
        this.setShadowRenderer(shadowFactory);
    }

    public ShadowRenderer getShadowRenderer() {
        return this.\u0103;
    }

    public void setShadowRenderer(ShadowRenderer shadowRenderer) {
        if (shadowRenderer == null) {
            throw new NullPointerException("Shadow Renderer cannot be null");
        }
        this.\u0103 = shadowRenderer;
    }

    @Override
    public Shape paintNeedle(Graphics2D graphics2D, AbstractGauge abstractGauge, Double d2, double d3, double d4, double d5, double d6, NeedleStyle needleStyle) {
        Shape shape = this.\u0101(d5, d3, d4, d6, needleStyle);
        Rectangle rectangle = shape.getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            if (abstractGauge.isShadowVisible()) {
                BasicStroke basicStroke = needleStyle.getOutlineStroke();
                if (basicStroke == null) {
                    basicStroke = new BasicStroke(1.0f);
                }
                float f2 = basicStroke.getLineWidth();
                rectangle = new Rectangle((int)((float)rectangle.x - f2), (int)((float)rectangle.y - f2), (int)((float)rectangle.width + 2.0f * f2), (int)((float)rectangle.height + 2.0f * f2));
                if (this.\u0101 != null && this.\u0101.getWidth() == rectangle.width && this.\u0101.getHeight() == rectangle.height) {
                    ChartUtils.clearBufferedImage(this.\u0101, Color.black);
                } else {
                    this.\u0101 = new BufferedImage(rectangle.width, rectangle.height, 2);
                }
                Graphics2D graphics2D2 = (Graphics2D)this.\u0101.getGraphics();
                graphics2D2.translate(-rectangle.x, -rectangle.y);
                graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.\u0101(graphics2D2, shape, d2, d3, d4, d5, d6, needleStyle);
                BufferedImage bufferedImage = this.\u0103.createShadow(this.\u0101);
                graphics2D.translate(rectangle.x, rectangle.y);
                graphics2D.drawImage((Image)bufferedImage, 0, 0, abstractGauge);
                graphics2D.drawImage((Image)this.\u0101, 0, 0, abstractGauge);
                graphics2D.translate(-rectangle.x, -rectangle.y);
                graphics2D2.dispose();
            } else {
                this.\u0101(graphics2D, shape, d2, d3, d4, d5, d6, needleStyle);
            }
        }
        return shape;
    }

    private Shape \u0101(double d2, double d3, double d4, double d5, NeedleStyle needleStyle) {
        double d6 = d5 * needleStyle.getBaseWidth();
        double d7 = d5 * needleStyle.getHeadLength();
        double d8 = d5 * needleStyle.getTailLength();
        double d9 = d5 * needleStyle.getHeadWidth();
        double d10 = d5 * needleStyle.getTailWidth();
        GeneralPath generalPath = this.\u0101(d2, d3, d4, d7, d6, d9, needleStyle.getHeadShape());
        GeneralPath generalPath2 = this.\u0101(d2 - 180.0, d3, d4, d8, d6, d10, needleStyle.getTailShape());
        generalPath.append(generalPath2, true);
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath \u0101(double d2, double d3, double d4, double d5, double d6, double d7, NeedleEndShape needleEndShape) {
        GeneralPath generalPath = new GeneralPath();
        double d8 = Math.toRadians(d2);
        double d9 = d3 - 0.5 * d6 * Math.sin(d8);
        double d10 = d4 - 0.5 * d6 * Math.cos(d8);
        double d11 = d3 + 0.5 * d6 * Math.sin(d8);
        double d12 = d4 + 0.5 * d6 * Math.cos(d8);
        double d13 = d3 + d5 * Math.cos(d8);
        double d14 = d4 - d5 * Math.sin(d8);
        double d15 = d13 + 0.5 * d7 * Math.sin(d8);
        double d16 = d14 + 0.5 * d7 * Math.cos(d8);
        double d17 = d13 - 0.5 * d7 * Math.sin(d8);
        double d18 = d14 - 0.5 * d7 * Math.cos(d8);
        generalPath.moveTo(d11, d12);
        generalPath.lineTo(d15, d16);
        if (needleEndShape == NeedleEndShape.ROUND) {
            Arc2D.Double double_ = new Arc2D.Double(d13 - d7 / 2.0, d14 - d7 / 2.0, d7, d7, d2 - 90.0, 180.0, 0);
            generalPath.append(double_, true);
        } else if (needleEndShape == NeedleEndShape.TRIANGULAR) {
            double d19 = d3 + (d5 + d7) * Math.cos(d8);
            double d20 = d4 - (d5 + d7) * Math.sin(d8);
            generalPath.lineTo(d19, d20);
            generalPath.lineTo(d17, d18);
        }
        generalPath.lineTo(d17, d18);
        generalPath.lineTo(d9, d10);
        return generalPath;
    }

    private void \u0101(Graphics2D graphics2D, Shape shape, Double d2, double d3, double d4, double d5, double d6, NeedleStyle needleStyle) {
        Color color = needleStyle.getOutlineColor();
        Paint paint = this.\u0102.createNeedleFill(d2, d3, d4, d5, d6, needleStyle);
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(shape);
        }
        if (color != null) {
            graphics2D.setColor(color);
            BasicStroke basicStroke = needleStyle.getOutlineStroke();
            if (basicStroke == null) {
                basicStroke = new BasicStroke(1.0f);
            }
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(shape);
        }
    }

    static class A
    implements NeedleFillFactory {
        A() {
        }

        @Override
        public Paint createNeedleFill(Double d2, double d3, double d4, double d5, double d6, NeedleStyle needleStyle) {
            return needleStyle.getFillPaint();
        }
    }
}

